#include "camera.h"

Camera::Camera() : Object(), player(NULL) {
	min.x = 160.0f;
	min.y = 120.0f;
	max.x = 864.0f;
	max.y = 648.0f;
}


Camera::~Camera() {
	TRACE("Camera::~Camera()\n");
}


void Camera::Update() {
	v.x = (player->pos.x - pos.x)/20.0f;
	v.y = (player->pos.y - pos.y)/20.0f;
	Object::Update();
}


void Camera::SetPlayer(Player *p) {
	player = p;
}
