#include <allegro.h>
#include "params.h"

int Params::w = 320;
int Params::h = 240;
int Params::bpp = 32;
int Params::fullscreen = 1;
int Params::vsync = 0;
int Params::fps = 60;
int Params::unlimitedFPS = 1;
int Params::showFPS = 0;
int Params::yield = 0;
int Params::driver = 0;

float Params::acc = 0.04f;
float Params::dec = 0.98f;
int Params::rad = 16;
int Params::hp1 = 45;
int Params::hp2 = 10;
int Params::spawnTime = 300;
int Params::maxParticles = 40;
int Params::difficulty = 1;
int Params::nStars = 300;
int Params::volSound = 125;
int Params::volMusic = 125;


void Params::Load(const char *file) {
	set_config_file(file);
	
	w = get_config_int("GENERAL", "w", w);
	h = get_config_int("GENERAL", "h", h);
	bpp = get_config_int("GENERAL", "bpp", bpp);
	fullscreen = get_config_int("GENERAL", "fullscreen", fullscreen);
	vsync = get_config_int("GENERAL", "vsync", vsync);
	fps = get_config_int("SPEED", "fps", fps);
	unlimitedFPS = get_config_int("SPEED", "unlimitedFPS", unlimitedFPS);
	showFPS = get_config_int("SPEED", "showFPS", showFPS);
	yield = get_config_int("GENERAL", "yield", yield);
	driver = get_config_int("GENERAL", "driver", driver);

	acc = get_config_float("UNBORN", "acc", acc);
	dec = get_config_float("UNBORN", "dec", dec);
	rad = get_config_int("UNBORN", "rad", rad);
	hp1 = get_config_int("UNBORN", "hp1", hp1);
	hp2 = get_config_int("UNBORN", "hp2", hp2);
	spawnTime = get_config_int("UNBORN", "spawnTime", spawnTime);
	maxParticles = get_config_int("UNBORN", "maxParticles", maxParticles);
	difficulty = get_config_int("UNBORN", "difficulty", difficulty);
	nStars = get_config_int("UNBORN", "nStars", nStars);
	volSound = get_config_int("UNBORN", "volSound", volSound);
	volMusic = get_config_int("UNBORN", "volMusic", volMusic);
}


void Params::Save(const char *file) {
	set_config_file(file);
	
	set_config_int("GENERAL", "w", w);
	set_config_int("GENERAL", "h", h);
	set_config_int("GENERAL", "bpp", bpp);
	set_config_int("GENERAL", "fullscreen", fullscreen);
	set_config_int("GENERAL", "vsync", vsync);
	set_config_int("SPEED", "fps", fps);
	set_config_int("SPEED", "unlimitedFPS", unlimitedFPS);
	set_config_int("SPEED", "showFPS", showFPS);
	set_config_int("GENERAL", "yield", yield);
	set_config_int("GENERAL", "driver", driver);

	set_config_float("UNBORN", "acc", acc);
	set_config_float("UNBORN", "dec", dec);
	set_config_int("UNBORN", "rad", rad);
	set_config_int("UNBORN", "hp1", hp1);
	set_config_int("UNBORN", "hp2", hp2);
	set_config_int("UNBORN", "spawnTime", spawnTime);
	set_config_int("UNBORN", "maxParticles", maxParticles);
	set_config_int("UNBORN", "difficulty", difficulty);
	set_config_int("UNBORN", "nStars", nStars);
	set_config_int("UNBORN", "volSound", volSound);
	set_config_int("UNBORN", "volMusic", volMusic);
	
	flush_config_file();
}
