#ifndef			PAGEFLIPPING_H
#define			PAGEFLIPPING_H

#include "screenupdate.h"

class PageFlipping : public ScreenUpdate {
	protected:
		BITMAP *page1;
		BITMAP *page2;
		BITMAP *active;
	
	public:
		PageFlipping();
		virtual ~PageFlipping();
	
		Error Create();
		void Destroy();
		void Draw();
		BITMAP *GetCanvas() { return active; }
		void AcquireCanvas() { acquire_bitmap(active); }
		void ReleaseCanvas() { release_bitmap(active); }
		char *GetDescription() { return "Page Flipping"; }
};


#endif			//PAGEFLIPPING_H
