#include "pageflipping.h"


PageFlipping::PageFlipping() : ScreenUpdate(), page1(NULL), page2(NULL), active(NULL) {
}


PageFlipping::~PageFlipping() {
}

	
Error PageFlipping::Create() {
	Destroy();
	
	page1 = create_video_bitmap(SCREEN_W, SCREEN_H);
	page2 = create_video_bitmap(SCREEN_W, SCREEN_H);

	if ((!page1) || (!page2)) {
		Destroy();
		return Error(Error::VIDEOMEMORY);
	}
	
	active = page1;
	return Error(Error::NONE);
}


void PageFlipping::Destroy() {
	if (page1) {
		destroy_bitmap(page1);
		page1 = NULL;
	}

	if (page2) {
		destroy_bitmap(page2);
		page2 = NULL;
	}
	
	active = NULL;
}


void PageFlipping::Draw() {
	show_video_bitmap(active);
	active = active == page1 ? page2 : page1;
}
