#include "xmlparser.h"
#include <iostream.h>
#include <qstring.h>
#include <qlineedit.h>
#include <qmessagebox.h> 
#include <assert.h>

#include "mainwidget.h"
#include "node.h"


XMLParser::XMLParser(DialogEditor* editor)
{
	WriteLog("XMLParser::XMLParser\n");
	m_dialogEditor = editor;
	curAnswer = NULL;
	curNode   = NULL;
}

bool XMLParser::startDocument()
{
	WriteLog("XMLParser::startDocument()\n");
	m_dialogEditor->nodeListView->clear();
    return TRUE;
}

bool XMLParser::startElement( const QString&, const QString&, 
                                    const QString& qName, 
                                    const QXmlAttributes& attr)
{
	WriteLog("XMLParser::startElement\n");
	if (qName=="NODES")
	{
	}
	else if (qName=="NODE")
	{
		QString strId ="", strName = "", strMusic ="", strBack ="";
		QString strAlienText = "";
		QString strFont = "", strTextLocation ="";

		for(int i=0; i< attr.length();i++)
		{
			if(attr.localName(i)=="id")
			{
				strId = attr.value(i);
			}
			else
			if(attr.localName(i)=="name")
			{
				strName = attr.value(i);
			}
			else
			if(attr.localName(i)=="music")
			{
				strMusic = attr.value(i);
			}
			else
			if(attr.localName(i)=="background")
			{
				strBack = attr.value(i);
			}
			else
			if(attr.localName(i)=="alien_text")
			{
				strAlienText = attr.value(i);
			}
			else
			if(attr.localName(i)=="font")
			{
				strFont = attr.value(i);
			}
			else
			if(attr.localName(i)=="text_location")
			{
				strTextLocation = attr.value(i);
			}
			else
			{
				QMessageBox::warning (m_dialogEditor, "TW-Light editor",
				QString("Unknown attribute: ") + attr.localName(i));
			}
		}
		curNode = new NodeItem ( m_dialogEditor->nodeListView );

		curNode->setID          ( strId );
		curNode->setName        ( strName );
		curNode->setMusic       ( strMusic );
		curNode->setPicture     ( strBack);
		curNode->setAlienText   ( strAlienText );
		curNode->setFont        ( strFont );
		curNode->setTextLocation( strTextLocation);

	}
	else if(qName=="PLAYER_ANSWER")
	{
		assert(curNode&&"Cant locate Dialog Node in XML!!!");
		curAnswer = new PlayerAnswer;

		QString strText = "", strAppearCondition = "";
		for(int i=0; i< attr.length();i++)
		{
			if(attr.localName(i)=="text")
			{
				
				strText = attr.value(i);
			}
			else if (attr.localName(i)=="appear_condition")
			{
				strAppearCondition = attr.value(i);
			}
			else
			{
				QMessageBox::warning (m_dialogEditor, "TW-Light editor",
				QString("Unknown attribute: ") + attr.localName(i));
			}
		}
		curAnswer->m_strText = strText;
		curAnswer->setAppearCondition( strAppearCondition);
	}
	else if(qName=="ACTION")
	{
		assert(curAnswer);
		int j;
		for(j=0; j<5;j++)
			if(curAnswer->m_strAct[j].isEmpty()&&
			   curAnswer->m_strCond[j].isEmpty())
			    break;
		QString strCondition = "";
		QString strAction    = "";
		for(int i=0; i< attr.length();i++)
		{
			if(attr.localName(i)=="condition")
			{
				
				strCondition = attr.value(i);
			}
			else if (attr.localName(i)=="action")
			{
				strAction = attr.value(i);
			}
			else
			{
				QMessageBox::warning (m_dialogEditor, "TW-Light editor",
				QString("Unknown attribute: ") + attr.localName(i));
			}
		}
		curAnswer->m_strAct[j] = strAction;
		curAnswer->m_strCond[j] = strCondition;
	}
	else
	{
		QMessageBox::warning (m_dialogEditor, "TW-Light editor",
			QString("Unknown Node: ") + qName);
	}

    return TRUE;
}

bool XMLParser::endElement( const QString & namespaceURI, const QString & localName, const QString & qName ) 
{
	WriteLog("XMLParser::endElement\n");
	if(qName=="NODES")
	{
	}
	else if (qName=="NODE")
	{
		m_dialogEditor->nodeListView->setCurrentItem(curNode);
		curNode=NULL;
	}
	else if(qName=="PLAYER_ANSWER")
	{
		curNode->m_answers.append(curAnswer);
		curAnswer = NULL;
	}
	else if(qName=="ACTION")
	{
	}
	else
	{
		QMessageBox::warning (m_dialogEditor, "TW-Light editor",
			QString("Unknown Node: ") + qName);
	}
    return TRUE;
}

