#ifndef TW_MAINWIDGET_H
#define TW_MAINWIDGET_H

#include "maindialog.h"
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qmainwindow.h>
#include "helpers.h"
#include "node.h"

class DialogEditor: public DialogEditorGenerated
{
private:

public:
	DialogEditor( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~DialogEditor();

	void loadDoc(QString fileName);

	/// Get XML 
	QString GetXML();

	virtual void setAlienText();
	virtual void removeNode();
	virtual void CreateNewNode();
	virtual void nodeChangedSlot(QListViewItem* );
	virtual void AddPlayerAnswer();
	virtual void answerChangedSlot(QListViewItem* item);
	virtual void removeAnswer();
	virtual void setPlayerAnswerText();
	virtual void disconnectAnswer();
	virtual void processAnswerSlot(QListViewItem*);

	virtual void answerUp();
	virtual void answerDown();

	NodeItem * getNodeItem(QString& id);
	PlayerAnswer* getPlayerAnswer(QString& text);
	int getPlayerAnswerPos(QString& text);

	bool script_check_condition(QString & condition);
protected:
	QToolBar *fileTools;
	QMenuBar *menu;

	void InitMenu();
	void InitToolBar();
};


#endif TW_MAINWIDGET
