/*
This file is part of "TW-Light" 
                    http://tw-light.berlios.de/
Copyright (C) 2001-2004  TimeWarp development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

#ifndef TW_SOUND_H_INCLUDED
#define TW_SOUND_H_INCLUDED

#include <string>
#include <map>

#include "SDL_mixer.h"

/// \brief All work with sound must be implemented using this class
class SoundSystem
{  
  bool mix_ok;
  std::map<std::string,Mix_Chunk*> sound_cache;
  std::map<std::string,Mix_Music*> music_cache;
  
  std::string current_music;
  
  bool music_off;
  bool sound_off;
  
  int frequency;
  Uint16 format;
  int channels;

  size_t buf_size_;

 public:
  SoundSystem(bool sound_on = true);
  ~SoundSystem();

  /// \brief play music file
  /// \param file - path to music file
  /// \param loops - -1 play instantly
  void play_music(const std::string file, int loops = -1);
  /// \brief play sound effect from file
  /// \param file - path to sound file
  /// \param vol - sound volume 1 - max, 0 min
  void play_sound(const std::string file, double vol = -1);
  /// \brief stop playing current sound
  void stop_sound(const std::string file);

  /// \brief set music volume
  void set_music_volume(double vol);
  /// \brief set sound effect volume
  void set_sound_volume(double vol);

  // this functions will die after config would be implemented
  /// \brief get music volume from .ini 
  double load_music_volume();
  /// \brief get sound volume from .ini
  double load_sound_volume();

  /// \brief return true if music playing
  bool playing_music();
};
extern SoundSystem* tw_sound;

#endif
