#include <allegro.h>
#ifdef WIN32
#include <winalleg.h>
#endif

/*
------------------------------
		Timers & Stuff
------------------------------

Three sections:
1.  idle() functions for Allegro 
2.  Platform-specific time functions:
		Allegro interrupts (stupid allegro...)
*/


#include <time.h>
#include <math.h>
#include "get_time.h"
#include "base.h"
#include "errors.h"




//1.  idle() functions for Allegro 

int _no_idle = 0;

int idle ( int time ) {
	if (_no_idle) return 0;
	rest(time);
	return time;
}

//2.  Platform specific time functions:

#define allegro_period 5

static volatile int allegro_time = 0;
static int allegro_base = 0;
static volatile int allegro_get_time() {
	return allegro_time - allegro_base;
}
END_OF_STATIC_FUNCTION(allegro_get_time);

static void global_timer(void) {
	allegro_time += allegro_period;
}
END_OF_STATIC_FUNCTION(global_timer);

void init_allegro_time() {
	LOCK_FUNCTION(global_timer);
	LOCK_FUNCTION(allegro_get_time);
	LOCK_VARIABLE(allegro_time);
	if (install_timer() < 0) tw_error("Allegro timer installation failed");
	install_int(&global_timer, allegro_period);
}

void deinit_allegro_time() {
	remove_int(&global_timer);
}

//3.  The exported wrappers for time functions

volatile int get_time() {
	return allegro_get_time();
}
END_OF_FUNCTION(get_time);

static unsigned char timer_attributes = 0;

int is_time_initialized() {
	return (timer_attributes & 1);
}

void init_time() {
	int ms;
	if (timer_attributes & 1) return;
	timer_attributes |= 1;
		LOCK_FUNCTION(get_time);
		init_allegro_time();
		allegro_base = allegro_get_time() - 1;
	ms = get_time();
}

//not tested, not even a little bit...
void deinit_time() {
	if (!(timer_attributes & 1)) return;
	timer_attributes &=~1;
		deinit_allegro_time();
	return;
}
