/* $Id$ */
/*
This file is part of "TW-Light" 
                    http://timewarp.sourceforge.net/
Copyright (C) 2001-2004  TimeWarp development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
 
#include "ship.h"

#include "sc1ships.h"

class MyconPlasma : public HomingMissile {
	//double v;

	static SpaceSprite *spriteWeaponExplosion;
	int frame_count;
	int max_damage;

	public:
	MyconPlasma(Vector2 opos, double oangle, double ov, int odamage,
		double orange, double otrate, Ship *oship, SpaceSprite *osprite, int ofcount);

	virtual void calculate();

	virtual void inflict_damage(SpaceObject *other);
	virtual int handle_damage(SpaceLocation *source, double normal, double direct);
};


MyconPodship::MyconPodship(Vector2 opos, double angle, ShipData *data, unsigned int code) 
	:
	Ship(opos, angle, data, code)
{
  STACKTRACE;
  weaponRange    = scale_range(get_config_float("Weapon", "Range", 0));
  weaponVelocity = scale_velocity(get_config_float("Weapon", "Velocity", 0));
  weaponDamage   = get_config_int("Weapon", "Damage", 0);
  weaponHome     = scale_turning(get_config_float("Weapon", "Homing", 0));
  specialRepair  = get_config_int("Special", "Repair", 0);
}

int MyconPodship::activate_weapon()
{
  STACKTRACE;
  add(new MyconPlasma(Vector2(0.0, size.y),
    angle, weaponVelocity, weaponDamage, weaponRange, weaponHome, this,
    data->spriteWeapon, 64));
  return(TRUE);
}

int MyconPodship::activate_special()
{
  STACKTRACE;
  if(crew >= crew_max)
    return(FALSE);
  damage(this, 0, -4);
  return(TRUE);
}

SpaceSprite *MyconPlasma::spriteWeaponExplosion = NULL;
MyconPlasma::MyconPlasma(Vector2 opos, double oangle, double ov,
    int odamage, double orange, double otrate, Ship *oship,
    SpaceSprite *osprite, int ofcount) :
  HomingMissile( oship, opos, oangle, ov, odamage, orange, 0, otrate, oship, 
      osprite, oship->get_target()),
//  v(ov),
  frame_count(ofcount),
  max_damage(odamage)
{
  STACKTRACE;
	spriteWeaponExplosion = data->spriteWeaponExplosion;
	collide_flag_sameship |= bit(LAYER_SHIPS);
	collide_flag_sameteam |= bit(LAYER_SHIPS);
}

void MyconPlasma::calculate()
{
  STACKTRACE;
  HomingMissile::calculate();

  sprite_index = (int)((d / range) * (double)(frame_count - 1));
  damage_factor = max_damage - (int)((d / range) * (double)(max_damage));
}

void MyconPlasma::inflict_damage(SpaceObject *other)
{
  STACKTRACE;
  SpaceObject::inflict_damage(other);
  //if (!other->isShot()) {
  if (other->isblockingweapons)
  {
	  if (other->exists()) {
		  add(new FixedAnimation(this, other,
				spriteWeaponExplosion, 0, 20, 50, DEPTH_EXPLOSIONS));
	  }
	  else {
		  add(new Animation(this, other->normal_pos(), 
				spriteWeaponExplosion, 0, 20, 50, DEPTH_EXPLOSIONS));
	  }
    state = 0;
  }
}

int MyconPlasma::handle_damage(SpaceLocation *source, double normal, double direct) {
  STACKTRACE;
	double total = normal + direct;

	if (total) {
		total += normal;
		total += direct;
		d += total / max_damage * range;
		if (d >= range) state = 0;
		}
	return 1;
	}


REGISTER_SHIP(MyconPodship)
