/*
   $Id: python_class.cc,v 1.10 2003/02/20 21:03:11 ksterker Exp $

   Copyright (C) 2001 Kai Sterker <kaisterker@linuxgames.com>
   Part of the Adonthell Project http://adonthell.linuxgames.com

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/


/**
 * @file   python_class.cc
 * @author Kai Sterker <kaisterker@linuxgames.com>
 * 
 * @brief  Declares the python class.
 * 
 * 
 */

 /* Modyfied by Yura Semashko for TW-Light project */
 
#include "python_class.h"
#include "game.h"
#include "util/errors.h"
#include "scp.h"

#include <iostream> 


extern "C"
{
  void init_ggob(void);
}


/*
 * Start Python
 */
void python::init ()
{
    Py_Initialize ();
    insert_path( (char*)(datafile_path + "/python").c_str());

#ifdef WIN32
    // For windows we should include part of standart library we use
    insert_path( (char*)(datafile_path + "/python/lib").c_str());
#endif
    init_ggob();
}

void python::cleanup () 
{
    Py_Finalize ();
}

/*
 * Insert a string into the module search path.
 */
void python::insert_path( char *name )
{
  STACKTRACE;
    char buf[256];
    
    sprintf ( buf, "import sys ; sys.path.insert(0, \"%s\")", name );
    PyRun_SimpleString ( buf );
}

/*
 * Some convenience functions
 */

/*
 * Executes the Python statements in the string
 */
void python::exec_string(const std::string& s)
{
  STACKTRACE;
    PyRun_SimpleString((char*)s.c_str());
}

/*
 * Execute the file given by 'filename'
 */
bool python::exec_file (std::string filename)
{
  std::string content;
  FILE * f = fopen(data_full_path(filename).c_str(), "rt");
  if(!f)
    {
      tw_error( (std::string("Unable to fined script: ") + filename).c_str());
      return false;
    }
  int r = 1;
  while(r)
    {
      char buf[1024] = {0};
      r = fread(buf, 1024-1, 1, f);
      content += buf;
    }

   exec_string(content);
   return true; }

/*
 * Dump any error information to stderr
 */
void python::show_traceback(void)
{
  STACKTRACE;
    if ( PyErr_Occurred() )
    {
        PyErr_Print();
        fflush (stderr);
    }
}

/* Import a module, return module ptr */
PyObject *python::import_module (std::string filename)
{
    PyObject *result = PyImport_ImportModule ((char *) filename.c_str ());
    
#ifdef PY_DEBUG
    show_traceback ();
#endif
    return result;
}

