/*
This file is part of "TW-Light" 
                    http://tw-light.berlios.de/
Copyright (C) 2001-2004  TimeWarp development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/


#ifndef __TW_STARMAP_INCLUDES__
#define __TW_STARMAP_INCLUDES__

#include "melee/mframe.h"

#include <list>
#include <string>
#include <map>

class SpaceLocation;

class StarSystem
{  
  /// Star coord
  Vector2 _pos;
  /// name
  std::string _name;
 public:
  StarSystem(const std::string& name, Vector2 pos);
  virtual ~StarSystem();

  /// SpaceObjects in system
  std::list<SpaceLocation*> _item;

  virtual void add(SpaceLocation* l);
  std::string getName() const;
  std::list<SpaceLocation*> getItem() const;
  Vector2 pos();
};

class StarMap
{

  std::string _text;
  StarSystem* nearStar();
  StarSystem* _selectedStar;
  StarSystem* _targetStar;
 public:
  StarMap();
  virtual ~StarMap();

  /// star where player stay
  StarSystem* _playerStar;
  /// StarSystem List
  std::list<StarSystem*> _stars;

  virtual void add(StarSystem* s);
  virtual void redraw();
  virtual std::string select();
};

#endif

