/*
This file is part of "TW-Light" 
                    http://tw-light.berlios.de/
Copyright (C) 2001-2004  TimeWarp development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

#include <allegro.h>

#include "melee.h"
#include "frame.h"
#include "melee/mgame.h"
#include "melee/mview.h"
#include "starmap.h"

#include <sstream>

StarSystem::StarSystem(const std::string& name, Vector2 pos)
  :
  _pos(pos),
  _name(name)
{
  STACKTRACE;
}

StarSystem::~StarSystem()
{
  STACKTRACE;
}

void StarSystem::add(SpaceLocation* l)
{
  STACKTRACE;
  _item.remove(l);
  _item.push_back(l);
}

std::string StarSystem::getName() const
{
  STACKTRACE;
  return _name;
}
std::list<SpaceLocation*> StarSystem::getItem() const
{
  STACKTRACE;
  return _item;
}

Vector2 StarSystem::pos()
{
  STACKTRACE;
  return _pos;
}

StarMap::StarMap()
{
  STACKTRACE;
  _selectedStar = NULL;
  _targetStar = NULL;
}

StarMap::~StarMap()
{
  STACKTRACE;
}

void StarMap::add(StarSystem* s)
{
  STACKTRACE;
  _stars.remove(s);
  _stars.push_back(s);
}

void StarMap::redraw()
{
  STACKTRACE;
  scare_mouse();

  BITMAP* starmap = create_bitmap(game->view->frame->window->w,
				  game->view->frame->window->h);   
 
  BITMAP* starArea = create_sub_bitmap(starmap, 0, 0,  starmap->w, starmap->h-100);
  BITMAP* textArea = create_sub_bitmap(starmap, 0, starmap->h-100, starmap->w, 100);


  clear_to_color(starArea, makecol(256/3, 0, 0));

  for(std::list<StarSystem*>::iterator i = _stars.begin(); i!= _stars.end(); i++)
    {
      Vector2 pos = (*i)->pos();
      game->meleedata._star->draw_centre(pos, 0, starArea);
      int color = palette_color[15];
      if(*i == _playerStar)
	{
	  color = palette_color[1];
	}
      else if(*i == _targetStar)
	{
	  color = palette_color[8];
	}
      textout_centre(starArea, font, ((*i)->getName()).c_str(), (int)pos.x, (int)pos.y-15, color);
    }
  
  // Draw path to target star
  if(_targetStar)
    {
      line(starArea, 
	   (int)_playerStar->pos().x, (int)_playerStar->pos().y, 
	   (int)_targetStar->pos().x, (int)_targetStar->pos().y, 
	   palette_color[15]);
    }

  // Draw help text
  if(_targetStar)
    {
      std::ostringstream st;
      st<<"Jump to "<<_targetStar->getName()<<" distance: "<< (_targetStar->pos()-_playerStar->pos()).abs();
      st<<" Press 'j' to jump ";
      _text = st.str();
    }
  else if(_selectedStar)
    {
      std::ostringstream st;
      st<<_selectedStar->getName()<<" distance: "<< (_selectedStar->pos()-_playerStar->pos()).abs();
      _text = st.str();
    }
  else
    {
      _text = "";
    }
  textout_centre(textArea, font, _text.c_str(), textArea->w/2, textArea->h/2, -1);

  blit(starmap, 
       game->view->frame->window->surface, 
       0, 0, 
       game->view->frame->window->x, 
       game->view->frame->window->y, 
       starmap->w, starmap->h);

  destroy_bitmap(textArea);
  destroy_bitmap(starArea);
  destroy_bitmap(starmap);
  unscare_mouse();
}

static bool minRangeToMouseCmp(StarSystem* s1, StarSystem* s2)
{
  Vector2 mouse_pos(mouse_x, mouse_y);
  if( (mouse_pos - s1->pos()).abs() < (mouse_pos - s2->pos()).abs() )
    {
      return true;
    }
  return false;
}

StarSystem* StarMap::nearStar()
{
  STACKTRACE;
  Vector2 mouse_pos(mouse_x, mouse_y);
  std::list<StarSystem*>::iterator i = std::min_element(_stars.begin(), _stars.end(), minRangeToMouseCmp);
  if(i!= _stars.end())
    {
      if((mouse_pos - (*i)->pos()).abs()<25)
	{
	  return *i;
	}
    }
  return NULL;
}

std::string StarMap::select()
{
  STACKTRACE;
  _text = "";
  _selectedStar = NULL;
  game->pause();
  std::string ret = game->_name;
  show_mouse(game->view->frame->window->surface);
  redraw();
   while(1)
     {
       poll_mouse();
       StarSystem* nearstar = nearStar();
       if(  _selectedStar != nearstar)
	 {
	   _selectedStar = nearstar;
	   redraw();
	 }
       
       if(_targetStar)
	 {
	   if (keypressed())
	     {
	       int k = readkey();
	       if(k>>8 == KEY_J) 
		 {
		   ret = _targetStar->getName();
		   _targetStar = NULL;
		   break;
		 }
	       else if(k>>8 == KEY_ESC) 
		 {
		   break;
		 }
	     }
	 }
       if(mouse_b & 1 && _selectedStar != _playerStar)
	 {
	   _targetStar = _selectedStar;
	   redraw();
	 }
       else
       if (mouse_b & 2)
	 {
	   if(_targetStar)
	     {
	       _targetStar = NULL;
	       _selectedStar = NULL;
	       redraw();
	     }
	 }
     }
  
  show_mouse(NULL);
  game->unpause();
  return ret;
return "";
}

