/* $Id: mshpdata.cpp,v 1.3 2004/08/07 07:48:50 Yura Exp $ */ 
/*
This file is part of "TW-Light" 
                    http://timewarp.sourceforge.net/
Copyright (C) 2001-2004  TimeWarp development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/


#include <allegro.h>
#ifdef WIN32
#include <winalleg.h>
#endif

#include <map>
#include <string>

#include "melee.h"
#include "util/aastr.h"
#include "other/twconfig.h"


int auto_unload = false;


/*------------------------------*
 *		Ship Data Registration  *
 *------------------------------*/


int num_shipdatas = 0;

typedef std::map<std::string, ShipData*> ShipDataMap;
ShipDataMap shipdatas;

/// Allocate ship data resources, or return already loaded ones
ShipData *shipdata ( std::string inifile ) 
{
  if ( inifile.empty()) 
    return NULL;
	
  ShipDataMap::iterator shp = shipdatas.find(inifile);
  if(shp!=shipdatas.end())
    return (*shp).second;
  
  ShipData *data = new ShipData( inifile);
  shipdatas[inifile] = data;
  return data;
}

void save_spacesprite2(SpaceSprite *ss, const char *spritename, 
		       const char *destination, const char *extension) 
{
  int i;
  char buf[512];
  
  if (ss->frames() != 64)
    tw_error("save_spacesprite2 - error");
  
  BITMAP *tmp = create_bitmap(int(ss->width() * 8), int(ss->height() * 8));
  for (i = 0; i < ss->frames(); i += 1) 
    {
      blit(ss->get_bitmap(i), tmp, 0, 0, (i&7) * (int)ss->width(), 
	   int((i/8) * ss->height()), (int)ss->width(), (int)ss->height());
      sprintf(buf, "%s%i.%s", spritename, i, extension);
      save_bitmap(buf, tmp, NULL);
    }
  return;
}

void save_spacesprite(SpaceSprite *ss, const char *spritename, 
		      const char *destination, const char *extension) 
{
  int i;
  char buf[512];
  
  if (!ss)
    return;
  
  if (ss->frames()) 
    {
      for (i = 0; i < ss->frames(); i += 1) 
	{
	  if (strchr(extension, '.')) 
	    {
	      sprintf(buf, "tmp/%s%03d%s", spritename, i, extension);
	    }
	  else 
	    {
	      sprintf(buf, "tmp/%s%03d.bmp", spritename, i);
	    }
	  
	  save_bitmap(buf, ss->get_bitmap(i), NULL);
	}
      
    }
  
  sprintf(buf, "tmp/%s.ini", spritename);
  tw_set_config_file(buf);
  set_config_string("Main", "Type", "SpaceSprite");
  set_config_int("SpaceSprite", "Number", (int)ss->frames());
  set_config_int("SpaceSprite", "Width", (int)ss->width());
  set_config_int("SpaceSprite", "Height", (int)ss->height());
  set_config_string("SpaceSprite", "SubType", "Normal");
  set_config_string("SpaceSprite", "Extension", extension);
  chdir("tmp");
  sprintf(buf, "dat ../ships/%s.dat -k -a *", destination);
  sprintf(buf, "move * ..\\ships\\%s", destination);
  system(buf);
  chdir("..");
  return;
}

void ShipData::lock() 
{
  STACKTRACE;
  if (references == 0) 
    {
      push_config_state();//can screw up badly if an error occurs while loading...
      load();
      pop_config_state();
    }
  references += 1;
}

void ShipData::unlock() 
{
  STACKTRACE;
  references -= 1;
  if ((references == 0) && auto_unload) 
    {
      unload();
    }
}

void ShipData::unload() 
{
  STACKTRACE;
  if (status != LOADED_FULL) 
    return;

  if (spriteShip) 
    {
      delete spriteShip;
      spriteShip = NULL;
    }
  if (spriteWeapon) 
    {
      delete spriteWeapon;
      spriteWeapon = NULL;
    }
  if (spriteWeaponExplosion) 
    {
      delete spriteWeaponExplosion;
      spriteWeaponExplosion = NULL;
    }
  if (spriteSpecial) 
    {
      delete spriteSpecial;
      spriteSpecial = NULL;
    }
  if (spriteSpecialExplosion) 
    {
      delete spriteSpecialExplosion;
      spriteSpecialExplosion = NULL;
    }
  if (spriteExtra) 
    {
      delete spriteExtra;
      spriteExtra = NULL;
    }
  
  if (spritePanel) 
    {
      delete spritePanel;
      spritePanel = NULL;
    }
  
  if (num_more_sprites) 
    {
      int i;
      for (i = 0; i < num_more_sprites; i += 1) 
	delete more_sprites[i];
      delete[] more_sprites;
      more_sprites = NULL;
      num_more_sprites = 0;
    }
  
  status = LOADED_NONE;
}

ShipData::ShipData( std::string inifile) :
  spriteShip(NULL),
  spriteWeapon(NULL),
  spriteWeaponExplosion(NULL),
  spriteSpecial(NULL),
  spriteSpecialExplosion(NULL),
  spriteExtra(NULL),
  spriteExtraExplosion(NULL)
{
  STACKTRACE;
  ini  = inifile;
  references = 0;
  status = LOADED_NONE;
}


SpaceSprite *load_sprite(const char *string ) 
{
  char buffy[512]; buffy[0] = 0;
  char *cp = buffy;
  char *tp;
  int argc, i;
  int rotations = 1;
  char **argv = get_config_argv("Objects", string, &argc);
  int count = 0;
  if (!argc) 
    return NULL;
  count = atoi(argv[0]);
  if (!count) 
    return NULL;
  tp = strchr(argv[0], 'r');
  for (i = 1; i < argc; i += 1) {
    if ((argv[i][0] == '-') || (argv[i][0] == '+')) {
      cp += sprintf(cp, "%s ", argv[i]);
    }
    else if (argv[i][0] == 'r') tp = argv[i];
    else {tw_error("load_sprite - unrecognized modifiers '%s'", argv[i]);}
  }
  if (tp) 
    {
      rotations = atoi(tp+1);
      if (rotations == 0) 
	rotations = 64;
    }
  SpaceSprite *sprite = NULL;
  int attrib = string_to_sprite_attributes(buffy);
  
  std::vector<std::string> tmpVec;

  for(i = 0; i < count; i++) 
    {
      char tmp[200] = {0};
      sprintf(tmp, "%d", i);
      tmpVec.push_back( get_config_string("Graphic", 
					  (std::string(string) + tmp).c_str(),
					  ""));
    }
  
  sprite = new SpaceSprite(tmpVec, count, attrib, rotations);
  return sprite;
}

void ShipData::load() 
{
  STACKTRACE;
  int i, index = 0, count;
  
  if (status != LOADED_NONE) 
    return;
  
  tw_set_config_file(ini);

  int num_panel_bitmaps = get_config_int("Objects", "PanelBitmaps", 0);
  // load ship panel
  if (num_panel_bitmaps < 2)
    tw_error("Too few ship panel bitmaps");

  std::vector<std::string> tmpVec;
  for(i = 0; i < num_panel_bitmaps; i++) 
    {
      char tmp[200] = {0};
      sprintf(tmp, "%d", i);
      tmpVec.push_back( get_config_string("Graphic", 
					  (std::string("PanelBitmaps") + tmp).c_str(),
					  ""));
    }
  spritePanel = new SpaceSprite(tmpVec, num_panel_bitmaps, SpaceSprite::IRREGULAR);
  tmpVec.clear();
  //  tw_error("!!");
  // load ship sprites
  spriteShip = load_sprite("ShipSprites"); 

  // load weapon sprites
  spriteWeapon = load_sprite("WeaponSprites");

  // load weapon explosion sprites
  spriteWeaponExplosion = load_sprite("WeaponExplosion");

  // load special ability sprites
  spriteSpecial = load_sprite("SpecialSprites");
  
  // load special ability explosion sprites
  spriteSpecialExplosion = load_sprite("SpecialExplosion");
  
  // load extra sprites
  spriteExtra = load_sprite("ExtraSprites");
  
  // load extra explosion sprites
  spriteExtraExplosion = load_sprite("ExtraExplosion");
  
  //load optional super-extra sprites
  i = 0;
  more_sprites = NULL;
  while (true) 
    {
      char buffy[512];
      sprintf(buffy, "ExtraExtraSprites%d_", i);
      if (get_config_int("Objects", buffy, -1) == -1) 
	break;
      
      //tw_error("SSS");
      more_sprites = (SpaceSprite**) realloc(more_sprites, (i+1) * sizeof(SpaceSprite*));
      more_sprites[i] = load_sprite(buffy);
      i += 1;
    }
  num_more_sprites = i;
  
  // initialize ship victory ditty
  moduleVictory = get_config_string("Music", "Victory", "");
  index++;
  
  // load weapon samples
  count = get_config_int("Objects", "WeaponSamples", 0);
  for(i = 0; i < count; i++) 
    {
      char tmp[200] = {0};
      sprintf(tmp, "%d", i);
      sampleWeapon.push_back( get_config_string("Sound", 
						(std::string("WeaponSample") + tmp).c_str(),
						""));
    }
  
  // load special ability samples
  count = get_config_int("Objects", "SpecialSamples", 0);
  for(i = 0; i < count; i++) 
    {
      char tmp[200] = {0};
      sprintf(tmp, "%d", i);
      sampleSpecial.push_back( get_config_string("Sound", 
						 (std::string("SpecialSample") + tmp).c_str(),
						 ""));
    }
  
  // load extra samples
  count = get_config_int("Objects", "ExtraSamples", 0);
  for(i = 0; i < count; i++) 
    {
      char tmp[200] = {0};
      sprintf(tmp, "%d", i);
      sampleExtra.push_back( get_config_string("Sound", 
					       (std::string("ExtraSample") + tmp).c_str(),
					       ""));
    }
  
  status = LOADED_FULL;

  return;  
}

ShipData::~ShipData()
{
  unload();
}
