/*
This file is part of "TW-Light" 
                    http://tw-light.berlios.de/
Copyright (C) 2001-2004  TimeWarp development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

#include <allegro.h>
#ifdef WIN32
#include <winalleg.h>
#endif

#include "ais.h"

/*! \brief Get control name */
const char *ControlVegetable::getTypeName() 
{
  STACKTRACE;
  return "VegetableBot";
}
/*! \brief This AI do nothing */
int ControlVegetable::think() 
{
  STACKTRACE;
  return 0;
}
/*! \brief This function do nothing
  \return -1
*/
int ControlVegetable::choose_ship(VideoWindow *window, char * prompt, class Fleet *fleet ) 
{
  STACKTRACE;
  return -1;
}

ControlVegetable::ControlVegetable (const char *name, int channel) : Control(name, channel, ai_index_vegetable) 
{
}

/// Get name
const char *ControlMoron::getTypeName() 
{
  STACKTRACE;
  return "MoronBot";
}

/*! \brief Morron bot AI */
int ControlMoron::think()
{
  STACKTRACE;
  if (ship)
    {
      int r = 0;
      double a;
      if (!ship->get_target()) 
	return 0;
      if (!ship->get_target()->exists()) 
	{
	  ship->set_target(NULL);
	  return 0;
	}
      a = ship->trajectory_angle(ship->get_target()) - ship->get_angle();
      a = fmod(a + PI2, PI2);
      if (a < PI) 
	{
	  r |= keyflag::right;
	}
      else 
	{
	  r |= keyflag::left;
	  return r;
	}
      a = int(ship->distance(ship->get_target()));
      if (a > 2000) 
	{
	  r |= keyflag::thrust;
	}
      else 
	{
	  r |= keyflag::thrust;
	  r |= keyflag::fire;
	}
      return r;
    }
  else
    {
      return 0;
    }
}

ControlMoron::ControlMoron(const char *name, int channel) : Control(name, channel, ai_index_moron) 
{
  STACKTRACE;
}


