/*
This file is part of "TW-Light" 
                    http://tw-light.berlios.de/
Copyright (C) 2001-2004  TimeWarp development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

#include <allegro.h>
#ifdef WIN32
#include <winalleg.h>
#endif

#include <stdio.h>
#include <string.h>
#include "melee.h"
#include "ais.h"
#include "melee/mship.h"
#include "gui.h"
#include "other/dialogs.h"

#include "other/twconfig.h"
#include "melee/mfleet.h" //for Fleet class
#include "scp.h" //for ship_view_dialog()

char selectShipPrompt[100]  = "";
char selectPlayer[18]       = "";
char selectTitleString[100] = "";


int my_bitmap_proc( int msg, DIALOG* d, int c )
{
  if( msg == MSG_END && d->dp )
    {
      destroy_bitmap( (BITMAP*)d->dp );
      d->dp = NULL;
    }

  if( msg != MSG_DRAW || d->dp ) 
    return d_bitmap_proc( msg, d, c );
  return D_O_K;
}

int my_list_proc( int msg, DIALOG* d, int c )
{
  int old_d1 = d->d1;
  Fleet *fleet = (Fleet*)d->dp3;
  int ret = d_list_proc2( msg, d, c );
  if( d->d1 != old_d1 || msg == MSG_START )
    {
      ShipType* type = fleet->getShipType(d->d1);
      
      ASSERT(type != NULL);
      
      selectDialog[SELECT_DIALOG_TITLE].flags |= D_DIRTY;
      sprintf(selectTitleString, "%s\n%s\n%d of %d points", 
	      selectShipPrompt,
	      (type != NULL) ? type->name : 0,
	      (type != NULL) ? type->cost : 0,
	      fleet->getCost());
      
      tw_set_config_file(type->data->ini);

      BITMAP* panel = load_bitmap(data_full_path(get_config_string("Graphic", 
								   "PanelBitmaps0", 
								   "")).c_str(), NULL);
      if(panel)
	{
	  BITMAP* bmp = load_bitmap(data_full_path(get_config_string("Graphic", 
								     "PanelBitmaps1", 
								     "")).c_str(), NULL);
	  blit( bmp, panel, 0, 0, 4, 65, bmp->w, bmp->h );
	  destroy_bitmap(bmp);
	  color_correct_bitmap( panel, 0 );
	}
      else
	{
	  tw_error("Unable to load ship pannel!!\n%s", 
		   data_full_path(get_config_string("Graphic", "PanelBitmaps0", "")).c_str());
	}
      
      if( selectDialog[SELECT_DIALOG_PIC].dp ) 
	destroy_bitmap( (BITMAP*)selectDialog[SELECT_DIALOG_PIC].dp );
      selectDialog[SELECT_DIALOG_PIC].dp = panel;
      scare_mouse();
      SEND_MESSAGE( &selectDialog[SELECT_DIALOG_PIC], MSG_DRAW, 0 );
      unscare_mouse();
    }
  return ret;
}

void calibrate_joysticks() 
{
  int i;
  const char *cal;
  
  if (!num_joysticks) 
    {
      tw_alert("No joysticks detected", "Done");
      return;
    }
  
  int which_joystick = 0;
  while (true) 
    {
      if(poll_joystick() != 0)
	return;
      if (::joy[which_joystick].flags & JOYFLAG_CALIBRATE) 
	{
	  cal = calibrate_joystick_name(which_joystick);
	  if (cal)
	    sprintf(dialog_string[0], "Calibrate : %s", cal);
	  else
	    sprintf(dialog_string[0], "Calibrate : ?");
	}	
      else
	sprintf (dialog_string[0], "De-Calibrate");
      
      char buffy[1024];
      char *d = buffy;
      
      d += sprintf(d, "Joystick %d\n\n", which_joystick);
      
      for (i = 0; i < ::joy[which_joystick].num_sticks; i += 1) 
	{
	  d += sprintf(d, "%s %d\n", ::joy[which_joystick].stick[i].name, i);
	}
      
      d += sprintf(d, "\nBUTTONS\n");
      for (i = 0; i < ::joy[which_joystick].num_buttons; i += 1) 
	{
	  d += sprintf(d, " %s", ::joy[which_joystick].button[i].name);
	}
      
      joyDialog[JOY_DIALOG_DESCRIPTION].dp = buffy;
      i = tw_popup_dialog(NULL,joyDialog, 1);
      if (i == -1)
	i = JOY_DIALOG_DONE;
      
      switch (i) 
	{
	case JOY_DIALOG_SWITCH:
	  if (num_joysticks)
	    which_joystick = (which_joystick + 1) % num_joysticks; 
	  break;
	case JOY_DIALOG_DONE:
	  return;
	case JOY_DIALOG_CALIBRATE:
	  if (::joy[which_joystick].flags & JOYFLAG_CALIBRATE) 
	    {
	      calibrate_joystick(which_joystick);
	      save_joystick_data("joys.ini");
	    } 
	  else 
	    {
	      tw_delete_file("joys.ini");
	      remove_joystick();
	      install_joystick(JOY_TYPE_AUTODETECT);
	    }
	  break;
	}
    }
}

/*! \brief load players keys 
  \param inifile with players keys
  \param inisection with players keys 
*/
void ControlHuman::load (const char *inifile, const char *inisection) 
{
  STACKTRACE;
  tw_set_config_file (inifile);
  thrust  = get_config_int(inisection, "Thrust",         0);
  back    = get_config_int(inisection, "Backwards",      0);
  left    = get_config_int(inisection, "Left",           0);
  right   = get_config_int(inisection, "Right",          0);
  fire    = get_config_int(inisection, "Fire",           0);
  altfire = get_config_int(inisection, "AltFire",        0);
  special = get_config_int(inisection, "Special",        0);
  next    = get_config_int(inisection, "Next_Target",    0);
  prev    = get_config_int(inisection, "Prev_Target",    0);
  closest = get_config_int(inisection, "Closest_Target", 0);
  chat    = get_config_int(inisection, "Chat",           0);
  suicide = get_config_int(inisection, "Suicide",        0);
  return;
}

/*! \brief Save players key
  \param inifile with players keys
  \param inisection with players keys
 */
void ControlHuman::save (const char *inifile, const char *inisection) 
{
  STACKTRACE;
  tw_set_config_file (inifile);
  set_config_int(inisection, "Thrust",         thrust);
  set_config_int(inisection, "Backwards",      back);
  set_config_int(inisection, "Left",           left);
  set_config_int(inisection, "Right",          right);
  set_config_int(inisection, "Fire",           fire);
  set_config_int(inisection, "AltFire",        altfire);
  set_config_int(inisection, "Special",        special);
  set_config_int(inisection, "Next_Target",    next);
  set_config_int(inisection, "Prev_Target",    prev);
  set_config_int(inisection, "Closest_Target", closest);
  set_config_int(inisection, "Chat",           chat);
  set_config_int(inisection, "Suicide",        suicide);
  return;
}

/*! \brief Get control name */
const char *ControlHuman::getTypeName() 
{
  STACKTRACE;
  return "Keyboard/Joystick";
}

/*! \brief Process get input from player */
int ControlHuman::think() 
{
  STACKTRACE;
  int r = 0;
  if (key_pressed(thrust))  r |= keyflag::thrust;
  if (key_pressed(back))    r |= keyflag::back;
  if (key_pressed(left))    r |= keyflag::left;
  if (key_pressed(right))   r |= keyflag::right;
  if (key_pressed(fire))    r |= keyflag::fire;
  if (key_pressed(altfire)) r |= keyflag::altfire;
  if (key_pressed(special)) r |= keyflag::special;
  if (key_pressed(next))    r |= keyflag::next;
  if (key_pressed(prev))    r |= keyflag::prev;
  if (key_pressed(closest)) r |= keyflag::closest;
  if (key_pressed(chat))    r |= keyflag::chat;
  if (key_pressed(suicide)) r |= keyflag::suicide;
  return r;
}

ControlHuman::ControlHuman(const char *name, int channel) : Control(name, channel, ai_index_human) 
{
  STACKTRACE;
};

int ControlHuman::choose_ship(VideoWindow *window, char * prompt, Fleet *fleet) 
{
  STACKTRACE;
  int ret = -1, slot = 0;
  if (fleet->getSize() == 0) 
    {
      tw_error ("Empty fleet! (prompt:%s)", prompt);
    }
  selectDialog[SELECT_DIALOG_LIST].dp3 = fleet;

  strcpy(selectShipPrompt,prompt);

  slot = -1;
  while (!always_random) 
    {
      while (key[KEY_ENTER] || key[KEY_SPACE]) 
	poll_keyboard();

      ret = tw_do_dialog(window, selectDialog, SELECT_DIALOG_LIST);
      if (ret == SELECT_DIALOG_INFO) 
	{
	  ship_view_dialog(
			   selectDialog[SELECT_DIALOG_LIST].d1, 
			   fleet 
			   );
	  continue;
	}
      break;
    }
  if ((ret == SELECT_DIALOG_SHIP) || (ret == SELECT_DIALOG_LIST))
    slot = selectDialog[SELECT_DIALOG_LIST].d1;
  if ((ret == SELECT_DIALOG_ARANDOM) || (ret == -1)) 
    always_random = 1;
  return(slot);
}

/*! returns help text for this controller ie keys to use this controller*/
void ControlHuman::getHelpText(char * text) 
{
  STACKTRACE;
  char line[80] = "";
  char desc[80] = "";
  
  sprintf(line, "Player Controls:\n"); 
  strcat(text, line);
  
  key_to_description(left, desc);   sprintf ( line, "  Left: %s\n", desc);strcat(text, line);
  key_to_description(right, desc);  sprintf ( line, "  Right: %s\n", desc);strcat(text, line);
  key_to_description(thrust, desc); sprintf ( line, "  Thrust: %s\n", desc);strcat(text, line);
  key_to_description(fire, desc);   sprintf ( line, "  Fire: %s\n", desc);strcat(text, line);
  key_to_description(special, desc);sprintf ( line, "  Special: %s\n", desc);strcat(text, line);
  key_to_description(altfire, desc);sprintf ( line, "  Altfire: %s\n", desc);strcat(text, line);
  key_to_description(next, desc);   sprintf ( line, "  Next Target: %s\n", desc);strcat(text, line);
  key_to_description(prev, desc);   sprintf ( line, "  Previous Target: %s\n", desc);strcat(text, line);
  key_to_description(closest, desc);sprintf ( line, "  Closest: %s\n", desc);strcat(text, line);
  key_to_description(chat, desc);   sprintf ( line, "  Chat: %s\n", desc);strcat(text, line);
  key_to_description(suicide, desc);sprintf ( line, "  Suicide: %s\n", desc);strcat(text, line);
}

/*! \brief setap players keys */
void ControlHuman::setup() 
{
  STACKTRACE;
  int i, t = 0;
  int last = 0;
  while (true) 
    {
      char *s;
      int index = 0;
      
      s = dialog_string[index]; index += 1;
      
      s += sprintf(s, "Set Your Keys\nController %s", getDescription());
      s = dialog_string[index]; index += 1;
    
      s += sprintf ( s, "Left:           ");
      key_to_description(left, s);
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Right:          ");
      key_to_description(right, s);
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Thrust:         ");
      key_to_description(thrust, s);
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Backwards:      ");
      key_to_description(back, s);
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Fire:           ");
      key_to_description(fire, s);
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Special:        ");
      key_to_description(special, s);
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "AltFire:        ");
      key_to_description(altfire, s);
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Next Target:    ");
      key_to_description(next, s);
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Prev Target:    ");
      key_to_description(prev, s);
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Closest Target: ");
      key_to_description ( closest, s );
      
      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Chat:           ");
      key_to_description ( chat, s );

      s = dialog_string[index]; index += 1;
      s += sprintf ( s, "Suicide:        ");
      key_to_description ( suicide, s );
      
      s = dialog_string[index]; index += 1;
      
      int maxlen = 0;
      for (i = 1; i < KEY_DIALOG_OK; i += 1) 
	{
	  int t = strlen(dialog_string[i]);
	  if (maxlen < t) 
	    maxlen = t;
	}
      for (i = 1; i < KEY_DIALOG_OK; i += 1) 
	{
	  int t = strlen(dialog_string[i]);
	  dialog_string[i][maxlen] = 0; 
	  memset(dialog_string[i]+t, ' ', maxlen-t);
	}
      clear_keybuf();
      if (last < KEY_DIALOG_OK) 
	last += 1;
      i = tw_do_dialog(NULL, keyDialog, last);
      if (i == -1) 
	return;
      if (i < KEY_DIALOG_OK) 
	{
	  t = get_key();
	  clear_keybuf();
	}
      if (t == KEY_ESC) i = KEY_DIALOG_CANCEL;
      switch (i) 
	{
	case 1:  left    = t; break;
	case 2:  right   = t; break;
	case 3:  thrust  = t; break;
	case 4:  back    = t; break;
	case 5:  fire    = t; break;
	case 6:  special = t; break;
	case 7:  altfire = t; break;
	case 8:  next    = t; break;
	case 9:  prev    = t; break;
	case 10: closest = t; break;
	case 11: chat = t; break;
	case 12: suicide = t; break;
	case KEY_DIALOG_OK:  save("scp.ini", getDescription()); return;
	case KEY_DIALOG_CANCEL: load("scp.ini", getDescription()); return;
	case KEY_DIALOG_CALIBRATE: calibrate_joysticks(); break;
	}
    }
  return;
}
