#ifndef TW_DIALOG_EDITOR_NODE
#define TW_DIALOG_EDITOR_NODE

#include <qlistview.h>
#include <qstring.h>
#include <qlistbox.h>
#include <qsortedlist.h>

class PlayerAnswer : public QObject
{
	Q_OBJECT
public:
	PlayerAnswer();
	
	QString m_strText;
	QString m_strAppearCondition;

	QString m_strCond[5];
	QString m_strAct[5];

public slots:
	virtual void setCondition1Line(const QString&);
	virtual void setCondition2Line(const QString&);
	virtual void setCondition3Line(const QString&);
	virtual void setCondition4Line(const QString&);
	virtual void setCondition5Line(const QString&);
	virtual void setAction1Line(const QString&);
	virtual void setAction2Line(const QString&);
	virtual void setAction3Line(const QString&);
	virtual void setAction4Line(const QString&);
	virtual void setAction5Line(const QString&);
	virtual void setAppearCondition(const QString&);
};


class NodeItem : public QObject, public QListViewItem
{ 
  Q_OBJECT
	// column 0 - String id, 1 - string name
public:

	NodeItem ( QListView * parent ); 

	QString m_strMusic;
	QString m_strPicture;
	QString m_strAlienText;
	QString m_strTextLocation;
	QString m_strFont;

	QList<PlayerAnswer> m_answers;

	QString key ( int column, bool ascending ) const;

public slots:
	virtual void setID       ( const QString & text);
	virtual void setName     ( const QString & text);
	virtual void setMusic    ( const QString & text);
	virtual void setPicture  ( const QString & text);
	virtual void setAlienText( const QString & text);
	virtual void setTextLocation(const QString& text);
	virtual void setFont(const QString& text);
};


#endif
