
#include "mainwidget.h"
#include <qtextbrowser.h>
#include <qtable.h> 
#include <qlistview.h>
#include <qlineedit.h>
#include <qxml.h> 
#include <qfile.h>
#include <qmessagebox.h>
#include <qmultilineedit.h>
#include <qimage.h>
#include <qdir.h>
#include <qcheckbox.h>
#include <qspinbox.h>

#include <assert.h>

#include "node.h"
#include "xmlparser.h"
#include <io.h>

extern "C" {
#	include "lua.h"
#	include "lualib.h"
#	include "lauxlib.h"
}

DialogEditor::DialogEditor( QWidget* parent, const char* name, WFlags fl ): DialogEditorGenerated(parent, name, fl)
{
	WriteLog("DialogEditor::DialogEditor\n");
	alienTextBrowser->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	alienTextBrowser->setText("<HTML><BODY><center><img width=\"100\" height=\"100\" src=\"./tw-logo.png\"><br>Alien text and picture will be here</center></BODY></HTML>");
	alienTextBrowser->mimeSourceFactory()->setExtensionType("qml", "text/utf8");

	CreateNewNode();
	answersListView->setSorting(-1);
}

DialogEditor::~DialogEditor()
{
	WriteLog("DialogEditor::~DialogEditor\n");
}


PlayerAnswer* DialogEditor::getPlayerAnswer(QString& text)
{
	NodeItem * node = (NodeItem*)nodeListView->currentItem();
	PlayerAnswer * a;
	for(a = node->m_answers.first();
			a; a = node->m_answers.next())
		if(a->m_strText == text)
			break;
	assert(a&&"Answer was not found in node!!!");
	return a;
}

int DialogEditor::getPlayerAnswerPos(QString& text)
{
	NodeItem * node = (NodeItem*)nodeListView->currentItem();
	PlayerAnswer * a;
	int pos = 0;
	for(a = node->m_answers.first();
			a; a = node->m_answers.next())
			{
				if(a->m_strText == text)
					break;
				pos++;
			}
	assert(a&&"Answer was not found in node!!!");
	return pos;
}

void DialogEditor::removeAnswer()
{		
	WriteLog("DialogEditor::removeAnswer()\n");
	QListViewItem * curAnsw = answersListView->currentItem();
	if (!curAnsw)
			return;
	NodeItem * node = (NodeItem*)nodeListView->currentItem();
	node->m_answers.remove(getPlayerAnswer(curAnsw->text(0)));

	delete curAnsw;
}

void DialogEditor::removeNode()
{
	WriteLog("DialogEditor::removeNode()\n");
	if(nodeListView->childCount()==1)
		return;
	
	QListViewItem* item= nodeListView->currentItem();
	QListViewItemIterator it( item );
	it++;
	if(it.current())
	{
		nodeListView->setCurrentItem(it.current());
	}
	else
	{
		QListViewItemIterator i( item );
		i--;
		nodeListView->setCurrentItem(i.current());
	}
	delete item;
}

void DialogEditor::CreateNewNode()
{
	WriteLog("DialogEditor::CreateNewNode()\n");
	int nodeCount = nodeListView->childCount();
	
	QString strId;
	if (nodeCount)
	{
		int id = 0;
		QListViewItem* item = nodeListView->firstChild ();
		QListViewItemIterator it( item );
		for(;it.current();it++)
		{
			if(it.current()->text(0).toInt()>id)
				id = it.current()->text(0).toInt();
		}
		strId.sprintf("%d",id+1);
	}
	else
	{
		strId = "0";
	}
	NodeItem* critem = new NodeItem ( nodeListView ) ;

	NodeItem * node = (NodeItem*)nodeListView->currentItem();
	if(node)
	{
		critem->setFont(node->m_strFont);
		critem->setPicture(node->m_strPicture);
		critem->setTextLocation(node->m_strTextLocation);
		critem->setMusic(node->m_strMusic);
	}
	critem->setName("New node name");
	critem->setID( strId );
	nodeListView->setCurrentItem(critem);
}

void DialogEditor::nodeChangedSlot(QListViewItem* i)
{
	WriteLog("DialogEditor::nodeChangedSlot\n");
	NodeItem * node = (NodeItem*)i;
	if (!i)
		return;

	// disconnect edits from previous
	disconnect( nodeIdLineEdit,     0, 0, 0 );
	disconnect( NodeNameLineEdit,   0, 0, 0 );
	disconnect( MusicEdit,          0, 0, 0 );
	disconnect( BackgroundLineEdit, 0, 0, 0 );
	disconnect( textLocationLineEdit, 0, 0, 0 );
	disconnect( fontLineEdit, 0, 0, 0 );

	connect( nodeIdLineEdit, SIGNAL( textChanged ( const QString&)), 
		node, SLOT(setID(const QString&)));
	connect( NodeNameLineEdit, SIGNAL( textChanged ( const QString&)), 
		node, SLOT(setName(const QString&)));
	connect( MusicEdit, SIGNAL( textChanged ( const QString&)), 
		node, SLOT(setMusic(const QString&)));
	connect( BackgroundLineEdit, SIGNAL( textChanged ( const QString&)), 
		node, SLOT(setPicture(const QString&)));
	connect( textLocationLineEdit, SIGNAL( textChanged ( const QString&)), 
		node, SLOT(setTextLocation(const QString&)));
	connect( fontLineEdit, SIGNAL( textChanged ( const QString&)), 
		node, SLOT(setFont(const QString&)));

	nodeIdLineEdit      ->setText(node->text(0));
	NodeNameLineEdit    ->setText(node->text(1));
	MusicEdit           ->setText(node->m_strMusic);
	BackgroundLineEdit  ->setText(node->m_strPicture);
	textLocationLineEdit->setText(node->m_strTextLocation);
	fontLineEdit        ->setText(node->m_strFont);

	// Set Browser
	QString browserText;
	browserText += "<HTML><BODY><CENTER>";
	if(node->m_strPicture!= "")
	{
		browserText += QString("").sprintf("<img width=\"100\" height=\"100\""
			"src=\"alien\" alt=\"Home\" border=\"0\"><br>");
	}

	browserText += node->m_strAlienText;
	browserText += "</CENTER></BODY></HTML>";

	alienTextBrowser->mimeSourceFactory()->setFilePath( QDir::currentDirPath() );
	alienTextBrowser->mimeSourceFactory()->setImage("alien",QImage(BackgroundLineEdit->text()));
	alienTextBrowser->setText(browserText);

	// Set Answers
	disconnectAnswer();
	answersListView->clear();
	for(PlayerAnswer * a = node->m_answers. last();
		a; a = node->m_answers.prev())
	{
		if (script_check_condition(a->m_strAppearCondition) || !TestModeCheckBox->isChecked ())
			QListViewItem * item = new QListViewItem(answersListView,a->m_strText);
	//	answersListView     ->setCurrentItem(item);
	}
}


void DialogEditor::disconnectAnswer()
{
	WriteLog("DialogEditor::disconnectAnswer()\n");
	disconnect(condition1LineEdit, 0, 0, 0);
	condition1LineEdit->setText("");
	condition1LineEdit->setEnabled(FALSE);
	disconnect(condition2LineEdit, 0, 0, 0);
	condition2LineEdit->setText("");
	condition2LineEdit->setEnabled(FALSE);
	disconnect(condition3LineEdit, 0, 0, 0);
	condition3LineEdit->setText("");
	condition3LineEdit->setEnabled(FALSE);
	disconnect(condition4LineEdit, 0, 0, 0);
	condition4LineEdit->setText("");
	condition4LineEdit->setEnabled(FALSE);
	disconnect(condition5LineEdit, 0, 0, 0);
	condition5LineEdit->setText("");
	condition5LineEdit->setEnabled(FALSE);

	disconnect(action1LineEdit, 0, 0, 0);
	action1LineEdit->setText("");
	action1LineEdit->setEnabled(FALSE);
	disconnect(action2LineEdit, 0, 0, 0);
	action2LineEdit->setText("");
	action2LineEdit->setEnabled(FALSE);
	disconnect(action3LineEdit, 0, 0, 0);
	action3LineEdit->setText("");
	action3LineEdit->setEnabled(FALSE);
	disconnect(action4LineEdit, 0, 0, 0);
	action4LineEdit->setText("");
	action4LineEdit->setEnabled(FALSE);
	disconnect(action5LineEdit, 0, 0, 0);
	action5LineEdit->setText("");
	action5LineEdit->setEnabled(FALSE);

	disconnect(appearConditionLineEdit, 0, 0, 0);
	appearConditionLineEdit->setText("");
	appearConditionLineEdit->setEnabled(FALSE);
}


void DialogEditor::answerChangedSlot(QListViewItem* item)
{
	WriteLog("DialogEditor::answerChangedSlot(QListViewItem* item)\n");
	disconnectAnswer();
	if(!item)
	{
		condition1LineEdit->setEnabled ( FALSE ) ;
		return;
	}
	

	PlayerAnswer * pa = getPlayerAnswer(item->text(0));

	connect( condition1LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setCondition1Line(const QString&)));
	condition1LineEdit->setEnabled(TRUE);
	connect( condition2LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setCondition2Line(const QString&)));
	condition2LineEdit->setEnabled(TRUE);
	connect( condition3LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setCondition3Line(const QString&)));
	condition3LineEdit->setEnabled(TRUE);
	connect( condition4LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setCondition4Line(const QString&)));
	condition4LineEdit->setEnabled(TRUE);
	connect( condition5LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setCondition5Line(const QString&)));
	condition5LineEdit->setEnabled(TRUE);

	connect( action1LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setAction1Line(const QString&)));
	action1LineEdit->setEnabled(TRUE);
	connect( action2LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setAction2Line(const QString&)));
	action2LineEdit->setEnabled(TRUE);
	connect( action3LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setAction3Line(const QString&)));
	action3LineEdit->setEnabled(TRUE);
	connect( action4LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setAction4Line(const QString&)));
	action4LineEdit->setEnabled(TRUE);
	connect( action5LineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setAction5Line(const QString&)));
	action5LineEdit->setEnabled(TRUE);

	connect( appearConditionLineEdit, SIGNAL( textChanged ( const QString&)), 
		pa, SLOT(setAppearCondition(const QString&)));
	appearConditionLineEdit->setEnabled(TRUE);

	condition1LineEdit->setText(pa->m_strCond[0]);
	condition2LineEdit->setText(pa->m_strCond[1]);
	condition3LineEdit->setText(pa->m_strCond[2]);
	condition4LineEdit->setText(pa->m_strCond[3]);
	condition5LineEdit->setText(pa->m_strCond[4]);

	action1LineEdit->setText(pa->m_strAct[0]);
	action2LineEdit->setText(pa->m_strAct[1]);
	action3LineEdit->setText(pa->m_strAct[2]);
	action4LineEdit->setText(pa->m_strAct[3]);
	action5LineEdit->setText(pa->m_strAct[4]);

	appearConditionLineEdit->setText(pa->m_strAppearCondition);

	commonMultiLineEdit->setText(item->text(0));
}

QString DialogEditor::GetXML()
{
	WriteLog("DialogEditor::edited()\n");
	QString strRes;
	strRes += "<NODES>";
	QListViewItem* item = nodeListView->firstChild ();
	QListViewItemIterator it( item );
	for(;it.current();it++)
	{
		NodeItem *item = (NodeItem*)it.current();
		strRes += "<NODE id=\""   + TWEscapeXML(item->text(0)) + "\"";
		strRes += " name=\""      + TWEscapeXML(item->text(1)) + "\"";
		strRes += " music=\""     + TWEscapeXML(item->m_strMusic) + "\"";
		strRes += " background=\""+ TWEscapeXML(item->m_strPicture) + "\"";
		strRes += " alien_text=\""+ TWEscapeXML(item->m_strAlienText) + "\"";
		strRes += " font=\""+ TWEscapeXML(item->m_strFont) + "\"";
		strRes += " text_location=\""+ TWEscapeXML(item->m_strTextLocation) + "\"";
		strRes += ">";


		for(PlayerAnswer * a = item->m_answers.first();
			a; a = item->m_answers.next())
		{	
			strRes +="<PLAYER_ANSWER ";
			strRes +="text=\"" + TWEscapeXML(a->m_strText) + "\" ";
			strRes +="appear_condition=\"" + TWEscapeXML(a->m_strAppearCondition) + "\">";
			
			for(int j=0;j<5;j++)
				if( !(a->m_strCond[j].isEmpty()) && !(a->m_strAct[j].isEmpty()))
				{
					strRes += "<ACTION ";
					strRes += "condition=\"" + TWEscapeXML(a->m_strCond[j]) + "\" ";
					strRes += "action=\"" + TWEscapeXML(a->m_strAct[j]) + "\">";
					strRes += "</ACTION>";
				}
			strRes +="</PLAYER_ANSWER>";
		}
		strRes += "</NODE>";
	}
	strRes += "</NODES>";
	return strRes;
}

void DialogEditor::loadDoc(QString fileName)
{
  WriteLog("DialogEditor::loadDoc(QString fileName)\n");

  if(fileName.find(".xml", 0, FALSE)==-1)
  {
	  QString mes;
	  mes.sprintf("file:\n%s\nDoes not have xml extension", fileName);

	  QMessageBox::warning (this, "TW-Light editor",
			mes);
  }

  QFile f(fileName);
  XMLParser handler(this);
  QXmlInputSource source(f);

  QXmlSimpleReader reader;
  reader.setContentHandler( &handler );
  reader.parse( source );
  if(nodeListView-> childCount ())
	nodeListView->setCurrentItem( nodeListView->firstChild ());
}

void DialogEditor::setAlienText()
{
	WriteLog("DialogEditor::setAlienText()\n");
	NodeItem * node = (NodeItem*)nodeListView->currentItem();
	node->m_strAlienText = commonMultiLineEdit->text();
	nodeChangedSlot(node);
}

void DialogEditor::setPlayerAnswerText()
{
	WriteLog("DialogEditor::setPlayerAnswerText()\n");
	QListViewItem * curAnsw = answersListView->currentItem();
	if(!curAnsw)
		return;
	PlayerAnswer * pa = getPlayerAnswer(curAnsw->text(0));
	pa->m_strText = commonMultiLineEdit->text();
	curAnsw->setText(0, commonMultiLineEdit->text());
}

void DialogEditor::AddPlayerAnswer()
{
	WriteLog("DialogEditor::AddPlayerAnswer()\n");
	NodeItem * node = (NodeItem*)nodeListView->currentItem();
	PlayerAnswer * item = new PlayerAnswer;
	item->m_strText = commonMultiLineEdit->text();
	item->m_strAppearCondition = "1";

	node->m_answers.append(item);
	nodeChangedSlot(node);
}

// To be implemented
bool DialogEditor::script_check_condition(QString & condition)
{
	WriteLog("DialogEditor::script_check_condition(QString & condition)\n");
	return true;
}

NodeItem * DialogEditor::getNodeItem(QString& id)
{
	WriteLog("DialogEditor::getNodeItem(QString& id)\n");
	QListViewItem* item = nodeListView->firstChild ();
	QListViewItemIterator it( item );
	for(;it.current();it++)
	{
		if(it.current()->text(0) == id)
			return (NodeItem *)it.current();
	}
	return NULL;
}


void DialogEditor::processAnswerSlot(QListViewItem* item)
{
	WriteLog("DialogEditor::processAnswerSlot(QListViewItem* item)\n");
	PlayerAnswer* answer = getPlayerAnswer(item->text(0));
	for(int i=0;i<5;i++)
	{
			lua_State * L = lua_open();
			lua_baselibopen(L);
			lua_iolibopen(L);
			lua_strlibopen(L);
			lua_mathlibopen(L);
			bool eva = lua_dostring(L, "function goto(id) gotoid = id; end");
			eva = lua_dostring(L, answer->m_strAct[i]);
			lua_getglobal(L, "gotoid");
			if (lua_isstring(L, -1)) 
			{
				const char * id = lua_tostring(L, -1);
				NodeItem * node = getNodeItem(QString(id));
				if(node)
					nodeListView->setCurrentItem(node);
			}
			lua_close(L);
	}
}

void DialogEditor::answerUp()
{
	NodeItem * node = (NodeItem*)nodeListView->currentItem();
	QListViewItem * item = answersListView->currentItem();

	if(!node || !item)
		return;
	
	int pos = getPlayerAnswerPos(item->text(0));
	if(pos==0)
		return;
	
	QString strText = item->text(0);
	PlayerAnswer* answer = node->m_answers.take(pos);
	node->m_answers.insert(pos-1, answer);

	nodeChangedSlot(node);	

	QListViewItemIterator it( answersListView->firstChild () );
	for(;it.current();it++)
	{
		if(it.current()->text(0)==strText)
		{
			answersListView->setCurrentItem(it.current());
			break;
		}
	}
}

void DialogEditor::answerDown()
{
	NodeItem * node = (NodeItem*)nodeListView->currentItem();
	QListViewItem * item = answersListView->currentItem();
	
	if(!node || !item)
		return;

	int pos = getPlayerAnswerPos(item->text(0));
	if(pos==node->m_answers.count()-1 )
		return;
	
	QString strText = item->text(0);

	PlayerAnswer* answer = node->m_answers.take(pos);
	node->m_answers.insert(pos+1, answer);

	nodeChangedSlot(node);	
	QListViewItemIterator it( answersListView->firstChild () );
	for(;it.current();it++)
	{
		if(it.current()->text(0)==strText)
		{
			answersListView->setCurrentItem(it.current());
			break;
		}
	}
}

