
#include "application.h"

#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qmultilineedit.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qwhatsthis.h>

#include "mainwidget.h"

#include "filesave.xpm"
#include "fileopen.xpm"
#include "createnode.xpm"
#include "removenode.xpm"
#include "setalientext.xpm"

#include "addplayeranswer.xpm"
#include "rmplayeranswer.xpm"
#include "setplayeranswertext.xpm"
#include "itemup.xpm"
#include "itemdown.xpm"
#include "evalanswer.xpm"

//file
static const char * fileOpenText = "<img source=\"fileopen\"> "
"Click this button to open a <em>new file</em>. <br><br>"
"You can also select the <b>Open command</b> from the File menu.";

static const char * fileSaveText = "Click this button to save the file you are "
"editing.  You will be prompted for a file name.\n\n"
"You can also select the Save command from the File menu.\n\n";

//Node
static const char * addNewNodeText = "Click this button to create new dialog node";
static const char * removeNodeText = "Click this button to destroy current dialog node";

//Edit
static const char * setAlienTextText = "Click this button to replace current alien text "
"with text in edit box";

static const char * addNewPlayerAnswerText = "Click this button to create new " 
"answer choise";

static const char * removePlayerAnswerText = "Click this button to remove "
"selected player answer";

static const char * setPlayerAnswerTextText = "Click this button to replace "
"selected player answer with text in edit box";
 
static const char * answerUpText = "Move answer up";
static const char * answerDownText = "Move answer down";

// Test
static const char * hideNotAllowedAnswersText = "Hide answer variants that does not "
"match current trigger selections";

static const char * evaluateAnswerText = "Click this button to evaluate answer, "
"it must change triggers and change current node";

ApplicationWindow::ApplicationWindow()
    : QMainWindow( 0, "example application main window", WDestructiveClose )
{
	WriteLog("ApplicationWindow\n");
	e = new DialogEditor( this, "editor" );

    e->setFocus();
    setCentralWidget( e );

	InitFileTools();
	InitNodeManagerTools();
	InitEditTools();
	InitTestTools();
	InitHelpTools();

	InitFileMenu();
	InitNodeManagerMenu();
	InitEditMenu();
	InitTestMenu();
	InitHelpMenu();

	strXML = e->GetXML();

    statusBar()->message( "Ready", 2000 );
	resize( 640, 480 );
}

ApplicationWindow::~ApplicationWindow()
{
	WriteLog("~ApplicationWindow\n");
}


void ApplicationWindow::InitFileMenu()
{
	WriteLog("ApplicationWindow::InitFileMenu\n");
	int id;

    QPixmap openIcon, saveIcon;
    openIcon = QPixmap( fileopen );
	saveIcon = QPixmap( filesave );

	QPopupMenu * file = new QPopupMenu( this );
    menuBar()->insertItem( "&File", file );

    file->insertItem( "&New", this, SLOT(newDoc()), CTRL+Key_N );

    id = file->insertItem( openIcon, "&Open",
			   this, SLOT(load()), CTRL+Key_O );
    file->setWhatsThis( id, fileOpenText );

    id = file->insertItem( saveIcon, "&Save",
			   this, SLOT(save()), CTRL+Key_S );
    file->setWhatsThis( id, fileSaveText );
    id = file->insertItem( "Save &as...", this, SLOT(saveAs()) );
    file->setWhatsThis( id, fileSaveText );
    file->insertSeparator();

    file->insertSeparator();
    file->insertItem( "&Close", this, SLOT(close()), CTRL+Key_W );
    file->insertItem( "&Quit", qApp, SLOT( closeAllWindows() ), CTRL+Key_Q );
}

void ApplicationWindow::InitFileTools()
{
	WriteLog("ApplicationWindow::InitFileTools()\n");
    QPixmap openIcon, saveIcon;

    fileTools = new QToolBar( this, "file operations" );
    fileTools->setLabel( tr( "File Operations" ) );

    openIcon = QPixmap( fileopen );
    QToolButton * fileOpen
	= new QToolButton( openIcon, "Open File", QString::null,
			   this, SLOT(load()), fileTools, "open file" );

    saveIcon = QPixmap( filesave );
    QToolButton * fileSave
	= new QToolButton( saveIcon, "Save File", QString::null,
			   this, SLOT(save()), fileTools, "save file" );

    QWhatsThis::add( fileOpen, fileOpenText );
    QMimeSourceFactory::defaultFactory()->setPixmap( "fileopen", openIcon );
    QWhatsThis::add( fileSave, fileSaveText );

}


void ApplicationWindow::InitNodeManagerMenu()
{
	WriteLog("ApplicationWindow::InitNodeManagerMenu()\n");
	int id;

    QPixmap createnodeIcon, removenodeIcon;
	createnodeIcon = QPixmap( createnode_xpm );
	removenodeIcon = QPixmap( removenode_xpm );

	QPopupMenu * node = new QPopupMenu( this );
    menuBar()->insertItem( "&Node", node );

    id = node->insertItem( createnodeIcon, "Add new node",
			   this, SLOT(AddNewNodeSlot()), ALT+Key_N );

    node->setWhatsThis( id, addNewNodeText );

    id = node->insertItem( removenodeIcon, "Remove node",
			   this, SLOT(RemoveNodeSlot()), ALT+Key_K );
    node->setWhatsThis( id, removeNodeText );
}

void ApplicationWindow::InitNodeManagerTools()
{
	WriteLog("ApplicationWindow::InitNodeManagerTools");
	QPixmap createnodeIcon, removenodeIcon;
	createnodeIcon = QPixmap( createnode_xpm );
	removenodeIcon = QPixmap( removenode_xpm );

	nodeTools = new QToolBar( this, "Node manager operations" );
    nodeTools->setLabel( tr( "Node manager Operations" ) );

	QToolButton * addNewNode
	= new QToolButton( createnodeIcon, "Add new node", QString::null,
			   this, SLOT(AddNewNodeSlot()), nodeTools, "open file" );

    QToolButton * removeNode
	= new QToolButton( removenodeIcon, "Remove node", QString::null,
			   this, SLOT(RemoveNodeSlot()), nodeTools, "open file" );

	QWhatsThis::add( addNewNode, addNewNodeText );
    QWhatsThis::add( removeNode, removeNodeText );
}

void ApplicationWindow::InitEditMenu()
{
	WriteLog("ApplicationWindow::InitEditMenu()\n");
		int id;

    QPixmap setalientextIcon, addplayeranswerIcon;
	QPixmap rmplayeranswerIcon, setplayeranswertextIcon;
	QPixmap answerUpIcon, answerDownIcon;

	setalientextIcon = QPixmap(setalientext_xpm);
	addplayeranswerIcon = QPixmap(addplayeranswer_xpm);
	rmplayeranswerIcon = QPixmap(rmplayeranswer_xpm);
	setplayeranswertextIcon = QPixmap(setplayeranswertext_xpm);
	answerUpIcon = QPixmap(answerup_xpm);
	answerDownIcon = QPixmap(answerdown_xpm);

	QPopupMenu * edit = new QPopupMenu( this );
    menuBar()->insertItem( "&Edit", edit );

    id = edit->insertItem( setalientextIcon, "Set Alien Text",
			   this, SLOT(SetAlienTextSlot()), ALT+Key_T );

    edit->setWhatsThis( id, setAlienTextText );

    id = edit->insertItem( addplayeranswerIcon, "Add new player answer",
			   this, SLOT(AddNewPlayerAnswerSlot()), ALT+Key_A );
    edit->setWhatsThis( id, addNewPlayerAnswerText );


	id = edit->insertItem( rmplayeranswerIcon, "Remove player answer",
			   this, SLOT(RemovePlayerAnswerSlot()), ALT+Key_R );

    edit->setWhatsThis( id, removePlayerAnswerText );

    id = edit->insertItem( setplayeranswertextIcon, "Set Player Answer Text",
			   this, SLOT(SetPlayerAnswerTextSlot()), ALT+Key_F );
    edit->setWhatsThis( id, setPlayerAnswerTextText );

	id = edit->insertItem( answerUpIcon, "Move answer Up",
			   this, SLOT(answerUpSlot()), 0 );
    edit->setWhatsThis( id, answerUpText );

	id = edit->insertItem( answerDownIcon, "Move answer down",
			   this, SLOT(answerDownSlot()), 0 );
    edit->setWhatsThis( id, answerDownText );

}

void ApplicationWindow::InitEditTools()
{
	WriteLog("ApplicationWindow::InitEditTools()\n");
    QPixmap setalientextIcon, addplayeranswerIcon;
	QPixmap rmplayeranswerIcon, setplayeranswertextIcon;
	QPixmap answerUpIcon, answerDownIcon;

	setalientextIcon = QPixmap(setalientext_xpm);
	addplayeranswerIcon = QPixmap(addplayeranswer_xpm);
	rmplayeranswerIcon = QPixmap(rmplayeranswer_xpm);
	setplayeranswertextIcon = QPixmap(setplayeranswertext_xpm);
	answerUpIcon = QPixmap(answerup_xpm);
	answerDownIcon = QPixmap(answerdown_xpm);

	editTools = new QToolBar( this, "edit operations" );
    editTools->setLabel( tr( "Edit Operations" ) );

	QToolButton * setAlienText
	= new QToolButton( setalientextIcon, "Set Alien Text", QString::null,
			   this, SLOT(SetAlienTextSlot()), editTools, "open file" );

    QToolButton * addPlayerAnswer
	= new QToolButton( addplayeranswerIcon, "Add new player answer", QString::null,
			   this, SLOT(AddNewPlayerAnswerSlot()), editTools, "open file" );

	QToolButton * removePlayerAnswer
	= new QToolButton( rmplayeranswerIcon, "Remove player answer", QString::null,
			   this, SLOT(RemovePlayerAnswerSlot()), editTools, "open file" );

	QToolButton * setPlayerAnswer
	= new QToolButton( setplayeranswertextIcon, "Set Player Answer Text", QString::null,
			   this, SLOT(SetPlayerAnswerTextSlot()), editTools, "save file" );

	QToolButton * answerUp
	= new QToolButton( answerUpIcon, "Move Answer up", QString::null,
			   this, SLOT(answerUpSlot()), editTools, "save file" );

	QToolButton * answerDown
	= new QToolButton( answerDownIcon, "Move Unswer down", QString::null,
			   this, SLOT(answerDownSlot()), editTools, "save file" );

	QWhatsThis::add( setAlienText, setAlienTextText );
    QWhatsThis::add( addPlayerAnswer, addNewPlayerAnswerText );
    QWhatsThis::add( removePlayerAnswer, removePlayerAnswerText );
	QWhatsThis::add( setPlayerAnswer, setPlayerAnswerTextText );
	QWhatsThis::add( answerUp, answerUpText );
	QWhatsThis::add( answerDown, answerDownText );
}

void ApplicationWindow::InitTestMenu()
{
	WriteLog("ApplicationWindow::InitTestMenu()\n");
	int id;
	QPixmap evalanswerIcon;
    evalanswerIcon = QPixmap( evalanswer_xpm );

	QPopupMenu * test = new QPopupMenu( this );
    menuBar()->insertItem( "&Test", test );

    id = test->insertItem( evalanswerIcon, "Evaluate answer",
			   this, SLOT(evaluateAnswerSlot()), CTRL+Key_R );
    test->setWhatsThis( id, evaluateAnswerText );
}

void ApplicationWindow::InitTestTools()
{
	WriteLog("ApplicationWindow::InitTestTools()\n");
	QPixmap evalanswerIcon;
    evalanswerIcon = QPixmap( evalanswer_xpm );

	testTools = new QToolBar( this, "Dialog Test" );
    testTools->setLabel( tr( "Dialog Test" ) );

    QToolButton * evalAnswer
	= new QToolButton( evalanswerIcon, "Evaluate answer", QString::null,
			   this, SLOT(evaluateAnswerSlot()), testTools, "open file" );


//	QWhatsThis::add( hideNotAllowed, hideNotAllowedAnswersText );
    QWhatsThis::add( evalAnswer, evaluateAnswerText );
};

void ApplicationWindow::InitHelpMenu()
{
	WriteLog("ApplicationWindow::InitHelpMenu()\n");
	QPopupMenu * help = new QPopupMenu( this );
    menuBar()->insertSeparator();
    menuBar()->insertItem( "&Help", help );

    help->insertItem( "&About", this, SLOT(about()), Key_F1 );
    help->insertSeparator();
    help->insertItem( "What's &This", this, SLOT(whatsThis()), SHIFT+Key_F1 );
}


void ApplicationWindow::InitHelpTools()
{
	WriteLog("ApplicationWindow::InitHelpTools()\n");
	helpTools = new QToolBar( this, "What is this" );
    helpTools->setLabel( tr( "What is this" ) );

	(void)QWhatsThis::whatsThisButton( helpTools );
}


void ApplicationWindow::newDoc()
{
	WriteLog("ApplicationWindow::newDoc()\n");
    ApplicationWindow *ed = new ApplicationWindow;
    ed->setCaption("TW-Light Dialog Editor");
    ed->show();
}

void ApplicationWindow::load()
{
	WriteLog("ApplicationWindow::load()\n");
    QString fn = QFileDialog::getOpenFileName( QString::null, "XML files (*.xml)",
					       this);
    if ( !fn.isEmpty() )
	load( fn );
    else
	statusBar()->message( "Loading aborted", 2000 );
}


void ApplicationWindow::load( QString fileName )
{
	WriteLog("ApplicationWindow::load( const char *fileName )");
	e->loadDoc(fileName);
	strXML = e->GetXML();

	filename = fileName;
    setCaption( fileName );
    QString s;
    s.sprintf( "Loaded document %s", fileName );
    statusBar()->message( s, 2000 );
}


void ApplicationWindow::save()
{
	WriteLog("ApplicationWindow::save()");
    if ( filename.isEmpty() ) {
	saveAs();
	return;
    }

    QString text = e->GetXML();
    QFile f( filename );
    if ( !f.open( IO_WriteOnly ) ) {
	statusBar()->message( QString("Could not write to %1").arg(filename),
			      2000 );
	return;
    }

    QTextStream t( &f );
    t << text;
    f.close();

    strXML = text;

    setCaption( filename );
    statusBar()->message( QString( "File %1 saved" ).arg( filename ), 2000 );
}


void ApplicationWindow::saveAs()
{
	WriteLog("ApplicationWindow::saveAs()");
    QString fn = QFileDialog::getSaveFileName( QString::null, "XML files (*.xml)",
					       this );
    if ( !fn.isEmpty() ) {
		if(fn.find(".xml", 0, FALSE)==-1)
		{
			fn += ".xml";
		}
	filename = fn;
	save();
    } else {
	statusBar()->message( "Saving aborted", 2000 );
    }
}

void ApplicationWindow::closeEvent( QCloseEvent* ce )
{
	WriteLog("ApplicationWindow::closeEvent( QCloseEvent* ce )\n");
	if ( strXML == e->GetXML() ) {
	ce->accept();
	return;
    }

    switch( QMessageBox::information( this, "TW-Light Dialog Editor",
				      "The document has been changed since "
				      "the last save.",
				      "Save Now", "Cancel", "Leave Anyway",
				      0, 1 ) ) {
    case 0:
	save();
	ce->accept();
	break;
    case 1:
    default: // just for sanity
	ce->ignore();
	break;
    case 2:
	ce->accept();
	break;
    }
}

// node
void ApplicationWindow::AddNewNodeSlot()
{
	WriteLog("ApplicationWindow::AddNewNodeSlot()\n");
	e->CreateNewNode();
}

void ApplicationWindow::RemoveNodeSlot()
{
	WriteLog("ApplicationWindow::RemoveNodeSlot()\n");
	e->removeNode();
}

// edit
void ApplicationWindow::SetAlienTextSlot()
{
	WriteLog("ApplicationWindow::SetAlienTextSlot()\n");
	e->setAlienText();
}

void ApplicationWindow::AddNewPlayerAnswerSlot()
{
	WriteLog("ApplicationWindow::AddNewPlayerAnswerSlot()\n");
	e->AddPlayerAnswer();
}

void ApplicationWindow::RemovePlayerAnswerSlot()
{
	WriteLog("ApplicationWindow::RemovePlayerAnswerSlot()\n");
	e->removeAnswer();
}

void ApplicationWindow::SetPlayerAnswerTextSlot()
{
	WriteLog("ApplicationWindow::SetPlayerAnswerTextSlot()\n");
	e->setPlayerAnswerText();
}

void ApplicationWindow::answerUpSlot()
{
	e->answerUp();
}

void ApplicationWindow::answerDownSlot()
{
	e->answerDown();
}


// Test
void ApplicationWindow::hideNotAllowedAnswersSlot()
{
	WriteLog("ApplicationWindow::hideNotAllowedAnswersSlot()\n");
		QMessageBox::information( this, "hideNotAllowedAnswersSlot",
                              "Not implemented yet");
}
void ApplicationWindow::evaluateAnswerSlot()
{
	WriteLog("ApplicationWindow::evaluateAnswerSlot()\n");
	QListViewItem * answ = e->answersListView->currentItem();
	if(answ)
		e->processAnswerSlot(answ);
}

// Help
void ApplicationWindow::about()
{
	WriteLog("ApplicationWindow::about()\n");
    QMessageBox::about( this, "TW-Light Dialog Editor",
			"Copyright (C) 2004 Yura Semasko aka Yurand.\n"
			"http://www.tw-light.berlios.de yurand@land.ru\n\n"
			"This program is free software; you can redistribute\n"
			"it and/or modify it under the terms of the GNU General\n"
			"Public License as published by the Free Software\n"
			"Foundation; either version 2 of the License, or (at \n"
			"your option) any later version.");
}

