/* $Id: scp.h,v 1.4 2004/08/08 17:36:03 Yura Exp $ */ 
/*
This file is part of "TW-Light" 
                    http://timewarp.sourceforge.net/
Copyright (C) 2001-2004  TimeWarp development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

#ifndef __SCP_H__
#define __SCP_H__


#include "allegro.h"

//class SAMPLE;

#include <string>
class VideoWindow;

std::string tw_version();

/// TEAMS dialog - from here you can select controllers for each player, and access their respective fleets. (FLEET dialog)
void change_teams();

void edit_fleet(int player) ;

int connect_menu(VideoWindow *window, char **address, int *port) ;
int is_escape_pressed() ;
void ship_view_dialog(int si = 0, class Fleet *fleet = NULL);

int scp_fleet_dialog_text_list_proc(int msg, DIALOG* d, int c);
int scp_fleet_dialog_bitmap_proc(int msg, DIALOG* d, int c);

int d_check_proc_fleeteditor(int msg, DIALOG *d, int c);

// list box getter functions
char *playerListboxGetter(int index, int *list_size) ;
char *controlListboxGetter(int index, int *list_size) ;
char *viewListboxGetter(int index, int *list_size) ;

int handleSoundSliderChange(void *dp3, int d2);
int handleMusicSliderChange(void *dp3, int d2);


extern DATAFILE* g_game_data;

extern std::string menuAccept;
extern std::string menuFocus;
extern std::string menuDisabled;
extern std::string menuSpecial;

#define COMMAND_LINE_SERVER_LONG "--server="
#define COMMAND_LINE_MAX_CLIENTS_LONG "--max-clients="
#define COMMAND_LINE_CLIENT_PORT_LONG "--client-port="
	
///The default server address to connect to as a client.  Only meaningful
///in client mode.
#define DEFAULT_SERVER_ADDRESS "localhost"
///The default server port to connect to as a client.  Only meaningful 
///in client mode.
#define DEFAULT_SERVER_PORT 15515

///the server address to connect to in client mode.
extern std::string serverAddress;
///the server port to connect to in client mode.  
extern unsigned serverPort;

///the default maximum number of clients that can connect in server mode.
#define DEFAULT_SERVER_MAX_CLIENTS 15
///the maximum number of clients that can join in server mode.  Any additional
///clients that try to join up won't be able to.  Only meaningful in server mode.
extern unsigned serverMaxClients;

///the default port for a client to listen on.  Normally, with one client per
///machine, you don't have to specify this.  But to run multiple clients on a
///single machine, you should specify a unique port for each client on the same
///machine.  
#define DEFAULT_CLIENT_PORT 15516
///the port to listen to in client mode.  Only meaningful in client mode.
extern unsigned clientPort;


extern int MAX_TEAMS;

/*! This is the title music file name */
extern std::string titleMusic;

/*! this is the filename of the license. */
#define COPYING_FILE "COPYING"
	
#ifndef DATAFILE_PATH
#define DATAFILE_PATH "gamedata/"
#endif

extern std::string datafile_path;

int create_user_ini();
std::string data_full_path(std::string path);
std::string home_ini_full_path(std::string path);



#define copy_buf() blit(d_buf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H)

// Data Define
#define TW_FONT_ENGLISH     1
#define TW_FONT_PALETTE     2

// Data
#define D_FONT_ENGLISH	((FONT*)g_game_data[TW_FONT_ENGLISH].dat)


#endif // __SCP_H__
