/*
This file is part of "TW-Light" 
                    http://tw-light.berlios.de/
Copyright (C) 2001-2004  TimeWarp development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

#include <string.h>
#include <stdio.h>
#include <allegro.h>

#include "melee.h"
#include "ais.h"
#include "id.h"

#include "frame.h"
#include "gui.h"

#include "mnet1.h"
#include "mview.h" //remove this
#include "mfleet.h"
#include "scp.h"
#include "other/dialogs.h"

const char num_controls = 4;
static char *gcc_sucks_dick[num_controls + 2] = 
		{
	"none", 
	"Human", 
	"MoronBot", 
	"WussieBot", 
	"VegetableBot", 
	NULL};
char **control_name = gcc_sucks_dick;



void animate_target(Frame *frame, SpaceLocation *t, int dx, int dy, int r, int c) 
{
  return;
}





int control2number(const char *name) 
{
  if (!name) 
    return 0;
  for (int i = 0; i < num_controls+1; i += 1) 
    {
      if (!strcmp(name, control_name[i])) 
	return i;
    }
  return 0;
}

Control *getController(const char *type, const char *name, int channel) 
{
  if ((channel != -1) && (channel & Game::_channel_buffered)) 
    {
      tw_error("getController - invalid channe");
    }
  switch (control2number(type)) 
    {
    case  ai_index_human:     return new ControlHuman(name, channel);
    case  ai_index_moron:     return new ControlMoron(name, channel);
    case  ai_index_wussie:    return new ControlWussie(name, channel);
    case  ai_index_vegetable: return new ControlVegetable(name, channel);
    }
  return NULL;
}


int Control::rand() 
{
  STACKTRACE;
  if (channel == Game::channel_none) 
    return random();
  return (::rand() ^ ((::rand() << 12) + (::rand() <<24))) & 0x7fffffff;
}

void Control::setup() {
  STACKTRACE;}
void Control::select_ship(Ship* ship_pointer, const char* ship_name) 
{
  STACKTRACE;
  ship = ship_pointer;
  if (ship) 
    {
      ship->control = this;
      if (temporary && (channel != Game::channel_none) && (already != 0) && (already != game->lag_frames)) 
	{
	  tw_error ("Control::select_ship - bad operation (incompatible with networking)");
	}
    }
  target_stuff() ;
  return;
}

void Control::load(const char* inifile, const char* inisection) 
{
  STACKTRACE;
  return;
}
void Control::save(const char* inifile, const char* inisection) 
{
  STACKTRACE;
  return;
}
SpaceLocation *Control::get_focus() 
{
  STACKTRACE;
  if (ship) 
    return ship->get_focus();
  else return NULL;
}


int Control::choose_ship(VideoWindow *window, char * prompt, Fleet *fleet) 
{
  STACKTRACE;
	//automatically select a random ship, without interrupting the user.
	// HumanControl is where a user can select a ship herself.
		
	int slot = 0;
	if (fleet->getSize() == 0) {tw_error ("Empty fleet! (prompt:%s)", prompt);}
	
	slot = rand() % fleet->getSize();
	return slot ;
}
void Control::set_target(int i) 
{
  STACKTRACE;
  if (i >= targets->N) {tw_error("oscar hamburger!!!!!!!!!");}
  if (i == -1) 
    {
      index = i;
      target = NULL;
      return;
    }
  if (!valid_target(targets->item[i])) {tw_error("oscer hambuger");}
  index = i;
  target = targets->item[index];
  return;
}

void Control::target_stuff() 
{
  STACKTRACE;
  if (index == -1) 
    {
      if (targets->N) 
	{
	  index = random() % targets->N;
	  target = targets->item[index];
	  goto validate;
	}
      else 
	{
	  goto done;
	}
    }
 blah:
  if (index >= targets->N) 
    {
      if (targets->N) 
	{
	  index -= 1;
	  if (index < 0) index = 0;
	  goto blah;
	}
      else 
	{
	  index = -1;
	  target = NULL;
	  goto change;
	}
    }
  if (target == targets->item[index]) 
    {
      goto done;
    }
  else goto search;
 search:
  int o;
  o = index;
  for (index = 0; index < targets->N; index += 1) {
		if (targets->item[index] == target) {
		  goto done;
		}
  }
	index = o;
 validate:
	if (!ship) {
	  goto done;
	}
	int start;
	start = index;
	while (!valid_target(targets->item[index])) {
	  index = (index + 1) % targets->N;
	  if (index == start) {
	    index = -1;
	    target = NULL;
			goto change;
	  }
	}
	target = targets->item[index];
 change:
 done:
	return;
}

void Control::calculate() 
{
  STACKTRACE; 
  if (!exists()) 
    return;

  target_stuff();
  
  if (ship) 
    {
      if (!ship->exists() || (ship->death_counter != -1)) 
	{
	  //message.print(5000, 12, "Ship died in frame %d", game->frame_number);
	  select_ship( NULL, NULL);
	}
      else keys = think();
    }
  
  if (!ship) 
    {
      keys = 0;
      if (temporary) 
	state = 0;
    }
  
  if (channel != Game::channel_none) 
    {
      //prediction stuff
      _prediction_keys[_prediction_keys_index] = keys;
      _prediction_keys_index = (_prediction_keys_index + 1) & (_prediction_keys_size-1);
      
      //network prep for dieing (set state to unbuffering)
      if (!ship && temporary && (already > 0)) already = -already;
      
      //network traffic
      int lf = game->lag_frames;
      if (0) ;
      else if (already < 0) 
	{//unbuffering
	  game->log->unbuffer(channel + Game::_channel_buffered, &keys, sizeof(TWKeyCode));
	  keys = intel_ordering_short(keys);
	  already += 1;
	}
      else if (already < lf) 
	{//buffering
	  keys = intel_ordering_short(keys);
	  game->log->buffer(channel + Game::_channel_buffered, &keys, sizeof(TWKeyCode));
	  keys = intel_ordering_short(keys);
	  already += 1;
	}
      else if (already > lf) 
	{//stupid error check
	  tw_error("Control::calculate() - inconcievable!");
	}
      else {//stable, perform no action
	game->log_short(channel + Game::_channel_buffered, keys);
      }
    }
  
  return;
}

int Control::think()
{
  STACKTRACE;
  return 0;
}
char *Control::getDescription() 
{
  STACKTRACE;
   return iname;
}
void Control::_event(Event *e) 
{
  STACKTRACE;
   //add code for lag increase / decrease here
  return;
}
Control::Control(const char *name, int _channel, ControlType controlType) : temporary(false), target_sign_color(255), 
						   already(0), channel(_channel), ship(NULL), 
						   target(NULL), index(-1), always_random(0), _prediction_keys(NULL),
						   _controlType(controlType)
{
  STACKTRACE;
  id |= ID_CONTROL;
  attributes |= ATTRIB_SYNCHED;
  if (channel != Game::channel_none) 
    {
      attributes |= ATTRIB_LOGGED;
      _prediction_keys = new TWKeyCode[_prediction_keys_size];
      _prediction_keys_index = 0;
      if (channel & Game::_channel_buffered) 
	{
	  tw_error("invalid channel!");
	}
    }
  iname = strdup(name);
}
Control::~Control() 
{
   if (_prediction_keys) delete[] _prediction_keys;
}
bool Control::die() 
{
  STACKTRACE;
  if (channel == Game::channel_none) 
    return Presence::die();
  // controls CANNOT arbitrarily be killed off, because the deal with networking directly
  tw_error("controls cannot be killed");
  //the error can be removed eventually... 
  //I just want to find out if anything is actually calling this
  //because before this function was added, that would have resulted in a desynch
  return false;
}

bool Control::valid_target(SpaceObject *t) 
{
  STACKTRACE;
  // GEO: this error sometimes occur, unknown why.
  // speculation: it happened with a wasx clone; perhaps its mother died before
  // and since it shared control, and didn't check for a dead mother before the
  // ship::calculate function, it may've crashed.
  // This kinda thing may occur more often in case control is shared among objects
  if (!ship) 
    {
      tw_error("Control::valid_target - !ship");
    }
  if (t->sameTeam(ship)) 
    return false;
  if (!t->exists()) 
    return false;
  return true;
}

void Control::animate(Frame *space) 
{
  STACKTRACE;
  if (!ship) 
    return;
  if (!target || target->isInvisible()) 
    return;
  if (!(attributes & ATTRIB_ACTIVE_FOCUS)) 
    return;
  if (targets->N < 3) 
    return;
  if (target_sign_color == 255) 
    return;
  
  int i = target_sign_color;
  int col = target_sign_color;
  animate_target(space, target, (i%3)*2-2, ((i/3)%3)*2-2, 140 + i, pallete_color[col]);
}

