/*
  This file is part of "TW-Light" 
  http://tw-light.berlios.de/
  Copyright (C) 2001-2004  TimeWarp development team

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef __TW_LIGHT_GAME_HIERARCHY_H__
#define __TW_LIGHT_GAME_HIERARCHY_H__

#include "melee/mgame.h"
#include <set>
#include <map>
#include <string>

#include "util/history.h"

class MainGame;


/// an extended game class, which can be embedded in a sequence
/// of initiated games ...
template<class TMainGame>
class SubGame : public Game
{
 public:

  TMainGame	*maingame;		///< Main game handle multiple game subgames

  SubGame()
  {
  }
  
  ~SubGame()
  {
  }

  /// This init is cutted so it can be called safe several times by different subgames
  virtual void init(Log *_log, const std::string& save)
    {
      STACKTRACE;
      
      log = _log;
      if (!log) 
	{
	  log = new Log();
	  log->init();
	}
  
      lag_frames = 0;
      show_fps = 0;
      game_time = 0;
      frame_time = 1;
      frame_number = 0;
      hiccup_margin = 100;
      next_tic_time = get_time();
      next_render_time = game_time;
      next_fps_time = game_time;
      view_locked = false;
      local_checksum = client_checksum = server_checksum = 0;
      
      Physics::init();
      prepare();
      
      if (!window) 
	{
	  window = new VideoWindow();
	  window->preinit();
	}
      
      change_view(get_config_string("View", "View", "Hero")); 
      
      
      if (!is_paused()) pause();
      
      text_mode(-1);
      
      
      msecs_per_fps	= maingame->msecs_per_fps;
      msecs_per_render	= maingame->msecs_per_render;
      frame_time	= maingame->frame_time;
      normal_turbo	= maingame->normal_turbo;
      f4_turbo		= maingame->f4_turbo;
      turbo             = normal_turbo;
      friendly_fire	= maingame->friendly_fire;
      shot_relativity	= maingame->shot_relativity;
      
      
      lag_frames = maingame->lag_frames;
      
      tic_history = new Histograph(128);
      render_history = new Histograph(128);
      
      prepare();
      
      return;
      }
 protected:
  
};




///  This class should allow you to start, play, end a game from within a game (while the
///  other games are also running in the background). Games and their physics are independent.
class MainGame : public Game
{
 protected:
  std::string _active_subgame;
  std::map<std::string,Game*> _subgame;
  
    /// Switch to subgame by name
  bool switch_to(const std::string& name);
 public:
  
  MainGame();
 
  virtual void setActiveGame(const std::string& name);
  virtual void addsubgame(Game *asubgame,  const std::string& name);
  virtual void removesubgame(Game* g);

  virtual int play();
};


#endif


