/*
  This file is part of "TW-Light" 
  http://tw-light.berlios.de/
  Copyright (C) 2001-2004  TimeWarp development team

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/


#include <allegro.h>
#include <stdio.h>
#include <string.h>

#include "melee.h"

#include "melee/mlog.h"
#include "melee/mcontrol.h"
#include "melee/mframe.h"
#include "melee/mview.h"
#include "melee/mitems.h"

#include "scp.h"
#include "util/history.h"


#include "gamehierarchy.h"
#include "ggob.h"

#include <algorithm>

MainGame* g_maingame = NULL;


MainGame::MainGame()
{
  STACKTRACE;
  g_maingame = this;
  _active_subgame = "";
}

void MainGame::addsubgame(Game *asubgame, const std::string& name)
{
  STACKTRACE;

  asubgame->_name = name;
  ((SubGame<MainGame>*)asubgame)->maingame = this;

  asubgame->preinit();
  asubgame->window = new VideoWindow;
  asubgame->window->preinit();
  asubgame->window->init(&videosystem->window);
  asubgame->window->locate(0,0,0,0,0,1,0,1);

  asubgame->init(log, "");	// all subgames share the same log (is this ok?)

  _subgame[name]=asubgame;
}


void MainGame::removesubgame(Game* g)
{
  STACKTRACE;

  _subgame.erase(_subgame.find(g->_name));
  g->log->deinit();	// this is empty, dunno why
  game = NULL;
  delete g;	// this _must_ be deleted completely, otherwise the gamedata aren't removed  
}


int MainGame::play()
{
  STACKTRACE;

  // Nothing to play
  if(!_subgame.size())
    return GAME_STATE_FINISHED;

  set_resolution(window->w, window->h);
  prepare();
  if (is_paused()) unpause();
  
  while(isGameDone() == GAME_STATE_PLAYING)
    {
      poll_input(); 
      videosystem->poll_redraw();     
      if(!switch_to(_active_subgame))
	{
	  tw_error(("Unknown sybgame: " + _active_subgame).c_str());
	}
      (_subgame[_active_subgame])->play();
    }
  return isGameDone();
}

void MainGame::setActiveGame(const std::string& name)
{
  STACKTRACE;
  _active_subgame = name;
}

bool MainGame::switch_to(const std::string& name)
{
  STACKTRACE;
  if(_subgame.find(name)!=_subgame.end())
    {
      setActiveGame(name);
      (_subgame[_active_subgame])->prepare();
      (_subgame[_active_subgame])->setGameDone(GAME_STATE_PLAYING);
      return true;
    }
  return false;
}
