#!/usr/bin/python
import pickle,os,sys,ggob,copy


gamedata = ggob.SaveGobGameInfo.getInstance()

class Enemy:
    def __init__(self):
        pos_x = 0
        pos_y = 0

class GameData:
    def __init__(self):
        pass
    def getData(self):
        # get player possession
        self.starbucks        = copy.deepcopy(gamedata.starbucks)
        self.buckazoids       = copy.deepcopy(gamedata.buckazoids)
        self.kills            = copy.deepcopy(gamedata.kills)
        # ship
        self.pos_x            = copy.deepcopy(gamedata.pos_x)
        self.pos_y            = copy.deepcopy(gamedata.pos_y)
        # enemy
        self.enemy            = []
        for i in gamedata.getTst():
            e = Enemy()
            e.pos_x = i.pos_x
            e.pos_y = i.pos_y
            self.enemy.append(e)
    def commitData(self):
        # commit player possession
        gamedata.starbucks          = self.starbucks
        gamedata.buckazoids         = self.buckazoids
        gamedata.kills              = self.kills
        # ship
        gamedata.pos_x              = self.pos_x
        gamedata.pos_y              = self.pos_y
        # enemy
        e = ggob.vectorEnemySaveData(len(self.enemy))
        for i in range(0, len(self.enemy)):
            e[i].pos_x = self.enemy[i].pos_x
            e[i].pos_y = self.enemy[i].pos_y
        gamedata.setTst(e)
        
class SaveManager:
    def __init__(self, file):
	self.file = file
	self.data = GameData()
    def saveSelf(self):
	f = open(self.file, "w", pickle.HIGHEST_PROTOCOL)
	pickle.dump(self.data,f)
	f.close()
    def getData(self):
        self.data.getData()
    def loadSelf(self):
	f = open(self.file, "r")
	self.data = pickle.load(f)
	f.close()
        self.data.commitData()
