
#ifndef APPLICATION_H
#define APPLICATION_H

#include <qmainwindow.h>

class DialogEditor;
class QToolBar;
class QPopupMenu;

class ApplicationWindow: public QMainWindow
{
    Q_OBJECT
public:
    ApplicationWindow();
    ~ApplicationWindow();
    
protected:
    void closeEvent( QCloseEvent* );

	void InitFileTools();
	void InitNodeManagerTools();
	void InitEditTools();
	void InitTestTools();
	void InitHelpTools();

	void InitFileMenu();
	void InitNodeManagerMenu();
	void InitEditMenu();
	void InitTestMenu();
	void InitHelpMenu();

private slots:
	// file 
    void newDoc();
    void load();
    void load( QString fileName );
    void save();
    void saveAs();
   
	// node
	void AddNewNodeSlot();
	void RemoveNodeSlot();

	// edit
	void SetAlienTextSlot();
	void AddNewPlayerAnswerSlot();
	void RemovePlayerAnswerSlot();
	void SetPlayerAnswerTextSlot();

	void answerUpSlot();
	void answerDownSlot();

	// test
	void hideNotAllowedAnswersSlot();
	void evaluateAnswerSlot();

	// about
    void about();

private:
	QString strXML;

    DialogEditor *e;
    QToolBar *fileTools;
	QToolBar *nodeTools;
	QToolBar *editTools;
	QToolBar *testTools;
	QToolBar *helpTools;

    QString filename;
};


#endif
