#include <allegro.h>
#include <stdlib.h>
#include "data1.h"
#include "data2.h"

///////////////////////////////////////////////////////////////////////////////

#define TILE_SIZE 75
#define FACE_SIZE 29
#define HOUSE_SIZE 50

#define NUM_SELECT 4
#define SEL_NEWGAME 0
#define SEL_HOWTOPLAY 1
#define SEL_HISCORE 2
#define SEL_EXIT 3

#define NO_PIPE 0
#define TYPE_STRAIGHT 1
#define TYPE_BEND 2
#define TYPE_CROSS 3

#define MODE_LR 0
#define MODE_UD 1

#define MODE_LU 0
#define MODE_RU 1
#define MODE_RD 2
#define MODE_LD 3

#define DO_ROTATE 0
#define DO_CHANGETYPE 1

#define SKYCOL makecol(204, 255, 255)
#define GREENCOL makecol(0, 255, 0)
#define BLUECOL makecol (0, 150, 255)
#define REDCOL makecol(255, 50, 50)
#define YELLOWCOL makecol(255, 255, 0)
#define BLACKCOL makecol(0, 0, 0)
#define WHITECOL makecol(255, 255, 255)
#define GREYCOL makecol(150, 150, 150)
#define BACKCOL makecol(255, 255, 204)

#define BORDER_L TILE_SIZE
#define BORDER_R BORDER_L+TILE_SIZE*6-1
#define BORDER_U TILE_SIZE
#define BORDER_D TILE_SIZE*7-1

#define DIR_LEFT -1
#define DIR_RIGHT 1
#define DIR_UP -2
#define DIR_DOWN 2

#define TIME_PER_TICK 20
#define MOVE_SPEED 2

#define FALL_TICKS 1000/TIME_PER_TICK
#define CRASH_TICKS 1350/TIME_PER_TICK

#define VOL 255
#define PAN 127
#define FREQ 1000

#define NUM_HIBYE 6
///////////////////////////////////////////////////////////////////////////////

DATAFILE *data;
PACKFILE *score_pack;

FONT *game_font;
FONT *game_font_48;
FONT *info_font;

BITMAP *buffer;
BITMAP *logo_small;
BITMAP *logo_big;
BITMAP *info_bg;
BITMAP *heart;
BITMAP *arrow;
BITMAP *pipe_none;
BITMAP *pipe_straight_UD;
BITMAP *pipe_straight_LR;
BITMAP *pipe_bend_LU;
BITMAP *pipe_bend_LD;
BITMAP *pipe_bend_RU;
BITMAP *pipe_bend_RD;
BITMAP *pipe_cross;
BITMAP *face[5];
BITMAP *mouth[4];
BITMAP *eye[3];
BITMAP *house_bmp;
BITMAP *crash_bmp;
BITMAP *cloud_bmp[4];
BITMAP *my_cursor;
BITMAP *my_mouse_sprite;
BITMAP *cur_pipe;

SAMPLE *crash_sound;
SAMPLE *fall_sound;
SAMPLE *honk_sound;
SAMPLE *pipe_io_sound;
SAMPLE *place_pipe_sound;
SAMPLE *tick_sound; 
SAMPLE *sweep_sound;
SAMPLE *select_sound;
SAMPLE *lvlup_sound;
SAMPLE *boo_sound;
SAMPLE *cheer_sound;
SAMPLE *hi_sound[NUM_HIBYE];
SAMPLE *bye_sound[NUM_HIBYE];
int ticks_per_move;
int level;
int score;
int life;
int heads_in_play;


volatile int ticks;
int head_wait_time;
int move_countdown;
int heads_completed;


int num_coords_remaining;
int n;
int game_over;


typedef struct {
    char name[20];
    int score;
}    HISCORE_t;

HISCORE_t hiscore[10];


typedef struct {
    int x, y, z;
// z is used as a referral index for head start positions, 
//  and also a used indicator for start_end_remaining.
} coord_t;

coord_t start_end_remaining[24] ;

typedef struct {
    int type, mode;
} pipe_t;

pipe_t field_pipes[6][6];
pipe_t cur_pipe_icon;


struct HEAD_t_t {
    coord_t cur_location, target_location;
    int dir_old, dir_new;
    int wait_ticks_remaining, cornering_mode;
    int tiles_traveled;
    int sound_scheme;
    int done_this_pipe[6][6];
    BITMAP *head_bmp, *house_bmp;
    struct HEAD_t_t *next_head;
};
typedef struct HEAD_t_t HEAD_t;

HEAD_t *first_head_waiting;
HEAD_t *last_head_waiting;
HEAD_t *first_head_traveling;


struct DIRTY_RECTANGLE_t_t {
    int x, y;
    BITMAP *clean_bmp;
    struct DIRTY_RECTANGLE_t_t *next;
};
typedef struct DIRTY_RECTANGLE_t_t DIRTY_RECTANGLE_t;

DIRTY_RECTANGLE_t *first_DR;


struct FALL_CRASH_t_t {
    int x, y, ticks_remaining;
    struct FALL_CRASH_t_t *next;
};
typedef struct FALL_CRASH_t_t FALL_CRASH_t;

FALL_CRASH_t *first_falling;
FALL_CRASH_t *first_colliding;

///////////////////////////////////////////////////////////////////////////////

// fall_crash.c
void draw_falling();
void draw_crash();
void add_new_falling(HEAD_t*);
void add_new_crashing(HEAD_t*, HEAD_t*);

// gameplay.c
void check_out_of_field();
void remove_head(HEAD_t*, HEAD_t**);
void check_head_collision(HEAD_t*, HEAD_t**, HEAD_t*);
int heads_colliding(HEAD_t*, HEAD_t*);

// head_movement.c
void move_all_heads();
void move_head(HEAD_t*);
int get_next_dir(HEAD_t*, HEAD_t**, pipe_t);
void redraw_pipes(HEAD_t*);

// main.c
void add_tick();
void setup();
void new_game();
void update_mouse_sprite();
void draw_mouse_sprite();
void getinput();
void game_loop();
void main(void);

// menu.c
int menu();
void setup_splash();
void bounce_arrow(int);
void redraw_text(int);

// misc.c
void undirty_buffer();
void update_wait_times();
void clear_whole_list(HEAD_t*);
void clear_whole_list2(FALL_CRASH_t*);
void randomize_elements(BITMAP**, int);
int get_x_coord(int);
int get_y_coord(int);
int get_inv_x_coord(int);
int get_inv_y_coord(int);
void draw_level();
void draw_score();
void draw_life();
void update_score(int);
void check_level();

// new_head.c
void new_head_controller();
void suck_in_head();
void create_new_head();
void set_start_end(HEAD_t*);

// other_screens.c
void lose_game();
void new_hiscore();
void display_hiscore();
void display_howtoplay();
void blinking_ESC();

// pipe.c
void change_pipe(int);
BITMAP *translate_mode_type(pipe_t);
void place_pipe();
int any_heads_here(int, int);


