///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void change_pipe(int);
//  BITMAP *translate_mode_type();
//  void place_pipe();
//  int any_heads_here(int, int);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void change_pipe(int action)  {
    if (action == DO_ROTATE)    {
        if (cur_pipe_icon.type == TYPE_STRAIGHT)    {
            cur_pipe_icon.mode = !cur_pipe_icon.mode;
        } else if (cur_pipe_icon.type == TYPE_BEND)    {
        cur_pipe_icon.mode = (cur_pipe_icon.mode + 1) % 4;
        }
    } else {
        cur_pipe_icon.mode = 0;
        cur_pipe_icon.type = (cur_pipe_icon.type + 1) % 4;
    }

    cur_pipe = translate_mode_type(cur_pipe_icon);

    update_mouse_sprite();
}


///////////////////////////////////////////////////////////////////////////////

BITMAP *translate_mode_type(pipe_t pipe_in)   {
    switch (pipe_in.type)  {
        case NO_PIPE:
            return pipe_none;
        case TYPE_STRAIGHT:
            switch (pipe_in.mode)   {
                case MODE_LR:
                    return pipe_straight_LR;
                case MODE_UD:
                    return pipe_straight_UD;
            }
        case TYPE_BEND:
            switch (pipe_in.mode)    {
                case MODE_RD:
                    return pipe_bend_RD;
                case MODE_LU:
                    return pipe_bend_LU;
                case MODE_LD:
                    return pipe_bend_LD;
                case MODE_RU:
                    return pipe_bend_RU;
            }
        case TYPE_CROSS:
            return pipe_cross;
    }
}


///////////////////////////////////////////////////////////////////////////////

void place_pipe()   {
    int x_coord, y_coord, x, y;

    if (mouse_x>BORDER_R || mouse_x<BORDER_L || mouse_y>BORDER_D || mouse_y<BORDER_U)
        return;
        
    x_coord = get_x_coord(mouse_x);
    y_coord = get_y_coord(mouse_y);
    if (!any_heads_here(x_coord, y_coord))    {
        play_sample(place_pipe_sound, VOL, PAN, FREQ, 0);
        x = get_inv_x_coord(x_coord);
        y = get_inv_y_coord(y_coord);
    
        rectfill(buffer, x, y, x+TILE_SIZE-1, y+TILE_SIZE-1, SKYCOL);
        draw_sprite(buffer, cur_pipe, x, y);
    
        field_pipes[x_coord][y_coord].type = cur_pipe_icon.type;
        field_pipes[x_coord][y_coord].mode = cur_pipe_icon.mode;
    }
}


///////////////////////////////////////////////////////////////////////////////

int any_heads_here(int x_coord, int y_coord)   {
    HEAD_t *cur_head = first_head_traveling;
    while (cur_head != NULL)    {
        if ((((get_x_coord(cur_head->cur_location.x-FACE_SIZE/2-MOVE_SPEED) == x_coord) || 
            (get_x_coord(cur_head->cur_location.x+FACE_SIZE/2+MOVE_SPEED) == x_coord)) && 
            (get_y_coord(cur_head->cur_location.y) == y_coord)) || 
            ((get_x_coord(cur_head->cur_location.x) == x_coord) &&
            ((get_y_coord(cur_head->cur_location.y-FACE_SIZE/2-MOVE_SPEED) == y_coord) || 
            (get_y_coord(cur_head->cur_location.y+FACE_SIZE/2+MOVE_SPEED) == y_coord))))  {
            return 1;
        }    
    cur_head = cur_head->next_head;
    }
    return 0;
}
