///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void new_head_controller();
//  void suck_in_head();
//  void create_new_head();
//  void set_start_end(HEAD_t*);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void new_head_controller()  {
    static int new_head_timer;
    int new_head_countdown;
    
    if (level < 5)
        return;
    if (level == 5)    {
        new_head_timer = 0;
        return;
    }
    
    switch (level)  {
        case 6:
            new_head_countdown = 20;
            break;
        case 7:
            new_head_countdown = 19;
            break;
        case 8:
            new_head_countdown = 18;
            break;
        case 9:
            new_head_countdown = 17;
            break;
        case 10:
            new_head_countdown = 16;
            break;            
        case 11:
        case 12:
        case 13:
        case 14:
            new_head_countdown = 15;
            break;            
        case 15:
            new_head_countdown = 14;
            break;            
        case 16:
            new_head_countdown = 13;
            break;                    
        case 17:
            new_head_countdown = 12;
            break;                    
        case 18:
            new_head_countdown = 11;
            break;                
        default:
            new_head_countdown = 10;
            break;                
    }
    
    if (new_head_timer == 0)    {
        create_new_head();
        new_head_timer = new_head_countdown;
    } else {
        new_head_timer--;
    }
}


///////////////////////////////////////////////////////////////////////////////

void suck_in_head() {
    HEAD_t *temp_ptr;
    heads_in_play++;

    first_head_waiting->wait_ticks_remaining = 0;

    if (first_head_waiting->cur_location.y < BORDER_D) {
        textprintf_centre_ex(buffer, font, first_head_waiting->cur_location.x-
            first_head_waiting->dir_new, first_head_waiting->cur_location.y-FACE_SIZE*7/8, 
            BLACKCOL, BACKCOL, "   ");
    } else {
        textprintf_centre_ex(buffer, font, first_head_waiting->cur_location.x, 
            first_head_waiting->cur_location.y+FACE_SIZE*3/4, BLACKCOL, BACKCOL, "   ");
    }
    
    temp_ptr = first_head_waiting->next_head;
    first_head_waiting->next_head = first_head_traveling;
    first_head_traveling = first_head_waiting;
    first_head_waiting = temp_ptr;
    
    if (first_head_waiting == NULL)
        create_new_head();
    
            
}


///////////////////////////////////////////////////////////////////////////////

void create_new_head()    {
    int i;
    static int facenum = 0, mouthnum = 0, eyenum = 0;

    HEAD_t *new_head;
    new_head = malloc(sizeof(HEAD_t));
    
    new_head->house_bmp = create_bitmap(HOUSE_SIZE, HOUSE_SIZE);
    new_head->head_bmp = create_bitmap(FACE_SIZE, FACE_SIZE);
    
    blit(face[facenum], new_head->head_bmp, 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);
    draw_sprite(new_head->head_bmp, mouth[mouthnum], 0, 0);
    draw_sprite(new_head->head_bmp, eye[eyenum], 0, 0);

    blit(house_bmp, new_head->house_bmp, 0, 0, 0, 0, HOUSE_SIZE, HOUSE_SIZE);
    draw_sprite(new_head->house_bmp, new_head->head_bmp,new_head->house_bmp->w/2-FACE_SIZE/2, 
        new_head->house_bmp->h*2/3-FACE_SIZE/2);
    floodfill(new_head->house_bmp, HOUSE_SIZE/2, FACE_SIZE/3, getpixel(face[facenum], 
        FACE_SIZE/2, FACE_SIZE/2));

    facenum = (facenum + 1) % 5;
    mouthnum = (mouthnum + 1) % 4;
    eyenum = (eyenum + 1) % 3;
    
    new_head->tiles_traveled = 0;
    new_head->cornering_mode = 0;
    new_head->wait_ticks_remaining = head_wait_time;
    new_head->next_head = NULL;
    new_head->sound_scheme = rand()%6;
    
    for(n=0; n<6; n++)    {
        for(i=0; i<6; i++)    {
            new_head->done_this_pipe[n][i] = 0;
        }
    }
    
    set_start_end(new_head);
    
    if (first_head_waiting == NULL)    {
        first_head_waiting = new_head;
    } else {
        last_head_waiting->next_head = new_head;
    }
    last_head_waiting = new_head;
    

    draw_sprite(buffer, new_head->head_bmp, new_head->cur_location.x-FACE_SIZE/2, 
        new_head->cur_location.y-FACE_SIZE/2);
    draw_sprite(buffer, new_head->house_bmp, new_head->target_location.x-HOUSE_SIZE/2, 
        new_head->target_location.y-HOUSE_SIZE/2);    
    if (new_head->cur_location.y < BORDER_D) {
        textprintf_centre_ex(buffer, font, new_head->cur_location.x-new_head->dir_new, 
            new_head->cur_location.y-FACE_SIZE*7/8, BLACKCOL, BACKCOL, " %d ", 
            new_head->wait_ticks_remaining*TIME_PER_TICK/1000);
    } else {
        textprintf_centre_ex(buffer, font, new_head->cur_location.x, 
            new_head->cur_location.y+FACE_SIZE*3/4, BLACKCOL, BACKCOL, " %d ", 
            new_head->wait_ticks_remaining*TIME_PER_TICK/1000);
    }
    play_sample(hi_sound[new_head->sound_scheme], VOL, PAN, FREQ, 0);
}


///////////////////////////////////////////////////////////////////////////////

void set_start_end(HEAD_t *new_head)    {
    int randnum;
    
    randnum = rand() % num_coords_remaining+1;
    n = -1;
    while (randnum)    {
            n++;
        if (!start_end_remaining[n].z)    {
            randnum--;
        }
    }
    num_coords_remaining--;

    if (start_end_remaining[n].x == BORDER_L)    {
        new_head->cur_location.x = start_end_remaining[n].x - FACE_SIZE - 2*MOVE_SPEED;
        new_head->cur_location.y = start_end_remaining[n].y;
        new_head->dir_old = new_head->dir_new = DIR_RIGHT;
    } else if (start_end_remaining[n].x == BORDER_R)    {
        new_head->cur_location.x = start_end_remaining[n].x + FACE_SIZE + 2*MOVE_SPEED;
        new_head->cur_location.y = start_end_remaining[n].y;
        new_head->dir_old = new_head->dir_new = DIR_LEFT;
    } else if (start_end_remaining[n].y == BORDER_U)    {
        new_head->cur_location.x = start_end_remaining[n].x;
        new_head->cur_location.y = start_end_remaining[n].y - FACE_SIZE - 2*MOVE_SPEED;
        new_head->dir_old = new_head->dir_new = DIR_DOWN;
    } else if (start_end_remaining[n].y == BORDER_D)    {    
        new_head->cur_location.x = start_end_remaining[n].x;
        new_head->cur_location.y = start_end_remaining[n].y + FACE_SIZE + 2*MOVE_SPEED;
        new_head->dir_old = new_head->dir_new = DIR_UP;
    }
    start_end_remaining[n].z = 1;
    new_head->cur_location.z = n;


    randnum = rand() % num_coords_remaining+1;
    n = -1;
    while (randnum)    {
            n++;
        if (!start_end_remaining[n].z)    {
            randnum--;
        }
    }
    num_coords_remaining--;

    if (start_end_remaining[n].x == BORDER_L)    {
        new_head->target_location.x = start_end_remaining[n].x-HOUSE_SIZE/2-FACE_SIZE/2-MOVE_SPEED;
        new_head->target_location.y = start_end_remaining[n].y;
    } else if (start_end_remaining[n].x == BORDER_R)    {
        new_head->target_location.x = start_end_remaining[n].x+HOUSE_SIZE/2+FACE_SIZE/2+MOVE_SPEED;
        new_head->target_location.y = start_end_remaining[n].y;
    } else if (start_end_remaining[n].y == BORDER_U)    {
        new_head->target_location.x = start_end_remaining[n].x;
        new_head->target_location.y = start_end_remaining[n].y-HOUSE_SIZE/2-FACE_SIZE/2-MOVE_SPEED;
    } else if (start_end_remaining[n].y == BORDER_D)    {    
        new_head->target_location.x = start_end_remaining[n].x;
        new_head->target_location.y = start_end_remaining[n].y+HOUSE_SIZE/2+FACE_SIZE/2+MOVE_SPEED;
    }
    start_end_remaining[n].z = 1;
    new_head->target_location.z = n;

}


