///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void lose_game();
//  void new_hiscore();
//  void display_hiscore();
//  void display_howtoplay();
//  void blinking_ESC();
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void lose_game()    {
    game_over = 1;
    undirty_buffer();
    clear_whole_list(first_head_waiting);
    clear_whole_list(first_head_traveling);
    clear_whole_list2(first_falling);
    clear_whole_list2(first_colliding);

    if (score >= hiscore[9].score)    {
        play_sample(cheer_sound, VOL, PAN, FREQ, 0);
        new_hiscore();
        display_hiscore();
    } else {        
        play_sample(boo_sound, VOL, PAN, FREQ, 0);
        rectfill(buffer, 130, 200, 650,  270, makecol(0,0,255));
        rect(buffer, 130, 200, 650,  270, makecol(255,255,255));
        rect(buffer, 129, 199, 651,  271, makecol(255,255,255));
        rect(buffer, 128, 198, 652,  272, makecol(255,255,255));

        textprintf_centre_ex(buffer, info_font, 400, 205, makecol(0, 0, 0), makecol(0, 0, 255), "Sorry, game over!");
        textprintf_centre_ex(buffer, info_font, 390, 235, makecol(0, 0, 0), makecol(0, 0, 255), "Press ESC to return to the main menu.");
        blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
    }
}


///////////////////////////////////////////////////////////////////////////////

void new_hiscore()  {
    char new_name[20] = "                   ";
    int next_char, key_pressed, mid_pivot, left_pivot, right_pivot;
    
    next_char = 0;
    key_pressed = 0;
    mid_pivot = 4;
    left_pivot = 0;
    right_pivot = 9;

    rectfill(screen, 125, 200, 675, 360, makecol(0,0,255));
    rect(screen, 125, 200, 675, 360, makecol(255,255,255));
    rect(screen, 124, 199, 676, 361, makecol(255,255,255));
    rect(screen, 123, 198, 677, 362, makecol(255,255,255));  

    textprintf_centre_ex(screen, info_font, 400, 220, makecol(0, 0, 0), -1, "You have reached a new high score!");
    textprintf_centre_ex(screen, info_font, 400, 250, makecol(0, 0, 0), -1, "Type your name below (max 19 characters):");
    textprintf_centre_ex(screen, info_font, 400, 280, makecol(0, 0, 0), -1, "Press ENTER when done");

    clear_keybuf();
    while ((key_pressed >> 8) != KEY_ENTER)    {
        if (((key_pressed >> 8) == KEY_BACKSPACE) && next_char)    {
            new_name[--next_char] = ' ';
        } else if ((key_pressed >> 8) == KEY_ESC)        {
        } else if ((next_char < 19) && ((key_pressed & 0xff) >= 32) && ((key_pressed & 0xff) <= 126)) {
            new_name[next_char++] = (key_pressed & 0xff);
        }
        rectfill(screen, 200, 315, 600, 345, makecol(0,0,255));
        textprintf_ex(screen, info_font, 300, 315, makecol(255, 255, 255), makecol(0, 0, 255), "%s", new_name);
        key_pressed = readkey();
    }
    
    for (n=next_char; n<19; n++)        {
        new_name[n] = ' ';
    }
    
    while (left_pivot != right_pivot)        {
        mid_pivot = (left_pivot+right_pivot)/2;
        if (score < hiscore[mid_pivot].score)    {
            left_pivot = mid_pivot+1;
        } else if (score >= hiscore[mid_pivot].score)    {
            right_pivot = mid_pivot;
        }
    }
    
    for (n=9;n>left_pivot;n--)    {
        hiscore[n].score = hiscore[n-1].score;
        strcpy(hiscore[n].name, hiscore[n-1].name);
    }
        hiscore[left_pivot].score = score;
        strcpy(hiscore[left_pivot].name, new_name);  
}


///////////////////////////////////////////////////////////////////////////////

void display_hiscore()    {
    clear_to_color(buffer, SKYCOL);

    textprintf_centre_ex(buffer, game_font_48, 400, 50, WHITECOL, -1, "Transit Mania: high scores");
    textprintf_centre_ex(buffer, game_font_48, 402, 52, BLACKCOL, -1, "Transit Mania: high scores");


    rectfill(buffer, 151, 121, 651, 166, WHITECOL);
    rectfill(buffer, 151, 168, 651, 476, BLUECOL);    
    rect(buffer, 151, 121, 651, 476, GREYCOL);
    rect(buffer, 150, 120, 650, 475, WHITECOL);
    hline(buffer, 151, 166, 649, GREYCOL);
    hline(buffer, 151, 167, 649, WHITECOL);
    vline(buffer, 255, 122, 474, WHITECOL);
    vline(buffer, 256, 122, 474, GREYCOL);
    vline(buffer, 525, 122, 474, WHITECOL);
    vline(buffer, 526, 122, 474, GREYCOL);

    textprintf_centre_ex(buffer, game_font, 202, 132, BLACKCOL, -1, "Rank:");
    textprintf_ex(buffer, game_font, 312, 132, BLACKCOL, -1, "Name:");
    textprintf_centre_ex(buffer, game_font, 592, 132, BLACKCOL, -1, "Profit:");
    textprintf_centre_ex(buffer, game_font, 202, 130, BLUECOL, -1, "Rank:");
    textprintf_ex(buffer, game_font, 310, 130, BLUECOL, -1, "Name:");
    textprintf_centre_ex(buffer, game_font, 590, 130, BLUECOL, -1, "Profit:");


    for (n=0; n<10; n++)    {
        textprintf_centre_ex(buffer, info_font, 200, 170+30*n, BLACKCOL, -1, "%d", n+1);
        textprintf_ex(buffer, info_font, 280, 170+30*n, BLACKCOL, -1, "%s", hiscore[n].name);
        textprintf_centre_ex(buffer, info_font, 590, 170+30*n, BLACKCOL, -1, "$%d", hiscore[n].score);
    }

    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);

    blinking_ESC();

}


///////////////////////////////////////////////////////////////////////////////

void display_howtoplay()    {
    clear_to_color(screen, SKYCOL);

    textprintf_centre_ex(screen, game_font_48, 400, 10, BLACKCOL, -1, "Transit Mania: how to play");
    textprintf_centre_ex(screen, game_font_48, 402, 12, BLUECOL, -1, "Transit Mania: how to play");

    textprintf_ex(screen, info_font, 50, 70, BLACKCOL, -1, "Objective: To get as many points as possible by moving");
    textprintf_ex(screen, info_font, 50, 100, BLACKCOL, -1, "   passengers to their destination via suction pipes.");
    textprintf_ex(screen, info_font, 50, 160, BLACKCOL, -1, "Keys:");
    textprintf_ex(screen, info_font, 50, 190, BLACKCOL, -1, "->>In menu:");
    textprintf_ex(screen, info_font, 50, 220, BLACKCOL, -1, "Use the mouse and L-CLICK to select, or use these keys:");
    textprintf_ex(screen, info_font, 50, 250, BLACKCOL, -1, "UP/DOWN - move current selection up or down.");
    textprintf_ex(screen, info_font, 50, 280, BLACKCOL, -1, "ENTER/SPACEBAR - select current selection.");
    textprintf_ex(screen, info_font, 50, 310, BLACKCOL, -1, "->>During play:");
    textprintf_ex(screen, info_font, 50, 340, BLACKCOL, -1, "L-CLICK - place the currently selected pipe.");
    textprintf_ex(screen, info_font, 50, 370, BLACKCOL, -1, "R-CLICK/SHIFT - accept the next passenger in queue.");
    textprintf_ex(screen, info_font, 50, 400, BLACKCOL, -1, "MID-CLICK/CTRL - change to the next pipe type.");
    textprintf_ex(screen, info_font, 50, 430, BLACKCOL, -1, "Mouse wheel/ALT - rotate current pipe type.");
    textprintf_ex(screen, info_font, 50, 460, BLACKCOL, -1, "F1 - pause the game & open the How To Play page.");
    textprintf_ex(screen, info_font, 50, 490, BLACKCOL, -1, "F2 - toggle sound on/off.");
    textprintf_ex(screen, info_font, 50, 520, BLACKCOL, -1, "F9 - ends current game.");


    blinking_ESC();
}


///////////////////////////////////////////////////////////////////////////////

void blinking_ESC() {
    int dir = 1;
    n = 255;

    while (!key[KEY_ESC] && !(mouse_b&2))    {
        if (n == 255)
            dir = -1;
        if (n == 5)
            dir = 1;
        
        n = (n + dir*25);
        if (game_over)        {
            textprintf_centre_ex(screen, info_font, 400, 565, makecol(n, n, n), -1, "Press ESC or R-CLICK to return to the main menu.");    
        } else {
            textprintf_centre_ex(screen, info_font, 400, 565, makecol(n, n, n), -1, "Press ESC or R-CLICK to return to the game.");    
        }
        rest(50);
    }
}
