///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void move_all_heads();
//  void move_head(HEAD_t*);
//  int get_next_dir(HEAD_t*, HEAD_t*, pipe_t);
//  redraw_pipes(HEAD_t*);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void move_all_heads()    {
    int old_x_coord, old_y_coord, new_x_coord, new_y_coord;
    
    HEAD_t *cur_head;
    HEAD_t *prev_head = NULL;
    
    cur_head = first_head_traveling;
    while (cur_head != NULL)    {

        old_x_coord = get_x_coord(cur_head->cur_location.x);
        old_y_coord = get_y_coord(cur_head->cur_location.y);
    
        move_head(cur_head);
        redraw_pipes(cur_head);


        new_x_coord = get_x_coord(cur_head->cur_location.x);
        new_y_coord = get_y_coord(cur_head->cur_location.y);
    
        if (((old_x_coord != new_x_coord) || (old_y_coord != new_y_coord)))  {
            cur_head->dir_old = cur_head->dir_new;
    
            if ((new_x_coord<=5) && (new_x_coord>=0) && (new_y_coord<=5) && (new_y_coord>=0))    {
                if (!cur_head->done_this_pipe[new_x_coord][new_y_coord] && (field_pipes[new_x_coord][new_y_coord].type != TYPE_CROSS))   {
                    cur_head->done_this_pipe[new_x_coord][new_y_coord] = 1;
                    cur_head->tiles_traveled++;
                }
                cur_head->cornering_mode = 0;
                cur_head->dir_new = get_next_dir(prev_head, &cur_head, field_pipes[new_x_coord][new_y_coord]);
            }
        }
        
        if ((cur_head == NULL) && (prev_head == NULL))    {
            cur_head = first_head_traveling;
        } else {
            prev_head = cur_head;
            cur_head = cur_head->next_head;
        }
    }

    cur_head = first_head_traveling;
    prev_head = NULL;
    while (cur_head != NULL)    {    
        if ((cur_head != NULL) && (cur_head->next_head != NULL)) {
            check_head_collision(prev_head, &cur_head, cur_head);
        }
        if ((cur_head == NULL) && (prev_head == NULL))    {
            cur_head = first_head_traveling;
        } else {
            prev_head = cur_head;
            cur_head = cur_head->next_head;
        }
    }

    check_out_of_field();

    drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
    set_multiply_blender(200, 200, 200, 255);

    cur_head = first_head_traveling;
    while (cur_head != NULL)    {   
        if ((cur_head->cur_location.x == BORDER_L) || (cur_head->cur_location.x == BORDER_L+1) ||
            (cur_head->cur_location.x == BORDER_R) || (cur_head->cur_location.x == BORDER_R-1) ||
            (cur_head->cur_location.y == BORDER_U) || (cur_head->cur_location.y == BORDER_U+1) ||
            (cur_head->cur_location.y == BORDER_D) || (cur_head->cur_location.y == BORDER_D-1))    {
            play_sample(pipe_io_sound, VOL, PAN, FREQ, 0);        
        }
        draw_trans_sprite(buffer, cur_head->head_bmp, cur_head->cur_location.x-FACE_SIZE/2, 
            cur_head->cur_location.y-FACE_SIZE/2);
        cur_head = cur_head->next_head;
    }
    solid_mode();
    
    
}


///////////////////////////////////////////////////////////////////////////////

void move_head(HEAD_t *cur_head)    {
    if (cur_head->dir_old == cur_head->dir_new)    {
        cur_head->cur_location.x += (cur_head->dir_new%2)*MOVE_SPEED;
        cur_head->cur_location.y += (cur_head->dir_new/2)*MOVE_SPEED;

    } else {
        switch (cur_head->cornering_mode)    {
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
            case 9:
            case 10:
                cur_head->cur_location.x += (cur_head->dir_old%2)*MOVE_SPEED;
                cur_head->cur_location.y += (cur_head->dir_old/2)*MOVE_SPEED;                 
                break;
            case 11:
            case 12:
            case 13:
            case 14:
                cur_head->cur_location.x += (cur_head->dir_old%2)*MOVE_SPEED+MOVE_SPEED/2*
                    (cur_head->dir_new%2);
                cur_head->cur_location.y += (cur_head->dir_old/2)*MOVE_SPEED+MOVE_SPEED/2*
                    (cur_head->dir_new/2);
                break;
            case 15:
            case 16:
                cur_head->cur_location.x += (cur_head->dir_old%2)*MOVE_SPEED+
                    (cur_head->dir_new%2)*MOVE_SPEED;
                cur_head->cur_location.y += (cur_head->dir_old/2)*MOVE_SPEED+
                    (cur_head->dir_new/2)*MOVE_SPEED;
                break;
            case 17:
            case 18:
            case 20:
                cur_head->cur_location.x += (cur_head->dir_new%2)*MOVE_SPEED+MOVE_SPEED/2*
                    (cur_head->dir_old%2);
                cur_head->cur_location.y += (cur_head->dir_new/2)*MOVE_SPEED+MOVE_SPEED/2*
                    (cur_head->dir_old/2);
            case 19:
            case 21:
            case 22:
            case 23:
            case 24:
            case 25:
            case 26:
            case 27:
            case 28:
            case 29:
            case 30:
            case 31:
                cur_head->cur_location.x += (cur_head->dir_new%2)*MOVE_SPEED;
                cur_head->cur_location.y += (cur_head->dir_new/2)*MOVE_SPEED;
        }
        cur_head->cornering_mode++;
    }
}


///////////////////////////////////////////////////////////////////////////////

int get_next_dir(HEAD_t *prev_head, HEAD_t **cur_head, pipe_t new_pipe) {

    switch (new_pipe.type)  {
        case NO_PIPE: 
        if (((*cur_head)->cur_location.x != BORDER_L) && ((*cur_head)->cur_location.x != BORDER_L+1) &&
            ((*cur_head)->cur_location.x != BORDER_R) && ((*cur_head)->cur_location.x != BORDER_R-1) &&
            ((*cur_head)->cur_location.y != BORDER_U) && ((*cur_head)->cur_location.y != BORDER_U+1) &&
            ((*cur_head)->cur_location.y != BORDER_D) && ((*cur_head)->cur_location.y != BORDER_D-1))    {
            play_sample(pipe_io_sound, VOL, PAN, FREQ, 0);        
        }

            life--;
            draw_life();
            add_new_falling(*cur_head);
            remove_head(prev_head, cur_head);
            break;
        
        case TYPE_STRAIGHT:
            switch (new_pipe.mode)  {
                case MODE_LR:
                    if (((*cur_head)->dir_old == DIR_LEFT) || ((*cur_head)->dir_old == DIR_RIGHT))  {
                        return (*cur_head)->dir_old;
                    } else {
                        if (((*cur_head)->cur_location.x != BORDER_L) && ((*cur_head)->cur_location.x != BORDER_L+1) &&
                            ((*cur_head)->cur_location.x != BORDER_R) && ((*cur_head)->cur_location.x != BORDER_R-1) &&
                            ((*cur_head)->cur_location.y != BORDER_U) && ((*cur_head)->cur_location.y != BORDER_U+1) &&
                            ((*cur_head)->cur_location.y != BORDER_D) && ((*cur_head)->cur_location.y != BORDER_D-1))    {
                            play_sample(pipe_io_sound, VOL, PAN, FREQ, 0);        
                        }
                        life--;
                        draw_life();
                        add_new_falling(*cur_head);
                        remove_head(prev_head, cur_head);
                    }
                    break;
                
                case MODE_UD:
                    if (((*cur_head)->dir_old == DIR_UP) || ((*cur_head)->dir_old == DIR_DOWN))  {
                        return (*cur_head)->dir_old;
                    } else {
                        if (((*cur_head)->cur_location.x != BORDER_L) && ((*cur_head)->cur_location.x != BORDER_L+1) &&
                            ((*cur_head)->cur_location.x != BORDER_R) && ((*cur_head)->cur_location.x != BORDER_R-1) &&
                            ((*cur_head)->cur_location.y != BORDER_U) && ((*cur_head)->cur_location.y != BORDER_U+1) &&
                            ((*cur_head)->cur_location.y != BORDER_D) && ((*cur_head)->cur_location.y != BORDER_D-1))    {
                            play_sample(pipe_io_sound, VOL, PAN, FREQ, 0);        
                        }
                        life--;
                        draw_life();
                        add_new_falling(*cur_head);
                        remove_head(prev_head, cur_head);
                    }
                    break;            
            }
            break;
        
        case TYPE_CROSS:
            return (*cur_head)->dir_old;
            break;
            
        case TYPE_BEND:
            switch (new_pipe.mode)  {
                case MODE_LU:
                    if ((*cur_head)->dir_old == DIR_RIGHT)   {
                        return DIR_UP;
                    } else if ((*cur_head)->dir_old == DIR_DOWN)   {
                        return DIR_LEFT;
                    } else {
                        if (((*cur_head)->cur_location.x != BORDER_L) && ((*cur_head)->cur_location.x != BORDER_L+1) &&
                            ((*cur_head)->cur_location.x != BORDER_R) && ((*cur_head)->cur_location.x != BORDER_R-1) &&
                            ((*cur_head)->cur_location.y != BORDER_U) && ((*cur_head)->cur_location.y != BORDER_U+1) &&
                            ((*cur_head)->cur_location.y != BORDER_D) && ((*cur_head)->cur_location.y != BORDER_D-1))    {
                            play_sample(pipe_io_sound, VOL, PAN, FREQ, 0);        
                        }
                        life--;
                        draw_life();
                        add_new_falling(*cur_head);
                        remove_head(prev_head, cur_head);
                    }
                    break;
                    
                    
                case MODE_LD:
                    if ((*cur_head)->dir_old == DIR_RIGHT)   {
                        return DIR_DOWN;
                    } else if ((*cur_head)->dir_old == DIR_UP)   {
                        return DIR_LEFT;
                    } else {
                        if (((*cur_head)->cur_location.x != BORDER_L) && ((*cur_head)->cur_location.x != BORDER_L+1) &&
                            ((*cur_head)->cur_location.x != BORDER_R) && ((*cur_head)->cur_location.x != BORDER_R-1) &&
                            ((*cur_head)->cur_location.y != BORDER_U) && ((*cur_head)->cur_location.y != BORDER_U+1) &&
                            ((*cur_head)->cur_location.y != BORDER_D) && ((*cur_head)->cur_location.y != BORDER_D-1))    {
                            play_sample(pipe_io_sound, VOL, PAN, FREQ, 0);        
                        }
                        life--;
                        draw_life();
                        add_new_falling(*cur_head);
                        remove_head(prev_head, cur_head);
                    }
                    break;

                case MODE_RU:
                    if ((*cur_head)->dir_old == DIR_LEFT)   {
                        return DIR_UP;
                    } else if ((*cur_head)->dir_old == DIR_DOWN)   {
                        return DIR_RIGHT;
                    } else {
                        if (((*cur_head)->cur_location.x != BORDER_L) && ((*cur_head)->cur_location.x != BORDER_L+1) &&
                            ((*cur_head)->cur_location.x != BORDER_R) && ((*cur_head)->cur_location.x != BORDER_R-1) &&
                            ((*cur_head)->cur_location.y != BORDER_U) && ((*cur_head)->cur_location.y != BORDER_U+1) &&
                            ((*cur_head)->cur_location.y != BORDER_D) && ((*cur_head)->cur_location.y != BORDER_D-1))    {
                            play_sample(pipe_io_sound, VOL, PAN, FREQ, 0);        
                        }
                        life--;
                        draw_life();
                        add_new_falling(*cur_head);
                        remove_head(prev_head, cur_head);
                    }
                    break;

                case MODE_RD:
                    if ((*cur_head)->dir_old == DIR_LEFT)   {
                        return DIR_DOWN;
                    } else if ((*cur_head)->dir_old == DIR_UP)   { 
                        return DIR_RIGHT;
                    } else {
                        if (((*cur_head)->cur_location.x != BORDER_L) && ((*cur_head)->cur_location.x != BORDER_L+1) &&
                            ((*cur_head)->cur_location.x != BORDER_R) && ((*cur_head)->cur_location.x != BORDER_R-1) &&
                            ((*cur_head)->cur_location.y != BORDER_U) && ((*cur_head)->cur_location.y != BORDER_U+1) &&
                            ((*cur_head)->cur_location.y != BORDER_D) && ((*cur_head)->cur_location.y != BORDER_D-1))    {
                            play_sample(pipe_io_sound, VOL, PAN, FREQ, 0);        
                        }
                        life--;
                        draw_life();
                        add_new_falling(*cur_head);
                        remove_head(prev_head, cur_head);
                    }
                    break;                
            }
    }
}


///////////////////////////////////////////////////////////////////////////////

void redraw_pipes(HEAD_t *cur_head)   {
    int x1 = get_inv_x_coord(get_x_coord(cur_head->cur_location.x));
    int y1 = get_inv_y_coord(get_y_coord(cur_head->cur_location.y));
    int x2 = x1+TILE_SIZE-1;
    int y2 = y1+TILE_SIZE-1;
    int x_coord = get_x_coord(x1);
    int y_coord = get_y_coord(y1);
    int x1_rect, x2_rect, y1_rect, y2_rect;
    
    // redrawing pipes & clearing heads at the head locations as they move        
    if (x_coord>=0 && y_coord>=0 && x_coord<= 5 && y_coord <=5)    {

        if (cur_head->cur_location.x-FACE_SIZE/2-MOVE_SPEED < BORDER_L)   {
            x1_rect = BORDER_L;
            x2_rect = cur_head->cur_location.x+FACE_SIZE/2+MOVE_SPEED;
        } else if (cur_head->cur_location.x+FACE_SIZE/2 > BORDER_R)  {
            x1_rect = cur_head->cur_location.x-FACE_SIZE/2+MOVE_SPEED;
            x2_rect = BORDER_R;
        } else {
            x1_rect = cur_head->cur_location.x-FACE_SIZE/2;
            x2_rect = cur_head->cur_location.x+FACE_SIZE/2;        
        }

        if (cur_head->cur_location.y-FACE_SIZE/2-MOVE_SPEED < BORDER_U)   {
            y1_rect = BORDER_U;
            y2_rect = cur_head->cur_location.y+FACE_SIZE/2+MOVE_SPEED;
        } else if (cur_head->cur_location.y+FACE_SIZE/2 > BORDER_D)  {
            y1_rect = cur_head->cur_location.y-FACE_SIZE/2+MOVE_SPEED;
            y2_rect = BORDER_D;
        } else {
            y1_rect = cur_head->cur_location.y-FACE_SIZE/2;
            y2_rect = cur_head->cur_location.y+FACE_SIZE/2;        
        }        

        rectfill(buffer, x1_rect, y1_rect, x2_rect, y2_rect, SKYCOL);

        draw_sprite(buffer, translate_mode_type(field_pipes[x_coord][y_coord]), x1, y1);

    } else if (x_coord<0 && cur_head->cur_location.x+FACE_SIZE/2+MOVE_SPEED >= BORDER_L)    {
        rectfill(buffer, BORDER_L, cur_head->cur_location.y-FACE_SIZE/2, cur_head->cur_location.x+FACE_SIZE/2+MOVE_SPEED, cur_head->cur_location.y+FACE_SIZE/2, SKYCOL);    
    } else if (x_coord>5 && cur_head->cur_location.x-FACE_SIZE/2-MOVE_SPEED <= BORDER_R)    {
        rectfill(buffer, cur_head->cur_location.x-FACE_SIZE/2-MOVE_SPEED, cur_head->cur_location.y-FACE_SIZE/2, BORDER_R, cur_head->cur_location.y+FACE_SIZE/2, SKYCOL);    
    } else if (y_coord<0 && cur_head->cur_location.y+FACE_SIZE/2+MOVE_SPEED >= BORDER_U)    {
        rectfill(buffer, cur_head->cur_location.x-FACE_SIZE/2, BORDER_U, cur_head->cur_location.x+FACE_SIZE/2, cur_head->cur_location.y+FACE_SIZE/2+MOVE_SPEED, SKYCOL);    
    } else if (y_coord>5 && cur_head->cur_location.y-FACE_SIZE/2-MOVE_SPEED <= BORDER_D)    {
        rectfill(buffer, cur_head->cur_location.x-FACE_SIZE/2, cur_head->cur_location.y-FACE_SIZE/2-MOVE_SPEED, cur_head->cur_location.x+FACE_SIZE/2, BORDER_D, SKYCOL);    
    }
    
    if ((cur_head->cur_location.x-FACE_SIZE/2-MOVE_SPEED < x1) && (cur_head->cur_location.x-
        FACE_SIZE/2-MOVE_SPEED >= BORDER_L))    {
        draw_sprite(buffer, translate_mode_type(field_pipes[x_coord-1][y_coord]), x1-TILE_SIZE, y1);
    }
    
    if ((cur_head->cur_location.x+FACE_SIZE/2+MOVE_SPEED > x2) && (cur_head->cur_location.x+
        FACE_SIZE/2+MOVE_SPEED <= BORDER_R))    {
        draw_sprite(buffer, translate_mode_type(field_pipes[x_coord+1][y_coord]), x2+1, y1);
    }
    
    if ((cur_head->cur_location.y-FACE_SIZE/2-MOVE_SPEED < y1) && (cur_head->cur_location.y-
        FACE_SIZE/2-MOVE_SPEED >= BORDER_U))    {
        draw_sprite(buffer, translate_mode_type(field_pipes[x_coord][y_coord-1]), x1, y1-TILE_SIZE);
    }
    
    if ((cur_head->cur_location.y+FACE_SIZE/2+MOVE_SPEED > y2) && (cur_head->cur_location.y+
        FACE_SIZE/2+MOVE_SPEED <= BORDER_D))    {
        draw_sprite(buffer, translate_mode_type(field_pipes[x_coord][y_coord+1]), x1, y2+1);
    }

    // clearing heads when they go outside the game field
    if (cur_head->cur_location.x-FACE_SIZE/2-MOVE_SPEED < BORDER_L-3)    {
        rectfill(buffer, cur_head->cur_location.x-FACE_SIZE/2-MOVE_SPEED, 
            cur_head->cur_location.y-FACE_SIZE/2, BORDER_L-4, cur_head->cur_location.y+
            FACE_SIZE/2, BACKCOL);
    }

    if (cur_head->cur_location.x+FACE_SIZE/2+MOVE_SPEED > BORDER_R+3)    {
        rectfill(buffer, BORDER_R+4, cur_head->cur_location.y-FACE_SIZE/2, 
            cur_head->cur_location.x+FACE_SIZE/2+MOVE_SPEED, cur_head->cur_location.y+
            FACE_SIZE/2, BACKCOL); 
    }

    if (cur_head->cur_location.y-FACE_SIZE/2-MOVE_SPEED < BORDER_U-3)    {
        rectfill(buffer, cur_head->cur_location.x-FACE_SIZE/2, 
            cur_head->cur_location.y-FACE_SIZE/2-MOVE_SPEED, cur_head->cur_location.x+FACE_SIZE/2, 
            BORDER_U-4, BACKCOL);   
    }

    if (cur_head->cur_location.y+FACE_SIZE/2+MOVE_SPEED > BORDER_D+3)    {
        rectfill(buffer, cur_head->cur_location.x-FACE_SIZE/2, BORDER_D+4,
            cur_head->cur_location.x+FACE_SIZE/2, 
            cur_head->cur_location.y+FACE_SIZE/2+MOVE_SPEED, BACKCOL);     
    }

}
