///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void undirty_buffer();
//  void update_wait_times();
//  void clear_whole_list(HEAD_t*);
//  void clear_whole_list2(FALL_CRASH_t*);
//  void randomize_elements(BITMAP*, int);
//  int get_x_coord(int);
//  int get_y_coord(int);
//  int get_inv_x_coord(int);
//  int get_inv_y_coord(int);
//  void draw_level():
//  void draw_score();
//  void draw_life();
//  void update_score(int);
//  void check_level();
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void undirty_buffer()   {
    DIRTY_RECTANGLE_t *cur_dirty = first_DR;
    DIRTY_RECTANGLE_t *temp_dirty;
    
    while (cur_dirty != NULL)    {
        temp_dirty = cur_dirty->next;
        blit(cur_dirty->clean_bmp, buffer, 0, 0, cur_dirty->x, cur_dirty->y,
            cur_dirty->clean_bmp->w, cur_dirty->clean_bmp->h);
        destroy_bitmap(cur_dirty->clean_bmp);
        free(cur_dirty);
        cur_dirty = temp_dirty;
    }
    first_DR = NULL;
}


///////////////////////////////////////////////////////////////////////////////

void update_wait_times()    {
    HEAD_t *cur_temp_ptr;
    cur_temp_ptr = first_head_waiting;

    
    while (cur_temp_ptr != NULL)    {
        cur_temp_ptr->wait_ticks_remaining--;
        if (((cur_temp_ptr->wait_ticks_remaining%(1000/TIME_PER_TICK)) == (1000/TIME_PER_TICK-1)) && (cur_temp_ptr->wait_ticks_remaining*TIME_PER_TICK/1000 <= 2))    {
            play_sample(tick_sound, VOL, PAN, FREQ, 0);        
        }

        if (cur_temp_ptr->cur_location.y < BORDER_D) {
            textprintf_centre_ex(buffer, font, cur_temp_ptr->cur_location.x-cur_temp_ptr->dir_new, 
                cur_temp_ptr->cur_location.y-FACE_SIZE*7/8, BLACKCOL, BACKCOL, " %d ", 
                cur_temp_ptr->wait_ticks_remaining*TIME_PER_TICK/1000);
        } else {
            textprintf_centre_ex(buffer, font, cur_temp_ptr->cur_location.x, 
                cur_temp_ptr->cur_location.y+FACE_SIZE*3/4, BLACKCOL, BACKCOL, " %d ", 
                cur_temp_ptr->wait_ticks_remaining*TIME_PER_TICK/1000);
        }
        cur_temp_ptr = cur_temp_ptr->next_head;
    }
    
    if (!first_head_waiting->wait_ticks_remaining)  {
        play_sample(honk_sound, VOL, PAN, FREQ, 0);
        suck_in_head();
    }
}


///////////////////////////////////////////////////////////////////////////////

void clear_whole_list(HEAD_t *head_ptr) {
    if(head_ptr == NULL) {
        return;
    } else {
        clear_whole_list(head_ptr->next_head);
        destroy_bitmap(head_ptr->head_bmp);
        destroy_bitmap(head_ptr->house_bmp);
        free(head_ptr);
    }
}


///////////////////////////////////////////////////////////////////////////////

void clear_whole_list2(FALL_CRASH_t *temp_ptr)    {
    if (temp_ptr == NULL)    {
        return;
    } else {
        clear_whole_list2(temp_ptr->next);
        free(temp_ptr);
    }
}


///////////////////////////////////////////////////////////////////////////////

void randomize_elements(BITMAP **ptr_in, int array_len) {
    BITMAP *temp_ptr;
    int rand1, rand2;
    int i = array_len;
    
    while (i)   {
        rand1 = rand()%array_len;
        rand2 = rand()%array_len;
        temp_ptr = ptr_in[rand1];
        ptr_in[rand1] = ptr_in[rand2];
        ptr_in[rand2] = temp_ptr;
        i--;
    }
}


///////////////////////////////////////////////////////////////////////////////

int get_x_coord(int x_in)   {
    if (x_in < BORDER_L)
        return -1;
    return (x_in - BORDER_L)/TILE_SIZE;
}


///////////////////////////////////////////////////////////////////////////////

int get_y_coord(int y_in)   {
    if (y_in < BORDER_U)
        return -1;
    return (y_in - BORDER_U)/TILE_SIZE;
}


///////////////////////////////////////////////////////////////////////////////

int get_inv_x_coord(int x_in)   {
    return BORDER_L+x_in*TILE_SIZE;
}


///////////////////////////////////////////////////////////////////////////////

int get_inv_y_coord(int y_in)   {
    return BORDER_U+y_in*TILE_SIZE;
}


///////////////////////////////////////////////////////////////////////////////

void draw_level()   {
    draw_sprite(buffer, info_bg, (BORDER_R+screen->w+TILE_SIZE/2)/2-info_bg->w/2, 165);
    textprintf_centre_ex(buffer, game_font, (BORDER_R+screen->w+TILE_SIZE/2)/2+3, 152, GREYCOL, -1, "Level");
    textprintf_centre_ex(buffer, game_font, (BORDER_R+screen->w+TILE_SIZE/2)/2, 150, BLACKCOL, -1, "Level");
    textprintf_centre_ex(buffer, info_font, (BORDER_R+screen->w+TILE_SIZE/2)/2, 200, BLACKCOL, -1, " %d ", level);
}


///////////////////////////////////////////////////////////////////////////////

void draw_score()   {
    draw_sprite(buffer, info_bg, (BORDER_R+screen->w+TILE_SIZE/2)/2-info_bg->w/2, 315);
    textprintf_centre_ex(buffer, game_font, (BORDER_R+screen->w+TILE_SIZE/2)/2+3, 302, GREYCOL, -1, "Profit");
    textprintf_centre_ex(buffer, game_font, (BORDER_R+screen->w+TILE_SIZE/2)/2, 300, BLACKCOL, -1, "Profit");
    textprintf_centre_ex(buffer, info_font, (BORDER_R+screen->w+TILE_SIZE/2)/2, 350, BLACKCOL, -1, " $%d ", score);
}


///////////////////////////////////////////////////////////////////////////////

void draw_life()    {

    draw_sprite(buffer, info_bg, (BORDER_R+screen->w+TILE_SIZE/2)/2-info_bg->w/2, 465);
    textprintf_centre_ex(buffer, game_font, (BORDER_R+screen->w+TILE_SIZE/2)/2+3, 452, GREYCOL, -1, "Life");
    textprintf_centre_ex(buffer, game_font, (BORDER_R+screen->w+TILE_SIZE/2)/2, 450, BLACKCOL, -1, "Life");

    switch (life)   {
        case 5:
            draw_sprite(buffer, heart, (BORDER_R+screen->w+TILE_SIZE/2)/2+heart->w/10+1, 490+6*heart->h/5);
        case 4:
            draw_sprite(buffer, heart, (BORDER_R+screen->w+TILE_SIZE/2)/2-11*heart->w/10, 490+6*heart->h/5);
        case 3:
            draw_sprite(buffer, heart, (BORDER_R+screen->w+TILE_SIZE/2)/2+heart->w/10+1+heart->w/2, 490);
        case 2:
            draw_sprite(buffer, heart, (BORDER_R+screen->w+TILE_SIZE/2)/2-heart->w/2, 490);
        case 1:
            draw_sprite(buffer, heart, (BORDER_R+screen->w+TILE_SIZE/2)/2-11*heart->w/10-heart->w/2, 490);
            break;
        default:
            game_over = 1;
            break;
    }
}


///////////////////////////////////////////////////////////////////////////////

void update_score(int tiles_traveled)    {
    if (heads_in_play < 3)  {
        score += tiles_traveled;
    } else {
        score += (tiles_traveled+level) * (heads_in_play-1);
    }
}

///////////////////////////////////////////////////////////////////////////////

void check_level()  {
    switch (level)  {
        case 0:
            if (heads_completed == 5)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 19*1000/TIME_PER_TICK;
            }
            break;
        case 1:
            if (heads_completed == 10)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 19*1000/TIME_PER_TICK;
            }
            break;
        case 2:
            if (heads_completed == 15)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 18*1000/TIME_PER_TICK;
            }
            break;
        case 3:
            if (heads_completed == 20)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 17*1000/TIME_PER_TICK;
            }
            break;
        case 4:
            if (heads_completed == 25)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 16*1000/TIME_PER_TICK;
            }
            break;
        case 5:
            if (heads_completed == 30)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 15*1000/TIME_PER_TICK;
            }
            break;
        case 6:
            if (heads_completed == 35)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
            }
            break;
        case 7:
            if (heads_completed == 40)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 14*1000/TIME_PER_TICK;
            }
            break;
        case 8:
            if (heads_completed == 45)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 13*1000/TIME_PER_TICK;
            }
            break;
        case 9:
            if (heads_completed == 50)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 12*1000/TIME_PER_TICK;
            }
            break;
        case 10:
            if (heads_completed == 55)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
            }
            break;
        case 11:
            if (heads_completed == 60)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                ticks_per_move = 2;
            }
            break;
        case 12:
            if (heads_completed == 75)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 11*1000/TIME_PER_TICK;
            }
            break;
        case 13:
            if (heads_completed == 90)    {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
                head_wait_time = 10*1000/TIME_PER_TICK;
            }
            break;            
        default:
            if ((heads_completed-90)%15 == 0)   {
                level++;
                play_sample(lvlup_sound, VOL, PAN, FREQ, 0);
                draw_level();
            }
    }

}
