///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  int menu();
//  void setup_splash();
//  void bounce_arrow(void*);
//  void redraw_text(int);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

int menu()  {
    static int cur_select = SEL_NEWGAME;
    int keylock[3] = {0, 0, 1};
    int done = 0;
    int one_tick = ticks-1;
    
    cur_pipe_icon.type = NO_PIPE;
    cur_pipe_icon.mode = NO_PIPE;
    cur_pipe = pipe_none;    
    update_mouse_sprite();
    
    clear_to_color(buffer, SKYCOL);
    setup_splash();
    textprintf_right_ex(buffer, game_font, 9 * buffer->w / 10, 220, BLACKCOL, -1, "- A Han Games Studio production");
    textprintf_right_ex(buffer, game_font, 9 * buffer->w / 10+2, 222, BLUECOL, -1, "- A Han Games Studio production");

    rectfill(buffer, 145, 275, 655, 575, BLUECOL);
    rectfill(buffer, 149, 279, 651, 571, WHITECOL);
    rect(buffer, 144, 274, 656, 576, BLACKCOL);
    rect(buffer, 151, 281, 649, 569, BLACKCOL);
        
    textprintf_ex(buffer, game_font_48, 320, 300, BLACKCOL, -1, "New game");
    textprintf_ex(buffer, game_font_48, 320, 370, BLACKCOL, -1, "How to play");
    textprintf_ex(buffer, game_font_48, 320, 440, BLACKCOL, -1, "High scores");
    textprintf_ex(buffer, game_font_48, 320, 510, BLACKCOL, -1, "Exit");
    redraw_text(cur_select);

    while(!done)    {
        if (one_tick != ticks)    {
            undirty_buffer();
            if (mouse_x>=310 && mouse_x <=569)  {
                if (mouse_y>=295 && mouse_y<=353 && cur_select != SEL_NEWGAME)   {
                    play_sample(sweep_sound, VOL, PAN, FREQ, 0);
                    cur_select = SEL_NEWGAME;
                    redraw_text(cur_select);                      
                } else if (mouse_y>=365 && mouse_y<=423 && cur_select != SEL_HOWTOPLAY)   {
                    play_sample(sweep_sound, VOL, PAN, FREQ, 0);
                    cur_select = SEL_HOWTOPLAY;
                    redraw_text(cur_select);                      
                } else if (mouse_y>=435 && mouse_y<=493 && cur_select != SEL_HISCORE)   {
                    play_sample(sweep_sound, VOL, PAN, FREQ, 0);
                    cur_select = SEL_HISCORE;
                    redraw_text(cur_select);                      
                } else if (mouse_y>=505 && mouse_y<=563 && cur_select != SEL_EXIT)   {
                    play_sample(sweep_sound, VOL, PAN, FREQ, 0);
                    cur_select = SEL_EXIT;
                    redraw_text(cur_select);                      
                }
            }
        
            if (key[KEY_DOWN] || key[KEY_2_PAD])        {
                 if(!keylock[0])        {
                    play_sample(sweep_sound, VOL, PAN, FREQ, 0);
                    cur_select = (cur_select+NUM_SELECT+1) % NUM_SELECT;
                    redraw_text(cur_select);  
                    keylock[0] = 1;
                }
            } else if (keylock[0]) {
                keylock[0] = 0;
            }
    
            if (key[KEY_UP] || key[KEY_8_PAD])        {
                 if(!keylock[1])        {
                    play_sample(sweep_sound, VOL, PAN, FREQ, 0);
                    cur_select = (cur_select+NUM_SELECT-1) % NUM_SELECT;
                    redraw_text(cur_select);  
                    keylock[1] = 1;
                }
            } else if (keylock[1]) {
                keylock[1] = 0;
            }        
            
            if (key[KEY_ESC])    {
                if (!keylock[2])
                    done = 1;
            } else if (keylock[2]) {
                keylock[2] = 0;
            }
            
            if (key[KEY_ENTER] || key[KEY_SPACE] || mouse_b & 1)    {
                play_sample(select_sound, VOL, PAN, FREQ, 0);
                done = 1;
            }
        bounce_arrow(cur_select);
        
        one_tick = ticks;        
        
        draw_mouse_sprite();
                
        blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
        }
    }
    
    undirty_buffer();
    
    return cur_select;
}


///////////////////////////////////////////////////////////////////////////////

void setup_splash() {
    int border_L = TILE_SIZE, border_U = 0;
    draw_sprite(buffer, pipe_bend_RD, border_L, border_U);
    draw_sprite(buffer, pipe_straight_UD, border_L, border_U+TILE_SIZE);
    draw_sprite(buffer, pipe_bend_RU, border_L, border_U+2*TILE_SIZE);  
    draw_sprite(buffer, pipe_bend_LU, border_L+TILE_SIZE, border_U+2*TILE_SIZE); 
    draw_sprite(buffer, pipe_bend_RD, border_L+TILE_SIZE, border_U+TILE_SIZE);          
    draw_sprite(buffer, pipe_straight_LR, border_L+TILE_SIZE, border_U);
    draw_sprite(buffer, pipe_bend_LD, border_L+2*TILE_SIZE, border_U);
    draw_sprite(buffer, pipe_cross, border_L+2*TILE_SIZE, border_U+TILE_SIZE);
    draw_sprite(buffer, pipe_bend_RU, border_L+2*TILE_SIZE, border_U+2*TILE_SIZE);
    draw_sprite(buffer, pipe_straight_LR, border_L+3*TILE_SIZE, border_U+TILE_SIZE);
    draw_sprite(buffer, pipe_straight_LR, border_L+4*TILE_SIZE, border_U+TILE_SIZE);
    draw_sprite(buffer, pipe_straight_LR, border_L+5*TILE_SIZE, border_U+TILE_SIZE);
    draw_sprite(buffer, pipe_bend_LU, border_L+6*TILE_SIZE, border_U+TILE_SIZE);

    draw_sprite(buffer, pipe_straight_LR, border_L+3*TILE_SIZE, border_U+2*TILE_SIZE);
    draw_sprite(buffer, pipe_straight_LR, border_L+4*TILE_SIZE, border_U+2*TILE_SIZE);
    draw_sprite(buffer, pipe_straight_LR, border_L+5*TILE_SIZE, border_U+2*TILE_SIZE);
    draw_sprite(buffer, pipe_straight_LR, border_L+6*TILE_SIZE, border_U+2*TILE_SIZE);
    draw_sprite(buffer, pipe_straight_LR, border_L+7*TILE_SIZE, border_U+2*TILE_SIZE);
    draw_sprite(buffer, pipe_straight_LR, border_L+8*TILE_SIZE, border_U+2*TILE_SIZE);
    draw_sprite(buffer, logo_big, screen->w/2-logo_big->w/2, 10);
}


///////////////////////////////////////////////////////////////////////////////

void bounce_arrow(int cur_select) {
    static int speed_start = -7, t = 0;
    static int x = 230, y = 300, x_start = 230;
    float acceleration = 0.5;

    rectfill(buffer, x, y, x+arrow->w-1, y+arrow->h-1, WHITECOL);
    t++;

    x = (acceleration*t*t) / 2 +  (speed_start*t) + x_start;
    y = cur_select*70+300;


    if (x >= x_start)    {
        x = x_start;
        t = 0;
    }
    
    draw_sprite(buffer, arrow, x, y);

}


///////////////////////////////////////////////////////////////////////////////

void redraw_text(int cur_select)    {
    static int past_select = SEL_NEWGAME;

    switch (past_select)   {
        case SEL_NEWGAME:
            textprintf_ex(buffer, game_font_48, 320, 300, BLACKCOL, -1, "New game");
            break;
        case SEL_HOWTOPLAY:
            textprintf_ex(buffer, game_font_48, 320, 370, BLACKCOL, -1, "How to play");
            break;
        case SEL_HISCORE:
            textprintf_ex(buffer, game_font_48, 320, 440, BLACKCOL, -1, "High scores");
            break;
        case SEL_EXIT:
            textprintf_ex(buffer, game_font_48, 320, 510, BLACKCOL, -1, "Exit");
            break;
    }
    
    switch (cur_select)   {
        case SEL_NEWGAME:
            textprintf_ex(buffer, game_font_48, 320, 300, REDCOL, -1, "New game");
            break;
        case SEL_HOWTOPLAY:
            textprintf_ex(buffer, game_font_48, 320, 370, REDCOL, -1, "How to play");
            break;
        case SEL_HISCORE:
            textprintf_ex(buffer, game_font_48, 320, 440, REDCOL, -1, "High scores");
            break;
        case SEL_EXIT:
            textprintf_ex(buffer, game_font_48, 320, 510, REDCOL, -1, "Exit");
            break;
    }
    
    past_select = cur_select;
    blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
}
