///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void add_tick();
//  void setup();
//  void new_game();
//  void update_mouse_sprite();
//  void draw_mouse_sprite();
//  void getinput();
//  void game_loop();
//  void main(void);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

#include "tm.h"
#include "pipe.c"
#include "new_head.c"
#include "head_movement.c"
#include "misc.c"
#include "gameplay.c"
#include "fall_crash.c"
#include "menu.c"
#include "other_screens.c"

///////////////////////////////////////////////////////////////////////////////

void add_tick() {
    ticks = (ticks+1) % (1000/TIME_PER_TICK);
}


///////////////////////////////////////////////////////////////////////////////

void setup()            {
    int i, width, height, color_depth;
    allegro_init();
    install_keyboard();
    install_timer();
    if (install_mouse() == -1)   {
        allegro_message("Error initialising mouse handler.");
        exit(1);
    }
    
    srand(time(NULL));

    get_desktop_resolution(&width, &height);
    color_depth = desktop_color_depth();

    if (color_depth >= 24)    {
        set_color_depth(color_depth);
    } else if (color_depth == 16)    {
        set_color_depth(color_depth);
        set_color_conversion(COLORCONV_24_TO_16);
    }
    
    if (height > 600)    {
        set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0);
    } else {
        set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 800, 600, 0, 0);
    }

    set_window_title("Transit Mania: A Han Game Studios production");
    
    if (install_sound(DIGI_AUTODETECT, MIDI_NONE, "") != 0) {
        allegro_message("Error initialising sound system.");
        exit(1);
    }
    
    buffer = create_bitmap(screen->w, screen->h);

    data = load_datafile("data1.dat");
    
    pipe_none = create_bitmap(TILE_SIZE, TILE_SIZE);
    pipe_straight_LR = create_bitmap(TILE_SIZE, TILE_SIZE);
    pipe_straight_UD = create_bitmap(TILE_SIZE, TILE_SIZE);
    pipe_bend_LU = create_bitmap(TILE_SIZE, TILE_SIZE);
    pipe_bend_LD = create_bitmap(TILE_SIZE, TILE_SIZE);
    pipe_bend_RU = create_bitmap(TILE_SIZE, TILE_SIZE);
    pipe_bend_RD = create_bitmap(TILE_SIZE, TILE_SIZE);
    pipe_cross = create_bitmap(TILE_SIZE, TILE_SIZE);

    my_cursor = create_bitmap(((BITMAP*)data[D_cursor].dat)->w, ((BITMAP*)data[D_cursor].dat)->h);
    my_mouse_sprite = create_bitmap(TILE_SIZE, TILE_SIZE);

    face[0] = create_bitmap(FACE_SIZE, FACE_SIZE);
    mouth[0] = create_bitmap(FACE_SIZE, FACE_SIZE);
    mouth[1] = create_bitmap(FACE_SIZE, FACE_SIZE);
    mouth[2] = create_bitmap(FACE_SIZE, FACE_SIZE);
    mouth[3] = create_bitmap(FACE_SIZE, FACE_SIZE);
    eye[0] = create_bitmap(FACE_SIZE, FACE_SIZE);
    eye[1] = create_bitmap(FACE_SIZE, FACE_SIZE);
    eye[2] = create_bitmap(FACE_SIZE, FACE_SIZE);
    house_bmp = create_bitmap(HOUSE_SIZE, HOUSE_SIZE);

    crash_bmp = create_bitmap(((BITMAP*)data[D_crash].dat)->w, ((BITMAP*)data[D_crash].dat)->h);
    cloud_bmp[0] = create_bitmap(((BITMAP*)data[D_cloud1].dat)->w, ((BITMAP*)data[D_cloud1].dat)->h);
    cloud_bmp[1] = create_bitmap(((BITMAP*)data[D_cloud2].dat)->w, ((BITMAP*)data[D_cloud2].dat)->h);
    cloud_bmp[2] = create_bitmap(((BITMAP*)data[D_cloud3].dat)->w, ((BITMAP*)data[D_cloud3].dat)->h);
    cloud_bmp[3] = create_bitmap(((BITMAP*)data[D_cloud4].dat)->w, ((BITMAP*)data[D_cloud4].dat)->h);

    blit(data[D_pipe_straight].dat, pipe_straight_LR, 0, 0, 0, 0, TILE_SIZE, TILE_SIZE);
    blit(data[D_pipe_bend].dat, pipe_bend_LD, 0, 0, 0, 0, TILE_SIZE, TILE_SIZE);    
    blit(data[D_pipe_cross].dat, pipe_cross, 0, 0, 0, 0, TILE_SIZE, TILE_SIZE);    
    blit(data[D_cursor].dat, my_cursor, 0, 0, 0, 0, my_cursor->w, my_cursor->h);    

    blit(data[D_face].dat, face[0], 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);    
    blit(data[D_mouth_0].dat, mouth[0], 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);    
    blit(data[D_mouth_1].dat, mouth[1], 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);    
    blit(data[D_mouth_2].dat, mouth[2], 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);    
    blit(data[D_mouth_3].dat, mouth[3], 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);    
    blit(data[D_eye_0].dat, eye[0], 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);    
    blit(data[D_eye_1].dat, eye[1], 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);    
    blit(data[D_eye_2].dat, eye[2], 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);    
    blit(data[D_house].dat, house_bmp, 0, 0, 0, 0, HOUSE_SIZE, HOUSE_SIZE);

    blit(data[D_crash].dat, crash_bmp, 0, 0, 0, 0, crash_bmp->w, crash_bmp->h);    
    blit(data[D_cloud1].dat, cloud_bmp[0], 0, 0, 0, 0, cloud_bmp[0]->w, cloud_bmp[0]->h);    
    blit(data[D_cloud2].dat, cloud_bmp[1], 0, 0, 0, 0, cloud_bmp[1]->w, cloud_bmp[1]->h);    
    blit(data[D_cloud3].dat, cloud_bmp[2], 0, 0, 0, 0, cloud_bmp[2]->w, cloud_bmp[2]->h);    
    blit(data[D_cloud4].dat, cloud_bmp[3], 0, 0, 0, 0, cloud_bmp[3]->w, cloud_bmp[3]->h);    

    unload_datafile(data);    


    data = load_datafile("data2.dat");

    game_font = data[D_game_font].dat;    
    game_font_48 = data[D_game_font_48].dat; 
    info_font = data[D_info_font].dat;
    logo_small = data[D_logo_small].dat;
    logo_big = data[D_logo_big].dat;
    info_bg = data[D_info_bg].dat;
    heart = data[D_heart].dat;
    arrow = data[D_arrow].dat;

    clear_to_color(pipe_none, makecol(255, 0, 255));
    clear_to_color(pipe_straight_UD, makecol(255, 0, 255));
    clear_to_color(pipe_bend_LU, makecol(255, 0, 255));
    clear_to_color(pipe_bend_RU, makecol(255, 0, 255));
    clear_to_color(pipe_bend_RD, makecol(255, 0, 255));
    clear_to_color(mouse_sprite, makecol(255, 0, 255));

    rotate_sprite(pipe_straight_UD, pipe_straight_LR, 0, 0, itofix(64));
    rotate_sprite(pipe_bend_LU, pipe_bend_LD, 0, 0, itofix(64));
    rotate_sprite(pipe_bend_RU, pipe_bend_LD, 0, 0, itofix(128));
    rotate_sprite(pipe_bend_RD, pipe_bend_LD, 0, 0, itofix(192));
    
    for (n=1; n<5; n++)    {
        face[n] = create_bitmap(FACE_SIZE, FACE_SIZE);
        blit(face[0], face[n], 0, 0, 0, 0, FACE_SIZE, FACE_SIZE);
    }
    
    floodfill(face[1], FACE_SIZE/2, FACE_SIZE/2, GREENCOL);
    floodfill(face[2], FACE_SIZE/2, FACE_SIZE/2, BLUECOL);
    floodfill(face[3], FACE_SIZE/2, FACE_SIZE/2, REDCOL);
    floodfill(face[4], FACE_SIZE/2, FACE_SIZE/2, YELLOWCOL);

    crash_sound = data[D_crash_sound].dat;
    fall_sound = data[D_fall_sound].dat;
    honk_sound = data[D_honk_sound].dat;
    pipe_io_sound = data[D_pipe_io_sound].dat;
    place_pipe_sound = data[D_place_pipe_sound].dat;
    tick_sound = data[D_tick_sound].dat; 
    select_sound = data[D_select_sound].dat;
    sweep_sound = data[D_sweep_sound].dat;    
    lvlup_sound = data[D_lvlup_sound].dat;
    boo_sound = data[D_boo_sound].dat;
    cheer_sound = data[D_cheer_sound].dat;

    for (n=0; n<NUM_HIBYE; n++)   {
        hi_sound[n] = data[D_hi_sound1+n].dat;
        bye_sound[n] =data[D_bye_sound1+n].dat;
    }

//  setting fresh new high score or opening existing one.
    if (!exists("score.dat"))    {
        for (n=0; n<10; n++)    {
            strcpy(hiscore[n].name, "-------------------");
            hiscore[n].score = 0;
        }
    } else {
        score_pack = pack_fopen("score.dat", "rp");
        for (n=0; n<10; n++)    {
            hiscore[n].score = pack_igetl(score_pack);
            pack_getc(score_pack);
            pack_fgets(hiscore[n].name, sizeof(hiscore[n].name), score_pack);
            pack_getc(score_pack);
        }
        pack_fclose(score_pack);

    }
    
    LOCK_VARIABLE(ticks);
    LOCK_FUNCTION(add_tick);
    
    install_int(add_tick, TIME_PER_TICK);
        
    game_over = 1;
    ticks = 1;
    
    first_DR = NULL;
}


///////////////////////////////////////////////////////////////////////////////

void new_game() {
    int i;

    level = 0;
    score = 0;
    life = 5;    
    heads_in_play = 0;

    randomize_elements(face, 5);
    randomize_elements(mouth, 4);
    randomize_elements(eye, 3);
  
    clear_to_color(buffer, BACKCOL);
    draw_sprite(buffer, logo_small, (screen->w+BORDER_R+TILE_SIZE/3)/2-logo_small->w/2, 20);
    rectfill(buffer, BORDER_L, BORDER_U, BORDER_R, BORDER_D, SKYCOL);
    rect(buffer, BORDER_L-1, BORDER_U-1, BORDER_R+1, BORDER_D+1, BLACKCOL);
    rect(buffer, BORDER_L-2, BORDER_U-2, BORDER_R+2, BORDER_D+2, BLACKCOL);
    rect(buffer, BORDER_L-3, BORDER_U-3, BORDER_R+3, BORDER_D+3, BLACKCOL);
    draw_level();
    draw_score();
    draw_life();


    for (n=0; n<6; n++)    {
        for (i=0; i<6; i++)    {
             field_pipes[n][i].type = NO_PIPE;   
             field_pipes[n][i].mode = NO_PIPE;
        }
    }

    for (i=0; i<4; i++)    {
        for (n=0; n<6; n++)    {
            if (i / 2)    {
                start_end_remaining[i*6 + n].x = BORDER_L + TILE_SIZE*n + TILE_SIZE/2;
                if (i == 2)    {
                    start_end_remaining[i*6 + n].y = BORDER_U;
                } else {
                    start_end_remaining[i*6 + n].y = BORDER_D;
                }        
            } else {
                start_end_remaining[i*6 + n].y = BORDER_U + TILE_SIZE*n + TILE_SIZE/2;
                if (i == 0)    {
                    start_end_remaining[i*6 + n].x = BORDER_L;
                } else {
                    start_end_remaining[i*6 + n].x = BORDER_R;
                }        
            }
            start_end_remaining[i*6 + n].z = 0;
        }
    }

    num_coords_remaining = 24;

    first_head_waiting = NULL;
    last_head_waiting = NULL;
    first_head_traveling = NULL;
    first_falling = NULL;
    first_colliding = NULL;
    
    head_wait_time = 20*1000/TIME_PER_TICK;
    
    create_new_head();

    ticks_per_move = 3;
    move_countdown = ticks_per_move;
    heads_completed = 0;
    game_over = 0;

}


///////////////////////////////////////////////////////////////////////////////

void update_mouse_sprite()  {

    blit(cur_pipe, my_mouse_sprite, 0, 0, 0, 0, cur_pipe->w, cur_pipe->h);
    draw_sprite(my_mouse_sprite, my_cursor, TILE_SIZE/2-my_cursor->w/2, 
        TILE_SIZE/2-my_cursor->h/2);  
}


///////////////////////////////////////////////////////////////////////////////

void draw_mouse_sprite()  {
    // save back image first
    first_DR = malloc(sizeof(DIRTY_RECTANGLE_t));
    first_DR->clean_bmp = create_bitmap(TILE_SIZE, TILE_SIZE);
    first_DR->x = mouse_x-TILE_SIZE/2;
    first_DR->y = mouse_y-TILE_SIZE/2;
    first_DR->next = NULL;
    blit(buffer, first_DR->clean_bmp, first_DR->x, first_DR->y, 0, 0, TILE_SIZE, TILE_SIZE);
    
    draw_sprite(buffer, my_mouse_sprite, first_DR->x, first_DR->y);
}


///////////////////////////////////////////////////////////////////////////////

void getinput() {
    static int sound_on = 1;
    static int keylock[5] = {0, 1, 1, 0, 0};
    
    if (mouse_b & 4 || key[KEY_LCONTROL] || key[KEY_RCONTROL])    {
        if (!keylock[0])    {
            change_pipe(DO_CHANGETYPE);
            keylock[0] = 1;
        }
    } else if (keylock[0]) {
        keylock[0] = 0;
    }
    if (mouse_b & 1)    {
        if (!keylock[1])    {
            place_pipe();
            keylock[1] = 1;
        }
    } else if (keylock[1]) {
        keylock[1] = 0;
    }
    if (mouse_b & 2 || key[KEY_LSHIFT] || key[KEY_RSHIFT])    {
        if (!keylock[2])    {
            suck_in_head();
            keylock[2] = 1;
        }
    } else if (keylock[2]) {
        keylock[2] = 0;
    }
    if (mouse_z || key[KEY_ALT] || key[KEY_ALTGR])    {
        if (!keylock[3])    {
            change_pipe(DO_ROTATE);
            keylock[3] = 1;
        }
        position_mouse_z(0);
    } else if (keylock[3]) {
        keylock[3] = 0;
    }
    if(key[KEY_F1])   {
            display_howtoplay();
            keylock[2] = 1;
            blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
    }
    if (key[KEY_F2])    {
        if (keylock[4] == 0)    {    
            keylock[4] = 1;
            if (sound_on)    {
                set_volume(0, -1);
            } else {
                set_volume(VOL, -1);
            }
            sound_on = !sound_on;
        } 
    } else if (keylock[4])   {
        keylock[4] = 0;
    }
    if(key[KEY_F9])
            game_over = 1;

}


///////////////////////////////////////////////////////////////////////////////

void game_loop() {
    int one_tick = ticks-1;
    while (!game_over)    {
        if (one_tick != ticks)  {
            undirty_buffer();
            getinput();
            update_wait_times();
            
            if (move_countdown == 0)    {
                move_all_heads();
                move_countdown = ticks_per_move;
            } else {
                move_countdown--;
            }

            if (!ticks)  {
                new_head_controller();
            }

            draw_mouse_sprite();
            draw_falling();
            draw_crash();

            blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);    
            one_tick = ticks;
        }
    }    
    lose_game();
}


///////////////////////////////////////////////////////////////////////////////

void main() {
    int selected_opt;
    setup();

    selected_opt = menu();
    
    while (!key[KEY_ESC] && (selected_opt != SEL_EXIT))    {
        switch (selected_opt)    {
            case SEL_NEWGAME:
                new_game();
                game_loop();
                while (!key[KEY_ESC] && !(mouse_b&2));
                break;
            case SEL_HOWTOPLAY:
                display_howtoplay();
                while (!key[KEY_ESC] && !(mouse_b&2));
                break;
            case SEL_HISCORE:
                display_hiscore();
                while (!key[KEY_ESC] && !(mouse_b&2));
                break;
        }
        selected_opt = menu();
    } 

    remove_int(add_tick);
    
    destroy_bitmap(pipe_none);
    destroy_bitmap(pipe_straight_LR);
    destroy_bitmap(pipe_straight_UD);
    destroy_bitmap(pipe_bend_LU);
    destroy_bitmap(pipe_bend_LD);
    destroy_bitmap(pipe_bend_RU);
    destroy_bitmap(pipe_bend_RD);
    destroy_bitmap(pipe_cross);
    destroy_bitmap(my_cursor);
    destroy_bitmap(my_mouse_sprite);
    destroy_bitmap(buffer);
    destroy_bitmap(crash_bmp);
    for (n=0; n<4; n++)
        destroy_bitmap(mouth[n]);
    for (n=0; n<3; n++)
        destroy_bitmap(eye[n]);
    for (n=0; n<4; n++)
        destroy_bitmap(cloud_bmp[n]);
    for (n=0; n<5; n++)
        destroy_bitmap(face[n]);

    score_pack = pack_fopen("score.dat", "wp");
    for (n=0; n<10; n++)    {
        pack_iputl(hiscore[n].score, score_pack);
        pack_putc('|',score_pack); 
        pack_fputs(hiscore[n].name, score_pack);
        pack_putc('|',score_pack);
    }
    pack_fclose(score_pack);

    
    unload_datafile(data);

    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);    

    allegro_exit();
}

END_OF_MAIN();
