///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void check_out_of_field();
//  void remove_head(HEAD_t*, HEAD_t**);
//  void check_head_collision(HEAD_t*, HEAD_t*, HEAD_t*);
//  int heads_colliding(HEAD_t*, HEAD_t*);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void check_out_of_field()  {
    int coord_x, coord_y;
    HEAD_t *cur_head, *prev_head = NULL;

    cur_head = first_head_traveling;
    while (cur_head != NULL)    {       
        coord_x = get_x_coord(cur_head->cur_location.x);
        coord_y = get_y_coord(cur_head->cur_location.y);
        if (((coord_x>5) || (coord_x<0) || (coord_y>5) || (coord_y<0)) && cur_head->tiles_traveled)   {

            if ((coord_x == get_x_coord(cur_head->target_location.x)) && 
                (coord_y == get_y_coord(cur_head->target_location.y)))  {
                heads_completed++;
                play_sample(bye_sound[cur_head->sound_scheme], VOL, PAN, FREQ, 0);
                update_score(cur_head->tiles_traveled);
                draw_score();
                remove_head(prev_head, &cur_head);
                check_level();
            } else {
                life--;
                draw_life();
                add_new_falling(cur_head);
                remove_head(prev_head, &cur_head);
            }
        
        }
        
        if ((prev_head == NULL) && (cur_head == NULL))    {
            cur_head = first_head_traveling;
        } else {
            prev_head = cur_head;
            cur_head = cur_head->next_head;
        }
    }
}


///////////////////////////////////////////////////////////////////////////////

void remove_head(HEAD_t *prev_head, HEAD_t **cur_head)  {
    heads_in_play--;
    rectfill(buffer, (*cur_head)->target_location.x-HOUSE_SIZE/2, (*cur_head)->target_location.y-HOUSE_SIZE/2,
    (*cur_head)->target_location.x+HOUSE_SIZE/2, (*cur_head)->target_location.y+HOUSE_SIZE/2, BACKCOL);
     
    if (prev_head == NULL)        {
        first_head_traveling = (*cur_head)->next_head;
    } else {
        prev_head->next_head = (*cur_head)->next_head;
    }
    
    start_end_remaining[(*cur_head)->target_location.z].z = 0;
    start_end_remaining[(*cur_head)->cur_location.z].z = 0;
    num_coords_remaining+=2;
    destroy_bitmap((*cur_head)->head_bmp);
    destroy_bitmap((*cur_head)->house_bmp);
    free(*cur_head);
    
    if (prev_head == NULL)        {
        *cur_head = NULL;
    } else {
        *cur_head = prev_head;
    }


}


///////////////////////////////////////////////////////////////////////////////

void check_head_collision(HEAD_t *prev_head_static, HEAD_t **cur_head_static, 
    HEAD_t *prev_head_compare) {
    HEAD_t *temp_head1, *temp_head2;

    if (heads_colliding(*cur_head_static, prev_head_compare->next_head))    {
        life-=2;
        draw_life();      
        add_new_crashing(prev_head_compare->next_head, *cur_head_static);
        temp_head1 = prev_head_compare->next_head->next_head;
        temp_head2 = prev_head_compare->next_head;
        remove_head(prev_head_compare, &temp_head2);
        prev_head_compare->next_head = temp_head1;
        remove_head(prev_head_static, cur_head_static);
        
        return;
    }
    
    if (prev_head_compare->next_head->next_head != NULL)
        check_head_collision(prev_head_static, cur_head_static, prev_head_compare->next_head);

}


///////////////////////////////////////////////////////////////////////////////

int heads_colliding(HEAD_t *cur_head_static, HEAD_t *cur_head_compare)  {

    if (cur_head_static->cur_location.x < cur_head_compare->cur_location.x-FACE_SIZE)
    return 0;

    if (cur_head_static->cur_location.x > cur_head_compare->cur_location.x+FACE_SIZE)
    return 0;

    if (cur_head_static->cur_location.y < cur_head_compare->cur_location.y-FACE_SIZE)    
    return 0;

    if (cur_head_static->cur_location.y > cur_head_compare->cur_location.y+FACE_SIZE)    
    return 0;


    return 1;
}
