///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//  functions included in this file:
//  void draw_falling();
//  void draw_crash();
//  void add_new_falling(HEAD_t*);
//  void add_new_crashing(HEAD_t*, HEAD_t*);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void draw_falling() {
    DIRTY_RECTANGLE_t *temp_DR;
    FALL_CRASH_t *cur_fall = first_falling;
    FALL_CRASH_t *prev_fall = NULL;
    FALL_CRASH_t *temp;

    // check for finished falls
    while (cur_fall != NULL)    {
        if (!cur_fall->ticks_remaining)   {
            temp = cur_fall->next;
            free(cur_fall);
            if (prev_fall == NULL)   {
                first_falling = temp;
            } else {
                prev_fall->next = temp;
            }
            cur_fall = temp;
        } else {
            prev_fall = cur_fall;
            cur_fall = cur_fall->next;
        }
    }
        
     
    // update ticks of current falls
    cur_fall = first_falling;
    while (cur_fall != NULL)    {
        cur_fall->ticks_remaining--;
        cur_fall = cur_fall->next;
    }

    // save back image
    cur_fall = first_falling;
    while (cur_fall != NULL)    {
        temp_DR = first_DR;
        first_DR = malloc(sizeof(DIRTY_RECTANGLE_t));
        first_DR->clean_bmp = create_bitmap(cloud_bmp[0]->w, cloud_bmp[0]->h);
        first_DR->x = cur_fall->x-cloud_bmp[0]->w/2;
        first_DR->y = cur_fall->y-cloud_bmp[0]->h/2;
        first_DR->next = temp_DR;
        blit(buffer, first_DR->clean_bmp, first_DR->x, first_DR->y, 0, 0, TILE_SIZE, TILE_SIZE);
        cur_fall = cur_fall->next;
    }
    
    // draw clouds
    cur_fall = first_falling;
    while (cur_fall != NULL)    {
        draw_sprite(buffer, cloud_bmp[(cur_fall->ticks_remaining/(FALL_TICKS/8))%4], cur_fall->x-cloud_bmp[0]->w/2, cur_fall->y-cloud_bmp[0]->h/2);
        cur_fall = cur_fall->next;
    }    
}



///////////////////////////////////////////////////////////////////////////////

void draw_crash()   {
    DIRTY_RECTANGLE_t *temp_DR;
    FALL_CRASH_t *cur_crash = first_colliding;
    FALL_CRASH_t *prev_crash = NULL;
    FALL_CRASH_t *temp;
    int temp_int;

    // check for finished crashs
    while (cur_crash != NULL)    {
        if (!cur_crash->ticks_remaining)   {
            temp = cur_crash->next;
            free(cur_crash);
            if (prev_crash == NULL)   {
                first_colliding = temp;
            } else {
                prev_crash->next = temp;
            }
            cur_crash = temp;
        } else {
            prev_crash = cur_crash;
            cur_crash = cur_crash->next;
        }
    }
        
     
    // update ticks of current crashs
    cur_crash = first_colliding;
    while (cur_crash != NULL)    {
        cur_crash->ticks_remaining--;
        cur_crash = cur_crash->next;
    }

    // save back image
    cur_crash = first_colliding;
    while (cur_crash != NULL)    {
        temp_DR = first_DR;
        first_DR = malloc(sizeof(DIRTY_RECTANGLE_t));
        first_DR->clean_bmp = create_bitmap(crash_bmp->w, crash_bmp->h);
        first_DR->x = cur_crash->x-crash_bmp->w/2;
        first_DR->y = cur_crash->y-crash_bmp->h/2;
        first_DR->next = temp_DR;
        blit(buffer, first_DR->clean_bmp, first_DR->x, first_DR->y, 0, 0, crash_bmp->w, crash_bmp->h);
        cur_crash = cur_crash->next;
    }
    
    
    // draw crash
    cur_crash = first_colliding;
    while (cur_crash != NULL)    {
        temp_int = cur_crash->ticks_remaining/(CRASH_TICKS/10) - 5;
        if (temp_int <= 0)    {
            draw_sprite(buffer, crash_bmp, cur_crash->x-crash_bmp->w/2, cur_crash->y-crash_bmp->h/2);
        } else {
            stretch_sprite(buffer, crash_bmp, cur_crash->x-crash_bmp->w/2/temp_int, 
            cur_crash->y-crash_bmp->h/2/temp_int, crash_bmp->w/temp_int, crash_bmp->h/temp_int);
        }
        cur_crash = cur_crash->next;
    }    
}
///////////////////////////////////////////////////////////////////////////////

void add_new_falling(HEAD_t *head_to_add)   {
    play_sample(fall_sound, VOL, PAN, FREQ, 0);
    FALL_CRASH_t *temp = malloc(sizeof(FALL_CRASH_t));
    temp->x = head_to_add->cur_location.x;
    temp->y = head_to_add->cur_location.y;
    temp->ticks_remaining = FALL_TICKS;
    temp->next = first_falling;
    first_falling = temp;

}


///////////////////////////////////////////////////////////////////////////////

void add_new_crashing(HEAD_t *head_to_add1, HEAD_t *head_to_add2)    {
    play_sample(crash_sound, VOL, PAN, FREQ, 0);
    FALL_CRASH_t *temp = malloc(sizeof(FALL_CRASH_t));
    temp->x = (head_to_add1->cur_location.x+head_to_add2->cur_location.x)/2;
    temp->y = (head_to_add1->cur_location.y+head_to_add2->cur_location.y)/2;
    temp->ticks_remaining = CRASH_TICKS;
    temp->next = first_colliding;
    first_colliding = temp;
}
///////////////////////////////////////////////////////////////////////////////

