#include "draw.h"
#include "input.h"
#include "vars.h"
#include "moves.h"
#include "ai.h"
#include "fonts.h"
#include "sfx.h"
#include "sounds.h"
#include <string.h>

void gere_input(void) {
   int i;
   
   //on vrifie les entres de tous les joueurs.
   if (game_state == PLAYING_THE_GAME) {
      for (i = 0; i < nb_max_players; ++i) {
         if (player[i]->state == HUMAN)
            gere_input_player(player[i]);
         else
            gere_input_ai(player[i]);
      }
   }

   return;
}

void gere_input_player(PLAYER* p_player) {
   int tx, ty;
   get_mouse_mickeys(&tx, &ty);
   
   p_player->racket->IS_MOVING = FALSE;
   
   if (key[p_player->key_up]) {

      p_player->racket->speed.y-= RACKET_ACC_Y;


      if (p_player->racket->speed.y <= -RACKET_MAX_SPEED_Y)
         p_player->racket->speed.y = -RACKET_MAX_SPEED_Y;
      
      p_player->racket->IS_MOVING = TRUE;

   }
   else if (key[p_player->key_down]) {
      p_player->racket->speed.y += RACKET_ACC_Y;

      if (p_player->racket->speed.y >= RACKET_MAX_SPEED_Y)
         p_player->racket->speed.y = RACKET_MAX_SPEED_Y;

      p_player->racket->IS_MOVING = TRUE;

   }
   
   return;
}


void get_player_name(char *name, int score) {
   char temp[10];
   BITMAP *bmp_temp   ;
   int k;

   if (draw_method != DOUBLE_BUFFER)
	   bmp_temp = create_video_bitmap(SCREEN_W, SCREEN_H);
	else
	   bmp_temp = create_bitmap(SCREEN_W, SCREEN_H);
   
   strcpy(name, "Your name?");
   
   if (bmp_temp == NULL) {
      strcpy(name, "Default");
      return;
   }
  
 
   do {
      //clear_to_color(bitmap_mask_color(bmp_temp);
      
      //ici, on doit stopper les samples avant sinon, ca coupe le son  cause du nombre de voix rserves (pas la peine d'en mettre plus d'ailleurs)
      for (k = 0; k < NB_SOUNDS_FOR_INPUT_NAME; k++)
         stop_sample(data_sfx[WRITE1_WAV + k].dat);
      
      play_sound(data_sfx[WRITE1_WAV + rand()%NB_SOUNDS_FOR_INPUT_NAME].dat, SCREEN_W/2);

      draw();
     
      clear_keybuf();
      k = readkey() & 0xff;
      if (strlen(name) < MAX_NAME_LENGTH-1){
         if ((k >= 'A' && k <= 'Z') || (k >= 'a' && k <= 'z') || k == 32) {
            sprintf(temp, "%c",k);
            strcat(name, temp);
         }
      }
      if (k == 8 && strlen(name) >= 1) { //backspace
         name[strlen(name)-1] = '\0';						
      }
  
   } while (!strlen(name) || (k != 13 && strlen(name) >= 1)); /* enter */

   game_time = current_score = 0;
   destroy_bitmap(bmp_temp);

}

//la fonction qui gre les entres du menu
void gere_input_menu(TPONG_MENU *menu) {
   if (game_state != IN_MENU && game_state != IN_OPTION_MENU && game_state != IN_MODE_SELECTOR_MENU)
      return;
      
   if (key[KEY_UP]) {
      if (key_pressed == FALSE) {
         --(menu->cur_selection);
         play_sound(data_sfx[WRITE1_WAV + rand()%5].dat, SCREEN_W/2);            
      }
      key_pressed = TRUE;
   }
   else if (key[KEY_DOWN]) {
     if (key_pressed == FALSE) {
        ++(menu->cur_selection);
        play_sound(data_sfx[WRITE1_WAV + rand()%5].dat, SCREEN_W/2);            
     }
     key_pressed = TRUE;
   }
   else if (key[KEY_ESC])
      key_pressed = TRUE;
   else if (key[KEY_ENTER] && key_pressed == TRUE)
      key_pressed = TRUE;
   else
      key_pressed = FALSE;

   if (menu->cur_selection < 0)
      menu->cur_selection = menu->nb_elements-1;
   else if (menu->cur_selection >= menu->nb_elements)
      menu->cur_selection = 0;
   return;
}

void set_player_keys(TPONG_CONFIG_PLAYER* player_conf) {

   prepare_to_draw();

   clear_bitmap(buffer);
   draw_option_menu(option_menu);
   textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/6, makecol(150,255,255), "Press a key for UP");
   buffer_onto_screen();

   player_conf->key_up = detect_key();





   prepare_to_draw();

   clear_bitmap(buffer);
   draw_option_menu(option_menu);   
   textprintf_centre(buffer, data_fonts[FONT02_PCX].dat, SCREEN_W/2, SCREEN_H/6, makecol(150,255,255), "Press a key for DOWN");
   buffer_onto_screen();
   
   player_conf->key_down = detect_key();

   

   return;
}
   
int detect_key(void) {
   unsigned char k;//k taille d'un caractere clavier
   char tempkey[256]; //C'est le tableau provisoire des touches prsses ou non   

   //on balaye la matrice du clavier jusqu ce qu'on trouve une touche prsse!

   //On copie un bloc de KEY_MAX pointeurs vers key
   memcpy(tempkey,(char *)key,KEY_MAX);
   for (;;) {//la boucle infinie

      for (k = 0 ;k < KEY_MAX ; k++) {
         if (k != KEY_PAUSE) {//je sais pas ce que c'est mais bon!
            if (tempkey[k]) {
               if (key[k]==0)
                  tempkey[k]=0;
            } else {
               if (key[k] && k != KEY_ENTER && k != KEY_ENTER_PAD && k != KEY_ESC)//ENTER, ENTER_PAD et ESC sont interdit d'utilisation
                  return k;
            }
         }
      }

   }
}
