#include <allegro.h>
#include <stdio.h>
#include "init.h"
#include "vars.h"
#include "menu.h"
#include "gamelogic.h"
#include "hscore.h"

//tableau renomm ripp d'un fichier d'Allegro, je sais plus lequel
//de toute faon, on peut le retrouver dans un header d'allegro
char *key_names[] =
{
   "(none)",         "A",              "B",              "C",
   "D",              "E",              "F",              "G",
   "H",              "I",              "J",              "K",
   "L",              "M",              "N",              "O",
   "P",              "Q",              "R",              "S",
   "T",              "U",              "V",              "W",
   "X",              "Y",              "Z",              "0",
   "1",              "2",              "3",              "4",
   "5",              "6",              "7",              "8",
   "9",              "Keypad 0",       "Keypad 1",       "Keypad 2",
   "Keypad 3",       "Keypad 4",       "Keypad 5",       "Keypad 6",
   "Keypad 7",       "Keypad 8",      "Keypad 9",      "F1",
   "F2",             "F3",             "F4",             "F5",
   "F6",             "F7",             "F8",             "F9",
   "F10",            "F11",            "F12",            "ESC",
   "KEY_TILDE",      "KEY_MINUS",      "KEY_EQUALS",     "BACKSPACE",
   "TAB",            "KEY_OPENBRACE",  "KEY_CLOSEBRACE", "ENTER",
   "KEY_COLON",      "KEY_QUOTE",      "KEY_BACKSLASH",  "KEY_BACKSLASH2",
   "KEY_COMMA",      "KEY_STOP",       "KEY_SLASH",      "SPACE",
   "INSERT",         "DEL",            "KEY_HOME",       "END",
   "PGUP",           "PGDN",           "LEFT",           "RIGHT",
   "UP",             "DOWN",           "KEY_SLASH_PAD",  "KEY_ASTERISK",
   "KEY_MINUS_PAD",  "Keypad PLUS",    "Keypad DEL",     "Keypad ENTER",
   "KEY_PRTSCR",     "KEY_PAUSE",      "KEY_ABNT_C1",    "KEY_YEN",
   "KEY_KANA",       "KEY_CONVERT",    "KEY_NOCONVERT",  "KEY_AT",
   "KEY_CIRCUMFLEX", "KEY_COLON2",     "KEY_KANJI",
   "Left SHIFT",     "Right SHIFT",    "Left CTRL",      "Right CTRL",
   "Left ALT",       "ALT GR",         "Left WIN",       "Right WIN",
   "KEY_MENU",       "KEY_SCRLOCK",    "NUMLOCK",        "CAPSLOCK",
   "KEY_MAX"
};

int main(void) {
   //tout d'abord, on cre un logfile!
   fp = fopen("logfile.txt","w");
   	
   fprintf(fp, "TPong " TPONG_VERSION" (" TPONG_DATE_VERSION")\n");
   
   if (init_game() == FALSE) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error : %s.\nEdit \"config.ini\" to solve the problem.", pong_error);
      return 1;
   }
   

   launch_menu();//la fonction qui va dans le menu et qui y reste

   //packfile_password("temp");
   //on quite normalement
   //save_scores();
   //packfile_password(NULL);
   
   fprintf(fp, "This time, you've been playing during %ld seconds!\n", current_sec_counter);

   free_vars(); //on libre toutes les dernires variables (alloues par init_game )
   
   return 0;//tout va bien, on peut quitter
}
END_OF_MAIN();
