#include "menu.h"
#include "init.h"
#include "gamelogic.h"
#include "vars.h"
#include "draw.h"
#include "moves.h"
#include "input.h"
#include "hscore.h"
#include "draw.h"
#include "sounds.h"
#include "sfx.h"



int play_the_menu(TPONG_MENU *menu, int game_state_type, int cur_selec) {
   game_state = game_state_type;
	//cur_selection = cur_selec;
   //on vient d'appuyer sur une touche pour lancer le menu
   key_pressed = TRUE;
   game_time = 0;//on remet  zro, sinon, on risque d'avoir des problmes! :)
   //on est pret  jouer maintenant
   while ((key[KEY_ESC] == FALSE || key_pressed == TRUE) && close_state == FALSE) {

      while (game_time > 0) { //en temps rel le menu, siouplait!

         //on commence par grer les entres(clavier, joy, ...)
         //on le met  l'intrieur de la boucle au cas ou l'ordi soit une larve
         
         gere_input_menu(menu);
         
         if (key[KEY_ENTER] && key_pressed == FALSE) {//il appuie sur Enter?
            play_sound(data_sfx[MENU_OK_WAV].dat, SCREEN_W/2);    
            return menu->cur_selection;
         }
         
         --game_time;//dcrmente notre compteur "temps-rel"
      }

      draw_menu(menu);

   }

   return QUIT_THE_GAME;
}


int play_the_game(void) {//la boucle infinie du jeu
   int last_sec_counter = 0;
   current_score = 0; //On remet le score  zro
   
   game_time = 0;//on remet le compteur du temps rel  0
   //on est pret  jouer maintenant
   while (!key[KEY_ESC] && close_state == FALSE) {

      //on update les positions de tout le monde
      while (game_time > 0) {
         //on commence par gre les entres(clavier, joy, ...)
         //on le met  l'intrieur de la boucle au cas ou l'ordi soit une larve

         gere_input();

         update_game_logic();
         --game_time;
      }
      //on update les fps:

      if (current_sec_counter != last_sec_counter) {
         fps = current_fps;
         last_sec_counter = current_sec_counter;
         current_fps = 0;
      }

      current_fps++;
      draw();//on dssine
   }
   /* Avant de quitter le jeu actuel, on affiche les rsultats des parties dans le logfile */
   if (game_type == DUEL_2P || game_type == DUEL_2AI)
      fprintf(fp, " Left scored : %ld\nRight scored : %ld\n", game_info.nb_left_wins, game_info.nb_right_wins);
   
   
   
   return RETURN_MAIN_MENU;//on quitte compltement
}

void update_game_logic(void) {
   int i;
 
   //on s'occupe de bouger les balles
   for (i = 0; i < nb_max_balls; ++i) {
      if (ball[i]->EXIST == TRUE) 
         move_ball(ball[i]);
   }

   //on bouge les raquettes
   for (i = 0; i < nb_max_players; ++i) {//On fait comme si il n'y avait que deux joueurs
      move_racket(player[i]->racket);
   }
   
   //on update/bouge les tincelles
   for (i = 0; i < NB_MAX_SPARKS; ++i) {
      if (spark[i].EXIST == TRUE)
         move_spark(&spark[i]);
   }



   /* On s'occupe des effets spciaux -> LA BALLE */
   if (ABS(ball[0]->speed.x) == game.cur_level->max_ball_speed.x) {
      ball[0]->bitmap = (BITMAP*)(data_sprite[BALL_RED_BMP].dat);
   }
   else {
      ball[0]->bitmap = (BITMAP*)(data_sprite[BALL_BMP].dat);
   }
   
   //On bouge les toiles
   
   for (i = 0; i < stars.nb_stars; ++i) {
      stars.star[i].z -= stars.star_speed;
      if (stars.star[i].z <= 0.0 || stars.star[i].x/stars.star[i].z + SCREEN_W/2 < 0 || stars.star[i].x/stars.star[i].z + SCREEN_W/2 >= SCREEN_W || stars.star[i].y/stars.star[i].z + SCREEN_H/2 < 0 || stars.star[i].y/stars.star[i].z + SCREEN_H/2 >= SCREEN_H) {
         stars.star[i].x = (rand() % STAR_START_RADIUS_X)-STAR_START_RADIUS_X/2;
         stars.star[i].y = (rand() % STAR_START_RADIUS_Y)-STAR_START_RADIUS_Y/2;
         stars.star[i].z = (rand() % (STAR_START_Z));
      }
   }
   //vitesse des toiles proportionelle  la vitesse de la balle:
   stars.star_speed = sqrt(ball[0]->speed.x*ball[0]->speed.x + ball[0]->speed.y*ball[0]->speed.y) * FACTOR_SPEED_STAR;
     
   //Si il n'y a plus aucune balle!
   if (nb_current_balls <= 0) {

      //on update le score
      game_info.last_score = current_score;

      if (game_type == DUEL && (game_info.new_hiscore_pos = check_scores(game.cur_level->high_score.high_score_entry, SIZE_HIGH_SCORE_TABLE, game_info.last_score)) != -1) {

         /* On change de section! */
         game_state = ASKING_PLAYER_NAME;

         /* Un petit son pour le high score! */
         play_sound(data_sfx[NEWRECORD_WAV].dat, SCREEN_W/2);

         //J'ai repris le systme de hiscore d'un autre jeu ( moi...)
         //Je l'ai un peu adapt.
         //Tout d'abord, on update le score mais on laisse un nom vide
         update_scores(game.cur_level->high_score.high_score_entry, SIZE_HIGH_SCORE_TABLE, "", game_info.last_score);

         //Ensuite, on s'occupe de demander le nom du joueur
         name = malloc((MAX_NAME_LENGTH+1)*sizeof(char));         
         get_player_name(name, game_info.last_score);

         //enfin, on "update" le nom dans le tableau!         
         change_score_name(game.cur_level->high_score.high_score_entry, name, game_info.new_hiscore_pos);
         free(name);
         
         packfile_password("temp");
         //au sauvegarde le fichier final, au cas ou il y ait un problme par la suite:
         save_scores(game.cur_level->high_score.high_score_entry, game.cur_level->high_score.path_name, game.cur_level->high_score.nb_high_score_entries);

         packfile_password(NULL);
         
         /* On retourne au Jeu! */
         game_state = PLAYING_THE_GAME;
      }
      else 
         play_sound(data_sfx[MATCHOVER_WAV].dat, SCREEN_W/2);
      
      
      //ON RECOMMENCE A JOUER TOUT DE SUITE
      //cas spcial pour la numro 0!
      init_new_ball(ball[0]);
      nb_current_balls = 1;
      
      game_time = 0;
      current_score = 0;      
   }

   return;
}