#include <allegro.h>
#include <string.h>
#include <aldumb.h>
#include "main.hpp"

#include "game.hpp"

int frames;
int fps;
BITMAP *page;
volatile int done = 0;

static volatile int ticks = 0;
static void
ticker ()
{
  ticks++;
}

static void
run_init ()
{
  engine.init ();
}

static void
run_end ()
{
  engine.done ();
  done = 1;
}

static void
run_frame ()
{
  while (keypressed ())
  {
    int k = readkey ();

    k >>= 8;
    if (k == KEY_ESC)
      run_end ();
  }

  engine.run ();

}

static void
run_render ()
{
  engine.draw (page);

  //textprintf_right_ex (page, font, SCREEN_W, 0, -1, -1,  "%d fps", fps);
}

static int
scan_arg (int argc, char *argv[], const char *arg, int def)
{
  int i;

  for (i = 1; i < argc; i++)
  {
    if (!strcmp (argv[i], arg))
    {
      i++;
      if (i < argc)
      {
        return strtol (argv[i], NULL, 0);
      }
    }
  }
  return def;
}

int
main (int argc, char *argv[])
{
  BITMAP *vpage[3];
  int pagenum = 0;
  int cd = 8;
  int vpages = 2;
  int f = 1;
  int gframes;
  int framecounttime, framecounter;
  DATAFILE *datob;
  AL_DUH_PLAYER *musicplayer;
  DUMBFILE *dumb;
  DUH *duh;

  allegro_init ();

  set_color_depth (cd);

  f = scan_arg (argc, argv, "-f", f);

  if (set_gfx_mode
      (f ? GFX_AUTODETECT : GFX_AUTODETECT_WINDOWED, 320, 240, 0, 0) < 0)
  {
    allegro_message ("Cannot set graphics mode.\n");
    exit (-1);
  }

  install_keyboard ();

  install_mouse ();

  install_timer ();

  install_int_ex (ticker, BPS_TO_TIMER (FPS));

  atexit(&dumb_exit);
  
  
  datob = load_datafile_object ("dat.dat", "tom.xm");
  if (!datob)
  {
    allegro_message ("Failed loading data.\n");
    exit (-1);
  }
  dumb = dumbfile_open_memory((const char *)datob->dat, datob->size);
  duh = dumb_read_xm(dumb);
  set_volume_per_voice(0);
  install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);

  musicplayer = al_start_duh(duh, 2, 0, (double)1, 4096, 44100);

  vpages = scan_arg (argc, argv, "-p", vpages);

  if (vpages == 0)
  {
    vpage[0] = create_bitmap (SCREEN_W, SCREEN_H);
    pagenum = 0;
  }
  if (vpages == 1)
  {
    vpage[0] = screen;
    pagenum = 0;
  }
  if (vpages == 2)
  {
    vpage[0] = create_video_bitmap (SCREEN_W, SCREEN_H);
    if (vpage[0])
    {
      vpage[1] = create_video_bitmap (SCREEN_W, SCREEN_H);
      pagenum = 1;
    }
    if (!vpage[0] || !vpage[1])
    {
      vpage[0] = create_bitmap (SCREEN_W, SCREEN_H);
      pagenum = 0;
      vpages = 0;
    }
  }
  if (vpages == 3)
  {
    vpage[0] = create_video_bitmap (SCREEN_W, SCREEN_H);
    vpage[1] = create_video_bitmap (SCREEN_W, SCREEN_H);
    vpage[2] = create_video_bitmap (SCREEN_W, SCREEN_H);
    pagenum = 2;
  }

  page = vpage[pagenum];

  {
    int i;
    for (i = 0; i <= pagenum; i++)
    {
      if (!vpage[i])
      {
        allegro_message ("Cannot allocate video buffers.\n");
        exit (-1);
      }
    }
  }

  run_init ();

  engine.recording = scan_arg (argc, argv, "-r", 0);

  framecounter = 0;
  framecounttime = ticks;
  gframes = ticks;
  frames = ticks;
  while (!done)
  {
    while (frames <= ticks)
    {
      run_frame ();
      frames++;
    }
    if (gframes < frames)
    {
      run_render ();
      al_poll_duh(musicplayer);

      if (vpages == 0)
      {
        blit (page, screen, 0, 0, 0, 0, page->w, page->h);
      }
      if (vpages == 2)
      {
        show_video_bitmap (page);
        pagenum++;
        if (pagenum == vpages)
          pagenum = 0;
        page = vpage[pagenum];
      }
      if (vpages == 3)
      {
        while (poll_scroll ()); /* in case not done with previous flip */
        request_video_bitmap (page);
        pagenum++;
        if (pagenum == vpages)
          pagenum = 0;
        page = vpage[pagenum];
      }

      gframes = frames;
      framecounter++;

      if (ticks - framecounttime >= FPS)
      {
        fps = framecounter;
        framecounter = 0;
        framecounttime = ticks;
      }
    }
  }
  al_stop_duh(musicplayer);
  unload_duh (duh);
  dumbfile_close (dumb);
  unload_datafile_object (datob);
  run_end ();
  return 0;
}

END_OF_MAIN ();
