#include <allegro.h>

class Bug
{
public:
  int x, y;                     /* pixel position */
  int type;                     /* type of bug */
   
int step, dir, dead;        /* status of bug */

  void move (int dx, int dy);
};

class Map
{
public:
  BITMAP * tiles[18];           /* the tiles gfx */
  BITMAP *sprites[96];          /* the sprites gfx */
  BITMAP *tiles_tainted[18];    /* under-water tiles */
  BITMAP *sprites_tainted[96];  /* under-water sprites */

  int inum (BITMAP * m, int x, int y, int m1);

  BITMAP *map;                  /* tile numbers */
  int w, h;

  int finishline;               /* height of finish line */
  int waterlevel;               /* initial waterlevel */
  int scrollx, scrolly;         /* scroll position */

  void load (int level, Bug bug[256], int &bugnum);
  void init ();
};

class Engine
{
public:
  BITMAP *playbackpic;         /* message displayed during playback */
  BITMAP *gameoverpic;          /* message displayed for game over */
  BITMAP *youwinpic;            /* message displayed when game is won */

  BITMAP *titlepic;             /* title screen */
  BITMAP *betweenpic;           /* displayed between levels */

  BITMAP *lifepic;
  BITMAP *fuelpic;

  PACKFILE *record;

  int ticks;                    /* the game time, in game ticks */

  int betweenlevel;             /* counter starts when level is finished */
  int finished;                 /* counter starts when finishline is reached */
  int idle;                     /* counter for idle time */
  int level;                    /* current level number */
  int title;                    /* title screen is displayed */
  int youwin;                   /* you-win screen is displayed */

  int cheatmode;

  int view_w, view_h;

  int slowcontrol_right;
  int slowcontrol_left;
  int slowcontrol_jump;
  int slowcontrol_fire;

  int jump;                     /* player jumps */
  int ground;                   /* player is on ground */
  int firing;                   /* player is firing */
  int playback;                 /* playback mode is active */
  int recording;                /* recording mode is active */
  int tries;                    /* used for recording/playback */
  int fuel;                     /* fuel for player */
  int lifes;                    /* extra lifes */
  SAMPLE *cry;                  /* player is crying */

  Map map;                      /* the current map */

  int bugnum;                   /* number of active 'bugs' */
  Bug bug[256];                 /* the bugs */

  void move (int n, int dx, int dy);
  int collision (int cx, int cy);

  void draw_sprites (BITMAP * to, BITMAP ** sprites);
  void draw_tiles (BITMAP * to, BITMAP ** tiles);
  void draw (BITMAP * to, int n, int x0, int y0, int a, int m,
             BITMAP ** spriteslist);
  void draw (BITMAP * to);
  void newlevel ();
  void leveldone ();
  void newgame ();
  void init ();
  void done ();
  void run ();
  void ohno ();
};

extern Engine engine;
