#include <stdio.h>
#include <math.h>
#include "main.hpp"
#include "game.hpp"

Engine engine;

COLOR_MAP colormap;
RGB_MAP rgbmap;

#define L 10

/* Auto compute edge tiles */
int
Map::inum (BITMAP * m, int x, int y, int m1)
{
  int i, j;
  int b = 1;
  int n = 0;
  for (i = -2; i <= 2; i++)
  {
    for (j = -2; j <= 2; j++)
    {
      //if (x + j < 0 || x + j >= 32 || y + i < 0 || y + i >= 48
      if (getpixel (m, x + j, 96 + y + i) == m1)
      {
        n |= b;
      }
      b *= 2;
    }
  }
  if ((n & 0x000739c0) == 0x000739c0)
    return 13;
  if ((n & 0x00e73800) == 0x00e73800)
    return 10;
  if ((n & 0x000e7380) == 0x000e7380)
    return 12;
  if ((n & 0x000398e0) == 0x000398e0)
    return 14;
  if ((n & 0x000039ce) == 0x000039ce)
    return 16;
  if ((n & 0x01ce7000) == 0x01ce7000)
    return 9;
  if ((n & 0x00739c00) == 0x00739c00)
    return 11;
  if ((n & 0x0000739c) == 0x0000739c)
    return 15;
  if ((n & 0x00001ce7) == 0x00001ce7)
    return 17;
  return 4;
}

void
Map::init ()
{
  map = create_bitmap (32, 48);
  for (int i = 0; i < 18; i++)
  {
    tiles[i] = create_bitmap (16, 16);
    tiles_tainted[i] = create_bitmap (16, 16);
  }
  for (int i = 0; i < 96; i++)
  {
    sprites[i] = create_bitmap (32, 32);
    sprites_tainted[i] = create_bitmap (32, 32);
  }
}

/* Load a map */
void
Map::load (int level, Bug bug[256], int &bugnum)
{
  int mx, my;
  BITMAP *xpm, *spm;
  int i;
  int m0, m1, m2, m3, m4, m5, m6, m7, m8;
  char str[256];

  finishline = 256 * 3;
  waterlevel = 256 * 3;

  scrollx = 128;
  scrolly = 256 * 3 - 192;

  bugnum = 1;
  bug[0].x = 256 - 32 / 2;
  bug[0].y = 256 * 3 - 32 - 16;
  bug[0].step = 0;
  bug[0].dir = 0;
  bug[0].dead = 0;
  bug[0].type = 0;

  sprintf (str, "level%d.bmp", level);
  printf ("Loading level %s.\n", str);
  xpm = load_bitmap (str, NULL);
  if (!xpm)
    printf ("Failed!\n");

  for (i = 0; i < 18; i++)
  {
    int x = (i % 3) * 16;
    int y = (i / 3) * 16;
    blit (xpm, tiles[i], x, y, 0, 0, 16, 16);
    clear_to_color (tiles_tainted[i], bitmap_mask_color (tiles_tainted[i]));
    draw_lit_sprite (tiles_tainted[i], tiles[i], 0, 0, 128);
  }

  sprintf (str, "sprites.tga");
  printf ("Loading sprites %s.\n", str);

  set_color_conversion (COLORCONV_NONE);
  spm = load_bitmap (str, NULL);
  set_color_conversion (COLORCONV_TOTAL | COLORCONV_KEEP_TRANS |
                        COLORCONV_DITHER);
  if (!spm)
    printf ("Failed!\n");

  for (i = 0; i < 96; i++)
  {
    int x = (i & 7) * 32;
    int y = (i / 8) * 32;
    blit (spm, sprites[i], x, y, 0, 0, 32, 32);
    clear_to_color (sprites_tainted[i],
                    bitmap_mask_color (sprites_tainted[i]));
    draw_lit_sprite (sprites_tainted[i], sprites[i], 0, 0, 128);
  }

  destroy_bitmap (spm);

  m0 = getpixel (xpm, 47, 143);
  m1 = getpixel (xpm, 46, 143);
  m2 = getpixel (xpm, 45, 143); /* bug bite-a-lot */
  m3 = getpixel (xpm, 44, 143);
  m4 = getpixel (xpm, 43, 143);
  m5 = getpixel (xpm, 42, 143); /* bear theodor */
  m6 = getpixel (xpm, 41, 143);
  m7 = getpixel (xpm, 40, 143); /* duckling tom */
  m8 = getpixel (xpm, 39, 143); /* bird rupert */

  for (i = 0; i < 48; i++)
  {
    if (getpixel (xpm, 32, 143 - i) == m2)
    {
      waterlevel = 256 * 3 + i * 16;
    }
  }

  h = 768;
  w = 512;

  for (my = 0; my < h; my++)
  {
    for (mx = 0; mx < w; mx++)
    {
      int j;
      int col = 0;
      i = (my & 15);
      j = (mx & 15);
      int p;

      if (i == 0 && j == 0)
      {
        p = getpixel (xpm, mx >> 4, 96 + (my >> 4));
        if (p == m1 || p == m4)
        {
          p = inum (xpm, mx >> 4, my >> 4, p);
          if (my < finishline)
            finishline = my;
        }
        else if (p == m0)
        {
          p = 0;
        }
        else if (p == m3)
        {
          p = 2;
        }
        else if (p == m6)
        {
          p = 6 + ((mx >> 4) % 3);
        }
        else if (p == m2 || p == m5 || p == m7 || p == m8)
        {
          bug[bugnum].x = mx;
          bug[bugnum].y = my;
          bug[bugnum].step = 0;
          bug[bugnum].dir = 0;
          bug[bugnum].dead = 0;
          bug[bugnum].type = p == m2 ? 1 : p == m7 ? 3 : p == m8 ? 4 : 2;
          if (bugnum < 256)
            bugnum++;
          p = 0;
        }
        putpixel (map, mx >> 4, my >> 4, p);
      }
      p = getpixel (map, mx >> 4, my >> 4);
      j += (p % 3) * 16;
      i += (p / 3) * 16;
      col = getpixel (xpm, j, i);

      //putpixel (background, mx, my, col);
      //__make_walkthrough_plot (mx, my, getr (timepal[col]), getg (timepal[col]), getb (timepal[col]));
    }
  }

  destroy_bitmap (xpm);

  //save_bitmap ("tmp.bmp", background, pal);

  //__make_walkthrough_sprites ();
  //__make_walkthrough_dump ();
}

void
allegro_check_keys ()
{
  if (key[KEY_LEFT])
  {
    engine.slowcontrol_left = 8;
  }
  if (key[KEY_RIGHT])
  {
    engine.slowcontrol_right = 8;
  }
  if (key[KEY_UP])
  {
    engine.slowcontrol_jump = 8;
  }
  if (key[KEY_DOWN])
  {
    engine.slowcontrol_fire = 8;
  }
}

/* Draw a sprite */
void
Engine::draw (BITMAP * to, int t, int x, int y, int a, int m,
              BITMAP ** spriteslist)
{
  (m ? draw_sprite_h_flip : draw_sprite) (to, spriteslist[t * 16 + a], x, y);
}


/* Move a sprite */
void
Bug::move (int dx, int dy)
{
  if (dx == -1)
  {
    if (x > 0)
    {
      x--;
    }
    step++;
    dir = 1;
  }
  if (dx == 1)
  {
    if (x + 32 < engine.map.w)
    {
      x++;
    }
    step++;
    dir = 0;
  }
  if (dy == -1)
  {
    if (y > 0)
      y--;
  }
  if (dy == 1)
  {
    if (y + 32 < engine.map.h)
      y++;
  }

  step &= 15;
}

#define SCROLL 96
void
Engine::move (int n, int dx, int dy)
{
  bug[n].move (dx, dy);

  if (n == 0)
  {
    if (bug[0].x - map.scrollx < SCROLL)
      map.scrollx = bug[0].x - SCROLL;
    if (bug[0].y - map.scrolly < SCROLL)
      map.scrolly = bug[0].y - SCROLL;
    if (bug[0].x - map.scrollx > view_w - SCROLL - 32)
      map.scrollx = bug[0].x - view_w + SCROLL + 32;
    if (bug[0].y - map.scrolly > view_h - SCROLL - 32)
      map.scrolly = bug[0].y - view_h + SCROLL + 32;

    if (map.scrollx < 3)
      map.scrollx = 3;
    if (map.scrolly < 0)
      map.scrolly = 0;
    if (map.scrollx > map.w - view_w - 4)
      map.scrollx = map.w - view_w - 3;
    if (map.scrolly > map.h - view_h)
      map.scrolly = map.h - view_h;

    //map.scroll (scrollx, scrolly);
  }
}

/* Check for collision */
int
Engine::collision (int cx, int cy)
{
  int i;
  for (i = 1; i < bugnum; i++)
  {
    if (cx + 23 >= bug[i].x + 8 &&
        cy + 31 >= bug[i].y + 8 && cx + 8 <= bug[i].x + 23
        && cy + 8 <= bug[i].y + 31)
    {
      return i;
    }
  }
  return 0;
}

void
Engine::ohno ()
{
  play_sample (cry, 255, 128, 1000, 0);

  bug[0].dead = FPS * 5;
  lifes--;
}

void
Engine::run ()
{
  allegro_check_keys ();

  if (slowcontrol_right)
    slowcontrol_right--;
  if (slowcontrol_left)
    slowcontrol_left--;
  if (slowcontrol_jump)
    slowcontrol_jump--;
  if (slowcontrol_fire)
    slowcontrol_fire--;

  if (title)
  {
    title--;
    if (title == 0)
    {
      char str[1024];

      playback = 1;
      for (level = 1; level <= L; level++)
      {
	/* Use first found recording */
        uszprintf (str, 1024, "level%d.recording", level);
        record = pack_fopen (str, "r!");
        if (record)
          break;
      }
      if (level > L)
      {
        level = 1;
        playback = 0;
      }
      betweenlevel = FPS * 5;
    }
    else if (title < FPS * 4 && (slowcontrol_right || slowcontrol_left ||
                                 slowcontrol_jump || slowcontrol_fire))
    {
      title = 0;
      level = 1;
      playback = 0;
      betweenlevel = FPS * 5;
    }
  }
  else if (youwin)
  {
    youwin--;
    if (youwin < FPS * 8 && (slowcontrol_right || slowcontrol_left ||
                             slowcontrol_jump || slowcontrol_fire))
    {
      youwin = 0;
    }
    if (youwin == 0)
      newgame ();
  }
  else if (betweenlevel)
  {
    static int cheat = 0;
    if (cheat == 4 && key[KEY_V])
    {
      level++;
      play_sample (cry, 255, 128, 1000, 0);
      betweenlevel = FPS * 5;
      cheat = 0;
    }
    if (cheat == 3 && key[KEY_E])
    {
      cheat++;
    }
    if (cheat == 2 && key[KEY_L])
    {
      cheat++;
    }
    if (cheat == 1 && key[KEY_D])
    {
      cheat++;
    }
    if (cheat == 0 && key[KEY_I])
    {
      cheat++;
    }
    betweenlevel--;
    if (betweenlevel < FPS * 4 && (slowcontrol_right || slowcontrol_left ||
                                   slowcontrol_jump || slowcontrol_fire))
    {
      if (playback)
      {
        playback = 0;
        newgame ();
        return;
      }
      betweenlevel = 0;
    }
    if (betweenlevel == 0)
    {
      newlevel ();
    }
  }
  else
  {
    if (recording)
    {
      int k = 0;
      k += slowcontrol_left ? 1 : 0;
      k += slowcontrol_right ? 2 : 0;
      k += slowcontrol_jump ? 4 : 0;
      k += slowcontrol_fire ? 8 : 0;
      pack_putc (k, record);
    }

    if (playback)
    {
      int k = pack_getc (record);
      if (slowcontrol_right || slowcontrol_left ||
          slowcontrol_jump || slowcontrol_fire)
      {
        leveldone ();
        return;
      }

      if (pack_feof (record))
      {
        leveldone ();
        return;
      }
      slowcontrol_left = k & 1 ? 1 : 0;
      slowcontrol_right = k & 2 ? 1 : 0;
      slowcontrol_jump = k & 4 ? 1 : 0;
      slowcontrol_fire = k & 8 ? 1 : 0;
    }

    {
      if (idle > FPS * 30)
      {
        ohno ();
        idle = 0;
      }
      if (bug[0].dead)
      {
        slowcontrol_right = 0;
        slowcontrol_left = 0;
        slowcontrol_jump = 0;
        slowcontrol_fire = 0;
      }

      if (!jump && ground)
      {
        if (slowcontrol_jump)
        {
          jump = 16 * 4;
        }
      }

      if (jump)
      {
        int ox, oy;
        ground = 0;
        jump--;
        ox = bug[0].x;
        oy = bug[0].y;
        move (0, 0, -1);
        if (ox == bug[0].x && oy == bug[0].y)
        {
          jump = 0;
        }

        if (slowcontrol_jump == 0)
        {
          jump = 0;
        }
      }
      else
      {
        int ox, oy;
        int mx, my;
        ox = bug[0].x;
        oy = bug[0].y;
        ground = 0;
        move (0, 0, 1);
        if (ox != bug[0].x || oy != bug[0].y)
        {
          if (((bug[0].y + 31) & 15) == 0)
          {
            int m;
            mx = (bug[0].x + 16) >> 4;
            my = (bug[0].y + 31) >> 4;
            m = getpixel (map.map, mx, my);
            if ((m >= 9 && m <= 11) || m == 4)
            {
              move (0, 0, -1);
              ground = 1;
            }
          }
        }
        else
        {
          ground = 1;
        }
      }

      if (slowcontrol_right)
      {
        move (0, 1, 0);
      }
      if (slowcontrol_left)
      {
        move (0, -1, 0);
      }

      if (slowcontrol_right == 0 && slowcontrol_left == 0
          && slowcontrol_jump == 0 && slowcontrol_fire == 0)
      {
        bug[0].step = 0;
        idle++;
      }
      else
      {
        idle = 0;
      }

      if (bugnum > 1)
      {
        int i;
        for (i = 1; i < bugnum; i++)
        {
          int ox = bug[i].x;
          int oy = bug[i].y;
          if (bug[i].dead)
          {
            move (i, 0, 1);
          }
          else
          {
            if (bug[i].step >= 16)
            {
              bug[i].step--;
            }
            else
            {
              if (bug[i].type == 4)
              {
                move (i, 0, bug[i].dir ? -1 : 1);
              }
              else
              {
                move (i, bug[i].dir ? -1 : 1, 0);
              }

              if (bug[i].type != 1 && bug[i].type != 4)
              {
                int m, mx, my;
                mx = (bug[i].x + 16) >> 4;
                my = (bug[i].y + 32) >> 4;
                m = getpixel (map.map, mx, my);
                if (!((m >= 9 && m <= 11) || m == 4))
                {
                  bug[i].x = ox;
                  bug[i].y = oy;
                }
              }

              if (bug[i].type == 4)
              {
                int m, mx, my;
                mx = (bug[i].x + 16) >> 4;
                my = (bug[i].y + 31) >> 4;
                m = getpixel (map.map, mx, my);
                if ((m >= 9 && m <= 11) || m == 4)
                {
                  bug[i].x = ox;
                  bug[i].y = oy;
                }
              }

              if (ox == bug[i].x && oy == bug[i].y)
              {
                bug[i].dir = !bug[i].dir;
              }

              bug[i].step++;
              bug[i].step &= 15;
            }
          }
        }
      }

      if (!bug[0].dead)
      {
        int c;

        if (slowcontrol_fire)
        {
          if (fuel)
            firing = 1;
        }
        else
        {
          if (firing)
            firing--;
        }

        c = collision (bug[0].x, bug[0].y);
        if (c && bug[c].dead == 0)
        {
          if (fuel && slowcontrol_fire && bug[0].y + 16 < bug[c].y)
          {
            fuel--;
            bug[c].dead = 1;
            firing = 7;
          }
          else
          {
            bug[c].step = 22;
            ohno ();
          }
        }
        if (bug[0].y > map.waterlevel)
        {
          ohno ();
        }
      }
      else
      {
        bug[0].dead--;
        if (bug[0].dead == 0)
        {
	  tries++;
          leveldone ();
          if (!lifes)
            newgame ();
        }
      }

      if (bug[0].y + 31 < map.finishline && finished == 0)
      {
        finished = FPS * 5;
        level++;
	tries = 0;
        if (fuel < 4)
          fuel++;
        if (lifes < 9)
          lifes++;
      }

      if (!playback && finished)
      {
        finished--;
        if (finished == 0)
        {
          leveldone ();
        }
      }
    }
    if ((frames & 7) == 0)
    {
      if (map.waterlevel > map.finishline)
        map.waterlevel--;
    }
  }
}

void
Engine::draw_tiles (BITMAP * to, BITMAP ** tiles)
{
  int tile_x, tile_y;
  int screen_x, screen_y;
  tile_x = map.scrollx >> 4;
  tile_y = map.scrolly >> 4;
  screen_x = -(map.scrollx & 15);
  screen_y = -(map.scrolly & 15);

  while (screen_y < view_h)
  {
    int screen_x_run = screen_x;
    int tile_x_run = tile_x;
    while (screen_x_run < view_w)
    {
      if (tile_y >= 0 && tile_x_run >= 0 && tile_y < map.map->h
          && tile_x_run < map.map->w)
      {
        unsigned char t =
          *((unsigned char *) map.map->line[tile_y] + tile_x_run);
        blit (tiles[t], to, 0, 0, screen_x_run, screen_y, 16, 16);
      }

      tile_x_run++;
      screen_x_run += 16;
    }
    tile_y++;
    screen_y += 16;
  }
}

void
Engine::draw_sprites (BITMAP * to, BITMAP ** spriteslist)
{
  if (bugnum > 1)
  {
    int i;
    for (i = 1; i < bugnum; i++)
    {
      if (bug[i].dead)
      {
        draw (to, bug[i].type, bug[i].x - map.scrollx, bug[i].y - map.scrolly,
              9, bug[i].dir, spriteslist);
      }
      else
      {
        if (bug[i].step >= 16)
        {
          draw (to, bug[i].type, bug[i].x - map.scrollx,
                bug[i].y - map.scrolly, 8, bug[i].dir, spriteslist);
        }
        else
        {
          draw (to, bug[i].type, bug[i].x - map.scrollx,
                bug[i].y - map.scrolly, bug[i].step / 2, bug[i].dir,
                spriteslist);
        }
      }
    }
  }
  draw (to, 0, bug[0].x - map.scrollx, bug[0].y - map.scrolly,
        bug[0].dead ? 9 : firing ? 10 : jump ? 8 : bug[0].step / 2,
        bug[0].dir, spriteslist);
}

void
Engine::draw (BITMAP * to)
{
  if (title)
  {
    blit (titlepic, to, 0, 0, 0, 0, 320, 240);
  }
  else if (youwin)
  {
    blit (youwinpic, to, 0, 0, 0, 0, 320, 240);
  }
  else if (betweenlevel)
  {
    blit (betweenpic, to, 0, 0, 0, 0, 320, 240);
  }
  else
  {
    int i;
    //blit (map.background, to, map.scrollx, map.scrolly, 0, 0, 320, 240);

    set_clip (to, 0, 0, to->w - 1,
              MIN (to->h - 1, map.waterlevel - map.scrolly - 1));
    draw_tiles (to, map.tiles);
    draw_sprites (to, map.sprites);
    if (map.waterlevel - map.scrolly < to->h)
    {
      set_clip (to, 0, map.waterlevel - map.scrolly, to->w - 1, to->h);
      draw_tiles (to, map.tiles_tainted);
      draw_sprites (to, map.sprites_tainted);
    }
    set_clip (to, 0, 0, to->w - 1, to->h - 1);

    for (i = 0; i < lifes - 1; i++)
      draw_sprite (to, lifepic, i * lifepic->w, to->h - lifepic->h);

    for (i = 0; i < fuel; i++)
      draw_sprite (to, fuelpic, to->w - (1 + i) * fuelpic->w,
                   to->h - fuelpic->h);

    for (; i < fuel; i++)
      draw_sprite (to, map.sprites[10], i * map.sprites[10]->w,
                   to->h - map.sprites[10]->h);

    if (playback)
    {
      if (frames / 30 & 1)
        draw_sprite (to, playbackpic, (to->w - playbackpic->w) / 2,
                     (to->h - playbackpic->h) / 2);
    }
    if (recording)
    {
      if (frames / 30 & 1)
      {
	text_mode (-1);
        textprintf_centre (to, font, to->w / 2, to->h - text_height (font),
                              makecol (255, 0, 0), "R");
      }
    }
  }
  {
    static int i = 0, c;
    static int rainx[64];
    static int rainy[64];
    if (!i)
    {
      c = makecol (0, 0, 255);
      for (i = 0; i < 64; i++)
      {
        rainx[i] = rand() % 320;
	rainy[i] = rand() % 240;
      }
    }
    for (i = 0; i < 64; i++)
    {
      putpixel (to, rainx[i] - map.scrollx, rainy[i] - map.scrolly, c);
      rainy[i] += 2;
      rainx[i] += 1;
      if (rainy[i] - map.scrolly >= 240 || rainx[i] - map.scrollx >= 320)
      {
	int r = rand() % (320 + 240);
	if (r < 320)
	{
          rainx[i] = r;
	  rainy[i] = 0;
	}
        else
	{
	  rainx[i] = 0;
	  rainy[i] = r - 240;
	}
	rainx[i] += map.scrollx;
	rainy[i] += map.scrolly;
      }    
    }
  }
}

void
Engine::newgame ()
{
  title = FPS * 5;
  youwin = 0;
  lifes = 3;
  fuel = 0;
  tries = 0;
}

void
Engine::newlevel ()
{
  finished = 0;
  firing = 0;
  idle = 0;
  jump = 0;
  ground = 0;

  if (level <= L)
  {
    if (playback)
      recording = 0;

    if (playback)
    {
      char str[1024];
      char tstr[10] = " ";
      tstr[0] = 'a' + tries - 1;
      uszprintf (str, 1024, "level%d%s.recording", level, tries ? tstr : "");
      record = pack_fopen (str, "rp");
      if (!record)
      {
        playback = 0;
	level = 1;
      }
      else
      {
	if (lifes < 2)
	  lifes = 2;
	printf ("Playing %s.\n", str);
      }
    }
    if (recording)
    {
      char str[1024];
      int i;
      /* find unused name */
      for (i = 'a' - 1; i <= 'z' ; i++)
      {
        char tstr[10] = " ";
        tstr[0] = i;
        level = recording;
        uszprintf (str, 1024, "level%d%s.recording", level, i >= 'a' ? tstr : "");
	if (!exists (str))
	  break;
      }
      if (i <= 'z')
      {
        record = pack_fopen (str, "w!");
        if (!record)
	{
          recording = 0;
	  level = 1;
	}
        else
	  printf ("Recording %s.\n", str);
      }
      else
      {
	recording = 0;
	level = 1;
      }
    }

    map.load (level, bug, bugnum);
  }
  else
  {
    youwin = FPS * 10;
  }
}

void
Engine::leveldone ()
{
  if (playback || recording)
  {
    pack_fclose (record);
  }
  betweenlevel = FPS * 5;
  printf ("Level done.\n");
}

BITMAP *
loadpic (char const *name)
{
  return (BITMAP *) load_datafile_object ("dat.dat", name)->dat;
}

void
Engine::init ()
{
  PALETTE pal;
  view_w = 320;
  view_h = 240;

  record = NULL;

  set_color_conversion (COLORCONV_TOTAL | COLORCONV_KEEP_TRANS |
                        COLORCONV_DITHER);

  {
    DATAFILE *paldat;
    PALETTE *p;
    paldat = load_datafile_object ("dat.dat", "000_PAL.bmp");
    p = (PALETTE *) paldat->dat;
    set_palette (*p);
    unload_datafile_object (paldat);
  }

  get_palette (pal);

  rgb_map = &rgbmap;
  color_map = &colormap;
  create_rgb_table (rgb_map, pal, NULL);
  create_light_table (color_map, pal, 0, 0, 0, NULL);

  betweenpic = load_bitmap ("dat.dat#between.bmp", NULL);
  titlepic = load_bitmap ("dat.dat#title.bmp", NULL);
  playbackpic = load_bitmap ("dat.dat#playback.bmp", NULL);
  gameoverpic = load_bitmap ("dat.dat#gameover.bmp", NULL);
  youwinpic = load_bitmap ("dat.dat#youwin.bmp", NULL);

  lifepic = load_bitmap ("dat.dat#life.bmp", NULL);
  fuelpic = load_bitmap ("dat.dat#fuel.bmp", NULL);

  cry = load_sample ("dat.dat#cry.wav");
  
  map.init ();

  newgame ();
}

void
Engine::done ()
{

}
