/**
Main game control scheme
*/

#include <allegro.h>
#include <alleggl.h>
#include <math.h>
#include "init.h"
#include "debug.h"
#include "level.h"
#include <aldumb.h>
#include "widget.h"
#include <time.h>


void Setup();

int main()
{
	DUH *background = 0;
	AL_DUH_PLAYER *dp = 0;

	try
	{
		Setup();
        srand(time(NULL));
        set_config_file("virus.cfg");
		int  menu = Menu(false);
		bool quit = menu==0;

		Level test("data/level.txt");

		if (!quit) {
			background = dumb_load_it("data/clouds.it");
			if (!background) throw "Can't load clouds.it";
			dp = al_start_duh(background, 2, 0, get_config_int("config", "Music", 0)/10.0f, 4096, 22050);
			if (!dp) throw "Can't load dp";

			test.LoadNextMap(false);
		}

		int currentLevel = get_config_int("config", "Level", 0);
		while (currentLevel-->0)
			test.LoadNextMap(false);	// skip ahead to the last level played



		logic = 0;

		while (!quit)
		{
			poll_keyboard();
			if (key[KEY_ESC]) {
				al_pause_duh(dp);
				while (key[KEY_ESC]) poll_keyboard();
				int m = Menu(true);
				if( m==0 ) break;
				al_duh_set_volume(dp, get_config_int("config", "music", 0)/10.0f);
				if (m==-1) test.LoadNextMap(-1);
				logic = 0;
				al_resume_duh(dp);
			}
			// "game logic"
			while (logic>0)
			{
				static int counter = 0;
				if (!(counter++%5)) al_poll_duh(dp);
				// Logic goes here:
				test.SpreadVirus();
				test.HandleObjects();
				test.HandleInput();

				// Logic maintanence code:
				logic-=1; // one less frame of logic needs to be done before drawing our screen
				if (logic>10) {logic = 0; break;}	// in times of extreme slowness, don't bother with the logic.
			}

			// Rendering goes here
			glLoadIdentity();
			test.Draw();

			// flip backbuffer, clear backbuffer
			glFlush();
			allegro_gl_flip();
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			glClearColor(0,0,0,0);

			// handle frame_count
			if (frame_count<1)
			{
				DEBUGOUT( "Framerate count = " << fps );
			}
			frame_count++;
		}
	}
	catch( const char * const ErrorMessage )
	{
		al_stop_duh(dp);
		dp = NULL;
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message(ErrorMessage);
	}
	al_stop_duh(dp);
	unload_duh(background);
	return 0;
}
END_OF_MAIN();

void Setup()
{
	if (!InitStandardAGL()) throw "Failed to initialize basic features of allegro / allegrogl";
	install_sound(DIGI_AUTODETECT, MIDI_NONE, 0);

	if (!InitFog(50.0f, 150.0f, 0.02f)) throw "Failed to initialize fog";

	allegro_gl_set_texture_format(GL_RGBA8);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);

	atexit(&dumb_exit);
	dumb_register_stdfiles();


	// Set up the view
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(-.25, .25, -.25, .25, .5, 100.0);
	glMatrixMode(GL_MODELVIEW);
}
