/**
Helper files deal with underlying system -- initialization of OpenGL, timers, etc.
*/

#ifndef _INIT_H_
#define _INIT_H_

#include <GL/gl.h>

extern volatile int fps;
extern volatile int frame_count;
extern volatile int logic;

// note: some of these boolean functions only return true.
// They return bool instead of void on the basis that you may modify them,
// and they may, eventually, return bool

bool InitSimpleAGL();
bool InitStandardAllegro();
bool InitTimers();
bool InitStandardAGL();

bool InitLighting(GLfloat *LightAmbient, 
						GLfloat *LightDiffuse, 
						GLfloat *LightPosition);
bool InitFog(float start, float end, float density);

#endif
