// widget.cpp - goodbytes

#include "widget.h"
#include "debug.h"
#include "global.h"

Background::Background(std::string name, BITMAP* bmp)
 : Widget(name)
{
    tex = allegro_gl_make_texture(bmp);
}

Background::~Background()
{
    glDeleteTextures(1, &tex);
}

void Background::Render()
{
//    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, tex);
    glBegin(GL_QUADS);
        glTexCoord2f(0.0, 0.0);
        glVertex3f(-1.0, -1.0, -2.0);
        glTexCoord2f(1.0, 0.0);
        glVertex3f(1.0, -1.0, -2.0);
        glTexCoord2f(1.0, 1.0);
        glVertex3f(1.0, 1.0, -2.0);
        glTexCoord2f(0.0, 1.0);
        glVertex3f(-1.0, 1.0, -2.0);
    glEnd();
}

Link::Link(std::string name, float x, float y, FONT* f)
 : Widget(name), focus(false), x(x), y(y), font(f)
{
}

Link::~Link()
{
}

void Link::Render()
{
    allegro_gl_printf(font, x, y, -2.0, makecol(255, 255, focus ? 0 : 255),
        "%s", Translate(name));
    glColor4f(1.0, 1.0, 1.0, 1.0);
}

Slider::Slider(std::string name, float x, float y, int min, int max, FONT* f)
 : Widget(name), x(x), y(y), min(min), max(max), pos(0), focus(false), font(f)
{
    pos = get_config_int("config", name.c_str(), 0);
}

Slider::~Slider()
{
    set_config_int("config", name.c_str(), pos);
}

void Slider::Render()
{
    allegro_gl_printf(font, x, y, -2.0, makecol(255, 255, focus ? 0 : 255),
        "%s: <%d>", Translate(name), pos);
    glColor4f(1.0, 1.0, 1.0, 1.0);
}

Dialog::Dialog()
 : pos(0)
{
}

Dialog::~Dialog()
{
}

void Dialog::AddWidget(Widget* w)
{
    widgets.push_back(w);
}

bool Dialog::Run()
{
	bool esc = false;
    // Reality check
    if(widgets.size() == 0)
        return false;

    // Set the GUI view
    glPushMatrix();
    glDisable(GL_DEPTH_TEST);
    glColor4f(1.0, 1.0, 1.0, 1.0);

    // Give the first accepting widget in the dialog some focus
    pos = 0;
    for(int i = 0; i < (int)widgets.size(); ++i)
    {
        if(widgets[i]->GetFocus())
        {
            pos = i;
            break;
        }
    }

    // We don't need no stinking keypresses left in the buffer...
    clear_keybuf();

    // Run the dialog with... oh, that's right... an infinite loop.
    while(true)
    {
	    poll_keyboard();
        // Move up in the dialog
        if(key[KEY_UP])
        {
            for(int i = pos - 1; i >= 0; --i)
            {
                if(widgets[i]->GetFocus())
                {
                    widgets[pos]->LoseFocus();
                    pos = i;
                    break;
                }
            }
        }

        // Move down in the dialog
        if(key[KEY_DOWN])
        {
            for(int i = pos + 1; i < (int)widgets.size(); ++i)
            {
                if(widgets[i]->GetFocus())
                {
                    widgets[pos]->LoseFocus();
                    pos = i;
                    break;
                }
            }
        }

        // Leave the dialog
        if(key[KEY_ESC])
        {
		esc = true;
		break;
        }

        // Handle left & right menu movement
        if(key[KEY_RIGHT])
            widgets[pos]->Right();
        if(key[KEY_LEFT])
            widgets[pos]->Left();

        // Option selection
        if(key[KEY_SPACE] || key[KEY_ENTER])
        {
            if(widgets[pos]->Select())
                break;
        }

        // Render the dialog
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        for(int i = 0; i < (int)widgets.size(); ++i)
        {
            widgets[i]->Render();
        }
        glFlush();
        allegro_gl_flip();

        // Wait for a keypress
        clear_keybuf();
        while(!keypressed());
    }

    clear_keybuf();

    glPopMatrix();
    glEnable(GL_DEPTH_TEST);

    while (key[KEY_ENTER]||key[KEY_SPACE]) poll_keyboard();
    rest(10);
    clear_keybuf();

    return esc;
}

std::string Dialog::Last()
{
    return widgets[pos]->Name();
}



// MAIN MENU

int Menu(bool playing)
{


	glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR);
	//glDisable(GL_BLEND);
	int ret = 0;

//	BITMAP* bmp = load_bitmap("wall.bmp", 0);
    DATAFILE* fontdat = load_datafile("data/font.dat");
	FONT* f = allegro_gl_convert_allegro_font((FONT*)fontdat[0].dat, AGL_FONT_TYPE_TEXTURED, 400.0);

	if (!playing) { 	// if the player just started up the game
		Dialog language;
		Text text("SELECT LANGUAGE:", -.8, .5, f);
		Link link1("English", -.8, 0.0, f);
		Link link2("SPANISH", -.8, -.2, f);
		Link link3("FRENCH", -.8, -.4, f);
		Link link4("GERMAN", -.8, -.6, f);
		language.AddWidget(&text);
		language.AddWidget(&link1);
		language.AddWidget(&link2);
		language.AddWidget(&link3);
		language.AddWidget(&link4);
		bool esc = language.Run();
		if (esc) return 0;

		if (language.Last() != "English")
			g_english = false;
		else
			g_english = true;
	}


	while(true)
	{
		Dialog mm;
		Link link1("Continue", -0.8, 0.0, f);
		Link link4("Restart", -0.8, -0.2, f);
		Link link5("Play", -0.8, 0.0, f);

		//Background bg("background", bmp);
        std::vector<std::string> coolWords;
		coolWords.push_back("Fantastic");
		coolWords.push_back("Space");
		coolWords.push_back("Mutant");
		coolWords.push_back("Awesome");
		coolWords.push_back("Deranged");
		coolWords.push_back("Intergalactic");
		coolWords.push_back("Robotic");
		coolWords.push_back("Zombie");
		coolWords.push_back("Villainous");
		Text text("The " + coolWords[rand()%coolWords.size()] + " Virus", -0.8, 0.5, f);
		if (playing || get_config_int("config", "Level", 0)>0) {
			mm.AddWidget(&link1);
			mm.AddWidget(&link4);
		}
		else {
			mm.AddWidget(&link5);
		}
		Link link2("Options", -0.8, -0.4, f);
        Link link3("Help", -0.8, -0.6, f);
		Link link6("Quit", -0.8, -0.8, f);


		//mm.AddWidget(&bg);
		mm.AddWidget(&text);

		mm.AddWidget(&link2);
		mm.AddWidget(&link3);
        mm.AddWidget(&link6);
		bool esc = mm.Run();
		if (esc) return 0;

		if(mm.Last() == "Continue" || mm.Last() == "Play")
		{
			ret = 1;
			break;
		}
		if (mm.Last() == "Restart")
		{
			ret = -1;
			set_config_int("config", "Level", 0);
			break;
		}
		else if(mm.Last() == "Quit")
		{
			ret = 0;
			break;
		}
		else if(mm.Last() == "Options")
		{
	//		Background bg("background", bmp);
			Text text("options", -0.8, 0.5, f);
			Slider music("Music", -0.8, 0.0, 0, 10, f);
			Slider sound("Sound", -0.8, -0.2, 0, 10, f);
			Slider sensitivity("Sensitivity", -0.8, -0.4, 0, 10, f);
			Link link3("Back", -0.8, -0.8, f);

			Dialog opt;
	//		opt.AddWidget(&bg);
			opt.AddWidget(&text);
			opt.AddWidget(&music);
			opt.AddWidget(&sound);
			opt.AddWidget(&sensitivity);
			opt.AddWidget(&link3);
			opt.Run();
		}
        else if(mm.Last() == "Help")
        {
            Text help[]     =        {
                Text("Use the mouse and WASD", -0.9, 0.9, f),
                Text("or the arrow keys to move.", -0.85, 0.8, f),
                Text("Left-click or press space", -0.9, 0.7, f),
                Text("to fire a relaxation burst.", -0.85, 0.6, f),
                Text("Follow the green arrow", -0.9, 0.5, f),
                Text("to the end-of-level portal,", -0.85, 0.4, f),
                Text("but look out for the virus", -0.85, 0.3, f),
                Text("which spreads along the floor,", -0.85, 0.2, f),
                Text("and take notice of the stressed-out", -0.85, 0.1, f),
                Text("souls seeking relief from their angst.", -0.85, 0.0, f),
                Text("If your calmness level drops too much,", -0.9, -0.1, f),
                Text("you lose the game.", -0.85, -0.2, f),
                Text("Be mindful of stressful situations which", -0.9, -0.3, f),
                Text("can aversely affect your stress level,", -0.85, -0.4, f),
                Text("and take care to distinguish the", -0.85, -0.5, f),
                Text("chill pills from the panic pills.", -0.85, -0.6, f),
		Text("And look out for other powerups, too!", -0.9, -0.7, f),
		Text("Also, some walls can be destroyed.", -0.9, -0.8, f)
            };

            Link link("Back", -0.2, -0.9, f);
            Dialog hd;

            for(int i = 0; i < 18; ++i)
            {
                hd.AddWidget(&help[i]);
            }
            hd.AddWidget(&link);

            hd.Run();
        }
	}

//	destroy_bitmap(bmp);
	allegro_gl_destroy_font(f);
    unload_datafile(fontdat);

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//glEnable(GL_BLEND);
	return ret;
}
