#ifndef _LEVEL_H_
#define _LEVEL_H_

#include <vector>
#include <list>
#include <fstream>
#include <iostream>
#include <alleggl.h>

#include "anim.h"

enum ObjectType {ENEMY, BULLET, EBULLET, PORTAL, CHILLPILL, ENERGYPILL};

struct Object {
	ObjectType type;
	float x, y, angle;
	float vx, vy;
	int health;
	int duration;
	int stunned;
	int enemyNumber;
	int timeToBullet;
	Object(ObjectType type, float x, float y, float vx = 0, float vy = 0, int duration = 1, float angle = 0) : type(type), x(x), y(y), angle(angle), vx(vx), vy(vy), health(2), duration(duration), stunned(0), enemyNumber(0), timeToBullet(0) {}
};

struct Tile {
	int data;
	bool infected;
	int durationTillSpread;
	Tile (int data) : data(data), infected(false), durationTillSpread(30) {}
	Tile () : data(0), infected(false), durationTillSpread(30) {}
};

class Level {

	FONT* defaultFont;
	SAMPLE *hit, *otherHit;

	int dimX, dimY;

	int closestPortalX, closestPortalY;
	bool portalExists;

	std::vector<Tile> levelData;
	std::list<Object> objects;	// all objects with transp. kept in one list for convenient z-sorting in the future
	std::list<std::string> levelSequence;

	GLuint wall, weakwall, floor, virus, bullet, ebullet;
	Anim portal, pill, energy;
	std::vector<Anim> enemies;
	float sizefactor;

	float playerX, playerY, playerAngle;
	float playerHealth;
	float startHealth;
	int beingHit, beingHelped;
	int playerDying;
	int energyLevel, energyLevelDuration;

	void DrawFloor(int x, int y);
	void DrawWall(int x, int y, int data);
	void DrawBig(const Object &e, GLuint);
	void DrawBullet(const Object &b);
	void DrawSmall(const Object &e, GLuint tex);
	void DrawDirectionTip();
	void DrawHealth();
	void DrawPower(GLuint tex);
	bool Hitting(float x, float y, float range=.4);
	bool OnMonster(float x, float y);
	bool OnVirus(float x, float y, float range=.4);
	int toData(int x, int y);
	void InfectNeighbors( int i, int j );
	float zDist(float x, float y);

public:
	Level(char *file);

	void HandleInput();
	void HandleObjects();
	void SpreadVirus();

	void LoadTextfileMap(char *file);
	void LoadBitmapMap(const char *file);
	void LoadNextMap(int stayback);
	void DebugOut();

	void Collide(float oldx, float &x, float oldy, float &y, float range=.4);
	void Draw();
	~Level() {destroy_sample(hit); destroy_sample(otherHit); destroy_font(defaultFont);}
    bool IsFloor(int x, int y) { int n = toData(x, y); return n >= 0 && levelData[n].data == 0; }

friend	bool operator< ( Object A, Object B );
};

#endif
