#include <allegro.h>
#include <alleggl.h>
#include "init.h"


volatile int fps=0;
volatile int frame_count=0;

void frame_counter( void )
{

	fps=frame_count;
	frame_count=0;
}
END_OF_FUNCTION(frame_counter);

volatile int logic = 0;
void logic_counter( void )
{
	logic++;
}
END_OF_FUNCTION(logic_counter);

bool InitStandardAllegro()
{
	allegro_init();
	if (install_keyboard()<0) return false;
	if (install_mouse()<0) return false;
	if (!InitTimers()) return false;
	return true;
}

bool InitTimers()
{
	LOCK_VARIABLE(frame_count);
	LOCK_VARIABLE(fps);
	LOCK_FUNCTION(frame_counter);
	install_int(frame_counter,1000);
	LOCK_VARIABLE(logic);
	LOCK_FUNCTION(logic_counter);
	install_int(frame_counter,1000);
	install_int(logic_counter,1000/60);
	return true;
}

bool standardInit=false;
bool InitSimpleAGL()
{
	if (!standardInit)
	{
		InitStandardAllegro();
		install_allegro_gl();	// if calling init simple from init standard, we don't want
								//stuff set in init standard to get lost by this call
		allegro_gl_set(AGL_DOUBLEBUFFER, true);
		allegro_gl_set(AGL_COLOR_DEPTH, 16);
		allegro_gl_set (AGL_WINDOWED, TRUE);
		allegro_gl_set(AGL_SUGGEST, AGL_DOUBLEBUFFER | AGL_COLOR_DEPTH | AGL_WINDOWED);
	}

	if (set_gfx_mode(GFX_OPENGL, 800,  600, 0, 0) != 0) {
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Unable to set graphic mode\n%s\n", allegro_error);
		return false;
	}
	return true;
}

bool InitStandardAGL()
{
	standardInit = true; // see explanation in initsimpleagl()

	if (!InitStandardAllegro()) return false;
	install_allegro_gl();

	allegro_gl_clear_settings();
	allegro_gl_set (AGL_COLOR_DEPTH, 16);
	allegro_gl_set (AGL_Z_DEPTH, 16);
	allegro_gl_set (AGL_DOUBLEBUFFER, 1);
	allegro_gl_set (AGL_STENCIL_DEPTH, 0);
	allegro_gl_set (AGL_RENDERMETHOD, 1);
	allegro_gl_set (AGL_WINDOWED, TRUE);
	allegro_gl_set (AGL_SUGGEST, AGL_Z_DEPTH | AGL_DOUBLEBUFFER 
			| AGL_RENDERMETHOD | AGL_WINDOWED | AGL_COLOR_DEPTH);

	if (!InitSimpleAGL()) return false;

	glClearColor (0, 0, 0, 0);
	glEnable (GL_DEPTH_TEST);
	glCullFace (GL_BACK);
	glEnable (GL_CULL_FACE);

	return true;
}

bool InitLighting(GLfloat *LightAmbient, GLfloat *LightDiffuse, GLfloat *LightPosition)
{
	// put in a light
	glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);		// Setup The Ambient Light
	glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);		// Setup The Diffuse Light
	glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);	// Position The Light
	glEnable(GL_LIGHT1);								// Enable Light One
	glEnable(GL_LIGHTING);
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
	glEnable(GL_COLOR_MATERIAL);

	return true;
}


bool InitFog(float start=50.0, float end=150.0, float density=.02)
{
	// fog
	float fog_color[4] = { 0, 0, 0, 1.0 };
	glEnable(GL_FOG);
	glFogfv(GL_FOG_COLOR, fog_color);    
	glFogi(GL_FOG_MODE, GL_EXP2);
	glFogf(GL_FOG_DENSITY, density);
	glFogf(GL_FOG_START, start);
	glFogf(GL_FOG_END, end);

	return true;
}
