#include "anim.h"
#include "aglhelper.h"
#include <string>
#include "debug.h"

void Anim::Load(const char *file) {
	std::ifstream in(file);
	if (!in) throw "Failed to load anim file";
	in >> frameLength;
	timeTillNext = frameLength;
	current = 0;
	int quantity;
	in >> quantity;
	for (int i=0; i< quantity; i++) {
		std::string temp;
		in >> temp;
		DEBUGOUT(file << ": " << temp);
		frames.push_back(makeTexture(temp.c_str()));
	}
	in.close();
	loaded = true;
}

void Anim::Tick() {
	if (!loaded) return;
		
	timeTillNext--;
	if (timeTillNext <= 0) {
		timeTillNext = frameLength;
		current = (current+1)%frames.size();
	}
}

GLuint Anim::Grab() {
	if (!loaded) throw "Can't grab images from unloaded animation!";
	return frames[current];
}

GLuint Anim::Grab(int frame) {
	if (!loaded) throw "Can't grab images from unloaded animation!";
	return frames[frame];
}
