// widget.h - goodbytes
// VIRUS - The almighty GUI. All who are in its presence will tremble and weep!

#ifndef WIDGET_H
#define WIDGET_H

#include <allegro.h>
#include <alleggl.h>
#include <string>
#include <vector>

int Menu(bool playing);

// Your no-frills ADT Widget.

class Widget
{
public:
    Widget(std::string name) : name(name) {}
    virtual ~Widget() {};

    virtual void Render() = 0;

    virtual bool GetFocus() = 0;
    virtual void LoseFocus() = 0;
    virtual void Right() = 0;
    virtual void Left() = 0;
    virtual bool Select() = 0;

    std::string Name()  { return name; }

protected:
    std::string name;
};

// A background for the dialog.
class Background : public Widget
{
public:
    Background(std::string name, BITMAP* bmp);
    ~Background();

    void Render();

    bool GetFocus()     { return false; }
    void LoseFocus()    { }
    void Right()        { }
    void Left()         { }
    bool Select()       { return false; }

private:
    GLuint tex;
};

// A link to other menus.
class Link : public Widget
{
public:
    Link(std::string name, float x, float y, FONT* f);
    ~Link();

    void Render();

    bool GetFocus()     { focus = true; return true; }
    void LoseFocus()    { focus = false; }
    void Right()        { }
    void Left()         { }
    bool Select()       { return true; }

private:
    bool focus;
    float x, y;
    FONT* font;
};

// A way to select different options.
class Selector : public Widget
{
public:
    Selector(std::string name, float x, float y);
    ~Selector();

    void Render();

    bool GetFocus();
    void LoseFocus();
    void Right();
    void Left();
    bool Select();

private:
    float x, y;
    char* opt;
    int pos, max;
};

// Sliding between integers since 1986.
class Slider : public Widget
{
public:
    Slider(std::string name, float x, float y, int min, int max, FONT* f);
    ~Slider();

    void Render();

    bool GetFocus()     { focus = true; return true; }
    void LoseFocus()    { focus = false; }
    void Right()        { pos++; pos = MIN(pos, max); }
    void Left()         { pos--; pos = MAX(pos, min); }
    bool Select()       { return false; }

public:
    float x, y;
    int min, max;
    int pos;
    bool focus;
    FONT* font;
};

// Just some pretty text.
class Text : public Link
{
public:
    Text(std::string name, float x, float y, FONT* f)
     : Link(name, x, y, f) { }
    bool GetFocus() { return false; }
};

// The class that holds all widgets together in peace and harmony.
class Dialog
{
public:
    Dialog();
    ~Dialog();

    void AddWidget(Widget* w);
    bool Run();
    std::string Last();

private:
    std::vector<Widget*> widgets;
    int pos;
};

#endif

