/**
Helper debug macros allows easy DEBUGOUT to file when DEBUG is defined
*/

#ifndef _DEBUG_H_
#define _DEBUG_H_

#define DEBUG

#ifdef DEBUG
#include <fstream>
#define DEBUGOUT(blah) debug << "(" << __FILE__ << ":" << __LINE__ << ") " <<  blah << std::endl << std::flush;
#define DODEBUG(blah) blah
#else
#define DEBUGOUT(blah)
#define DODEBUG(blah)
#endif

#ifdef DEBUG
extern std::ofstream debug;
#endif

#endif
