/*

Copyright (c) 1999, 2002-2005    Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */


#include "all_inc.h"
#include <signal.h>
#include "zlog.h"





#ifdef ALLEGRO_LINUX
char * strsignal(int sig);
#else
#define strsignal(x) "(name not available)"
#endif

/** The signal handler. Cleans everything up before quitting the game.
*/
void zlog_signal_handler(int num)
{
        if(num != 11)
                fprintf(stderr, "Got signal %i (%s), quitting !\n", num, strsignal(num));
        else fprintf(stderr, "Message from Sgolne received ! (SIGSEGV)\n");
        fprintf(stderr, "Emergency exit : 1-fin_instances()..");
        fin_instances(0);
        fprintf(stderr, "OK\n  2-destroy_bitmap()'s..");
        destroy_bitmap(game_frame[0]);
        destroy_bitmap(game_frame[1]);
        destroy_bitmap(ecranv[0]);
        destroy_bitmap(ecranv[1]);
        fprintf(stderr, "OK\n 3-free(stars)..");
        free(stars);
        fprintf(stderr, "OK\n 4-allegro_exit()..");
        allegro_exit();
        fprintf(stderr, "OK\n 5-exit_logfac()..");
        exit_logfac();
        fprintf(stderr, "OK\nEmergency exit procedure ended, now exit(10)\n");
        exit(10);
}



int main(int argc, char **argv)
{
int L, l;

FILE *test;



set_uformat(U_ASCII);

allegro_init();
install_keyboard();
install_mouse();
/*install_timer();*/
install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

init_logfac();
loadpng_init();
	
set_color_conversion(COLORCONV_TOTAL | COLORCONV_KEEP_TRANS);
open_newlog("zlog_log.txt");

/* first rule handles common end-user information*/
ruletoadd.filedest=0;
ruletoadd.debuglvl=1;
ruletoadd.log_action=LOGTO_STDOUT;
add_rule(ruletoadd);

/* second rule handles more precise information*/
ruletoadd.filedest=0;
ruletoadd.debuglvl=2;
ruletoadd.log_action=LOGTO_FILE;
add_rule(ruletoadd);

/*the third rule is only added if --debuglevel is specified */
ruletoadd.filedest=0;
ruletoadd.debuglvl=3;
ruletoadd.log_action=LOGTO_STDOUT;


log_msg(1,"Zlog initialisation");
switch(os_type){
	case OSTYPE_WIN95 : 
	case OSTYPE_WIN98 :
	case OSTYPE_WINME :
	case OSTYPE_WINNT : 
	case OSTYPE_WIN2000 :
	case OSTYPE_WINXP :
	SET_GLOBAL_STATE(NO_PAGE_FLIP); log_msg(1, "Disabling pageflipping ! (default under Windows - override with --do-page-flip)");
	break;
	case OSTYPE_LINUX : log_msg(1, "Detected Linux-like OS. Great !"); break;
		}


log_msg(1,"{Zl0g} version number %s", VERSION);
log_msg(2,"Zlog %s", VERSION);
log_msg(1,"Using log file %s", "zlog_log.txt");
log_msg(1,"Using %s", allegro_id);  
parse_commandline(argc, argv);
 
log_msg(1,"Setting up Zlog signal handler");
signal(SIGABRT, zlog_signal_handler);
signal(SIGFPE, zlog_signal_handler);
signal(SIGILL, zlog_signal_handler);
signal(SIGSEGV, zlog_signal_handler);
signal(SIGTERM, zlog_signal_handler);
signal(SIGINT, zlog_signal_handler);
#ifdef ALLEGRO_LINUX
signal(SIGQUIT, zlog_signal_handler);
#endif


if(config_file[0])
    {
    log_msg(2,"Checking if \"%s\" is present...",config_file);
    test = fopen(config_file,"r");
	if(test == NULL){
	    log_msg(0,"Unable to open configfile %s",config_file);
	    exit(-1);
	    }
	else{
	    fclose(test);
	    log_msg(2,"OK");
	    }
    }



log_msg(1,"Parsing configfile");
retr_cfg(config_file);


log_msg(2,"Defining default resolution 800*600");    
if(!RESOL_X)
    RESOL_X = 800;
if(!RESOL_Y)
    RESOL_Y = 600;



log_msg(1,"Requesting refresh rate, and calling set_gfx_mode()");


request_refresh_rate(85);
log_msg(3,"Refresh rate requested : 85Hz");


bpp = 16;

if(ask_gfx)
	{
	log_msg(3,"set_gfx_mode(GFX_SAFE, 320, 240, 0, 0)");
	if (set_gfx_mode(GFX_SAFE, 320, 240, 0, 0) != 0) {
    	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    	allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
    	return 1;
   		}

	rectfill(screen,1,1,800,600,4);


	log_msg(2,"Calling gfx_mode_select_ex() !");
	if (!gfx_mode_select_ex(&gfxmode, (int*)&RESOL_X, (int*)&RESOL_Y, &bpp)) {
    	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
  		allegro_message("Error setting graphics mode\n%s\n", allegro_error);
    	return 1;
   		}


	} /*ask_gfx*/
	
log_msg(1,"Requesting mode %i %i*%i %i bpp", gfxmode, RESOL_X, RESOL_Y, bpp);
 #ifdef ALLEGRO_MINGW32
extern int page_flip;
if(gfxmode == GFX_GDI)
    page_flip = 0;
#endif

set_color_depth(bpp);
#ifdef ALLEGRO_MINGW32

if( set_gfx_mode(gfxmode, RESOL_X, RESOL_Y, 0, 0) != 0)
   	{
   	log_msg(2,"set_gfx_mode(gfxmode, RESOL_X, RESOL_Y, 0, 0) failed, using another driver.");
   	if (set_gfx_mode(GFX_SAFE, RESOL_X, RESOL_Y, 0, 0) != 0) 
   	    {
   	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   	    allegro_message("Error setting graphics mode\n%s\n", allegro_error);
   	    return 1;
   	    }
   	}
#else

if( set_gfx_mode(gfxmode, RESOL_X, RESOL_Y, 0, 2*RESOL_Y) != 0)
   	{
   	log_msg(2,"set_gfx_mode(c, RESOL_X, RESOL_Y, 0, 2*RESOL_Y) failed, using another driver.");
   	if (set_gfx_mode(GFX_SAFE, RESOL_X, RESOL_Y, 0, 0) != 0) 
   	    {
   	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   	    allegro_message("Error setting graphics mode\n%s\n", allegro_error);
   	    return 1;
   	    }
   	}
#endif



log_msg(3,"set_gfx_mode() is okay ! Enjoy GFX :)");
log_msg(2, "Setting color values");
RED = makecol(255, 0, 0);
DARKRED = makecol(127, 0, 0);
GREEN = makecol(0, 255, 0);
BLUE = makecol(0, 0, 255);
WHITE = makecol(255, 255, 255);
GREY = makecol(50, 50, 50);
CYAN = makecol(0, 255, 255);
YELLOW = makecol(255, 255, 0);


log_msg(2, "Generating background");
int backgenx;
int backgeny;
int stars_rot=0;
background_offset_x = 0;
background_offset_y = 0;
stars = (star *) calloc(1000, sizeof(star));
nombre_stars = 0;
for(backgenx=0; backgenx < 384; backgenx ++)
        for(backgeny = 0; backgeny < 384; backgeny ++)
                if(((rand()) & 0xFF) == 255 && ((rand()) & 0xFF) > 190) 
                        {
                        
                        if(stars_rot >= 1000)
                                break;
                        stars[stars_rot].x = backgenx;
                        stars[stars_rot].y = backgeny;
                        if(bpp != 32)
                                stars[stars_rot].color = rand() & ((1 << bpp) - 1);
                        else stars[stars_rot].color = rand() & ((1 << 24) - 1);
                        stars_rot ++;
                        nombre_stars ++;
                                
                        }
extern BITMAP * saucer_spr;
//saucer_spr = load_bitmap("saucer.bmp", NULL);
		saucer_spr = load_png("saucer.png", NULL);
log_msg(2,"Creating memory pages");
if(!TEST_GLOBAL_STATE(NO_PAGE_FLIP))
{
    log_msg(3,"Pages are video bitmaps");
    ecranv[0]=create_video_bitmap(RESOL_X,RESOL_Y);
    ecranv[1]=create_video_bitmap(RESOL_X,RESOL_Y);
}


else
{
    log_msg(3,"Pages are memory bitmaps");
    ecranv[0]=create_bitmap(RESOL_X,RESOL_Y);
    ecranv[1]=create_bitmap(RESOL_X,RESOL_Y);
}

if(!ecranv[0]&&!ecranv[1])
    {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    
    log_msg(0,"Error with bitmaps : %s",allegro_error);
    return 2;
    }
    
if(is_memory_bitmap(ecranv[0]))
    {
    log_msg(2,"Clearing bitmaps");
    clear_bitmap(ecranv[0]);
    clear_bitmap(ecranv[1]);
    }

log_msg(2,"Frame init.");
init_frame();

L=zlogframe.L;
l=zlogframe.l;

log_msg(2,"Creating subbitmaps");
game_frame[0] = create_sub_bitmap(ecranv[0], 1, 1, L, l);
game_frame[1] = create_sub_bitmap(ecranv[1], 1, 1, L, l);
log_msg(2,"Game_frame is okay");
/*console_frame[0] = create_sub_bitmap(game_frame[0], 1, 1, L, zl_console.console_size);
console_frame[1] = create_sub_bitmap(game_frame[1], 1, 1, L, zl_console.console_size);
log_msg(2, "Console_frame is okay");*/

if(!game_frame[0] && !game_frame[1])
    {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    
    log_msg(0,"Error with bitmaps : %s",allegro_error);
    return 3;
    }
    

if(is_memory_bitmap(game_frame[0])/* && is_memory_bitmap(console_frame[0])*/)
    {
    log_msg(2,"Clearing subbitmaps");
    clear_bitmap(game_frame[0]);
    clear_bitmap(game_frame[1]);
    /*clear_bitmap(console_frame[0]);
    clear_bitmap(console_frame[1]);*/
    }


log_msg(2, "Setting entry points for realtime (game) mode");
get_input = get_keypress;
display_world = display_all;
update_world = realtime_update_world;    
log_msg(1, "Running campaign");
run_campaign();


log_msg(2, "Free-ing memory");
fin_instances(0);
free(stars);
log_msg(2, "Destroying bitmaps");
/*log_msg(3, "Console frame subbitmap");
destroy_bitmap(console_frame[0]);
destroy_bitmap(console_frame[1]);*/
log_msg(3, "Game frame subbitmap");
destroy_bitmap(game_frame[0]);
destroy_bitmap(game_frame[1]);
log_msg(3, "Virtual screen");
destroy_bitmap(ecranv[0]);
destroy_bitmap(ecranv[1]);

log_msg(1,"Exiting Allegro");
allegro_exit();

log_msg(1,"Exiting logging facility then returning 0");
exit_logfac(); 
return 0;
}
END_OF_MAIN()

/** Initialisation of the game frame. Sets up the game screen according to the resolution choosed.
*/
void init_frame()
{
zlogframe.cadrehg.x=1;
zlogframe.cadrehg.y=1;


zlogframe.cadrebd.x=RESOL_X-1;
zlogframe.cadrebd.y=RESOL_Y-100;
zlogframe.L=abs(zlogframe.cadrehg.x-zlogframe.cadrebd.x);
zlogframe.l=abs(zlogframe.cadrehg.y-zlogframe.cadrebd.y);

GAMESCR_RESOL_X = zlogframe.L;
GAMESCR_RESOL_Y = zlogframe.l;

}

/** Initialisation of player-related data. This function is does absolutely nothing except at some points in the development. It's a developer helper.
*/
void init_player()
{
}

/** Initialisation of wall-related data. This function is does absolutely nothing except at some points in the development. It's a developer helper.
*/
void init_walls()
{
}


	
/** Free the main object structure and optionally the engine data.
@param target 0 to destroy everything (before quitting), nonzero to destroy only level-related data, which enables runtime level loading
*/
void fin_instances(int target)
{

/*destroy only level-related structures*/        
free_player_database(obj_db.liveplayer_head);
free_player_database(obj_db.enemy_head);
free_wall_database(obj_db.wall_head);
free_livewall_database(obj_db.livewall_head);
free_killing_line_database(obj_db.killing_line_head);
free_portal_database(obj_db.portal_head);
free(obj_db.madmaker_head);
free_banana_database(obj_db.banana_head);
if(music != NULL)
		destroy_midi(music);
music = NULL;
obj_db.madmaker_head = NULL;
obj_db.liveplayer_head = NULL;
obj_db.enemy_head = NULL;
obj_db.wall_head = NULL;
obj_db.livewall_head = NULL;
obj_db.killing_line_head = NULL;
obj_db.portal_head = NULL;
obj_db.banana_head = NULL;	
if(target == 0) 
        /*destroy everything*/
        {
        for(int i=0; i < 15; i++)
                if(pl_kbinds[i])
                        {
                        free(pl_kbinds[i]);
                        pl_kbinds[i] = NULL;
                        }
        free_spritesetdb(spriteset_db);
	free_soundsetdb(soundset_db);
        }
        
}

