/*

Copyright (c) 2004      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "all_inc.h"

static char must_handle_zignals=0;





/** Send a zignal to the object. A zignal is short for Zlog sIGNAL, it's like a POSIX signal, but sent to an object rather than a process, and with parameters.
@param target is a pointer to the zignal list of an object
@param zignal_to_raise is the number of the zignal to raise
@param zparm is the parameter of the zignal
@param zbmask is the bitfield parameter of the zignal
@return nonzero on error.
*/
int raise_zignal(zignals_t *target, short int zignal_to_raise, int zparm, int zbmask)
{

/*log_msg(3,  "raise_zignal %x %i i %i", target, zignal_to_raise, zparm, zbmask);*/

/*zignal_to_raise est sous forme d'une num DONC il faut faire le dcalage*/
if(zignal_to_raise > 15)
        return -1;

short int zignal_to_raise_bmask = 1 << zignal_to_raise;

/*log_msg(3,  "Signal mask : %i", zignal_to_raise_bmask);*/
target->mask |= zignal_to_raise_bmask;

target->parm[zignal_to_raise][0] = zparm;
target->parm[zignal_to_raise][1] = zbmask;

if(must_handle_zignals)
        {
        must_handle_zignals=0;
        call_zignal_handlers();
        }
else must_handle_zignals=1;

return 0;
}
 
 
 
/** Remove a zignal. UNUSED
@param target is a pointer to the zignal list of an object
@param zignal_to_rmv is the number of the zignal to remove
@return Returns always 0.
*/
int remove_zignal(zignals_t *target, short int zignal_to_rmv)
{
if(zignal_to_rmv > 15)
        return -1;
short int zignal_to_rmv_bmask = 1 << zignal_to_rmv;

target->mask &= ~zignal_to_rmv_bmask;
target->parm[zignal_to_rmv][0]=0;
target->parm[zignal_to_rmv][1]=0;
return 0;
}


/** Call all the zignal handlers of all objects. The zignals won't work without this.
*/
void call_zignal_handlers() 
{
int i;
liveplayer * plrot;
for(i = 0; i < 2; i ++)
	{
	if(!i) plrot = obj_db.liveplayer_head;
	else plrot = obj_db.enemy_head;
	
	while(plrot)
		{
		if(plrot->zignals.mask)
			handle_player_zignals(plrot);
		plrot = GETNEXT(plrot);
		}
	}

livewall * lwlrot = obj_db.livewall_head;

while(lwlrot)
	{
	if(lwlrot->zignals.mask)
		handle_lwall_zignals(lwlrot);
	lwlrot = GETNEXT(lwlrot);
	}
}

/** The player zignal handler.
*/
int handle_player_zignals(liveplayer * pltarget)
{
zignals_t *target = &(pltarget->zignals);

if(target->mask & (1 << ZIGNAL_COLLISION_N))
        {
        /*printf("Collision nord\n");*/
        }
if(target->mask & (1 << ZIGNAL_COLLISION_S))
        {
        }
if(target->mask & (1 << ZIGNAL_COLLISION_E))
        {
        /*rintff("Collision est\n");*/
        }
if(target->mask & (1 << ZIGNAL_COLLISION_W))
        {
        /*printf("Collision ouest\n");*/
        }
if(target->mask & (1 << ZIGNAL_PLAYER_INCOMING))
        {
        if(pltarget->effectors.armed & PLEFFECTOR_MOVE_ENNEMY)
                {
                pltarget->effectors.is_active |= PLEFFECTOR_MOVE_ENNEMY;
                pltarget->effectors.armed &= ~PLEFFECTOR_MOVE_ENNEMY;
                }
	switch(target->parm[ZIGNAL_PLAYER_INCOMING][1])
                {
                case 0 : /*this is a player*/
                        pltarget->target = TARGET_PLAYER(target->parm[ZIGNAL_PLAYER_INCOMING][0]); break;
                case 1 : /*this is an enemy*/
                        pltarget->target = TARGET_ENEMY(target->parm[ZIGNAL_PLAYER_INCOMING][0]); break;
                }
        log_msg(3, "Player targets %i", pltarget->target);
        }
        
if(target->mask & (1 << ZIGNAL_PLAYER_GETTINGAWAY))
        {
        if(pltarget->effectors.is_active & PLEFFECTOR_MOVE_ENNEMY)
                {
                pltarget->effectors.is_active &= ~PLEFFECTOR_MOVE_ENNEMY;
                pltarget->effectors.armed |= PLEFFECTOR_MOVE_ENNEMY;
                }
	switch(target->parm[ZIGNAL_PLAYER_GETTINGAWAY][1])
                {
                case 0 : /*this is a player*/
                        if(pltarget->target == TARGET_PLAYER(target->parm[ZIGNAL_PLAYER_INCOMING][0]))
                                pltarget->target = 0; break;
                case 1 : /*this is an enemy*/
                        if(pltarget->target == TARGET_ENEMY(target->parm[ZIGNAL_PLAYER_INCOMING][0]))
                                pltarget->target = 0; break;
                }
        log_msg(3, "Player targets %i", pltarget->target);
        }
        
if(target->mask & (1 << ZIGNAL_GOT_HURT))
        {
        if(!(pltarget->state & ZL_PLAYER_INVINCIBLE))
                {
                pltarget->state |= ZL_PLAYER_INVINCIBLE;
                pltarget->trigger_flagmask = -ZL_PLAYER_INVINCIBLE;
                log_msg(3,"player got hurt, setting alarm");
                add_scheduler_fnct(alarm_zignal, PLEFFECTOR_TRIGGER_FLAG, &pltarget->zignals, 150, "player hurt invincibility counter");
                }
        }
        
        
if(target->mask & (1 << ZIGNAL_ALARM))
        {
                if(target->parm[ZIGNAL_ALARM][0] == PLEFFECTOR_TRIGGER_FLAG)
                        {
                        log_msg(3, "Received alarm, triggering flags..");
                        if(pltarget->trigger_flagmask > 0)
                                pltarget->state |= pltarget->trigger_flagmask;
                        if(pltarget->trigger_flagmask < 0)
                                pltarget->state &= ~(-pltarget->trigger_flagmask);
                        pltarget->trigger_flagmask = 0;
                        }
        }
        
target->mask=0;
return 0;
}

/** The livewall zignal handler.
*/
int handle_lwall_zignals(livewall * target)
{
/*les signaux sont traits un par un, le concept auto rarm dans un tableau aurait fonctionn
pour les pointeurs de fonctions (donc peut tre pour les acteurs,  voir plus tard) 
mais pas ici
le rarmement doit tre dcid par le type d'objet (template) ou directement dans le code
hardcod dans un premier temps jusqu' l'implmentation des templates*/

if(target->zignals.mask & (1 << ZIGNAL_COLLISION_N))
        {
        /*printf("Collision nord\n");*/
        if(target->effectors.armed & LWLEFFECTOR_TRIGGER_FLAG)
                {
                if(target->trigger_flagmask > 0)
                        target->parms |= target->trigger_flagmask;
                else 
                        target->parms &= ~(-target->trigger_flagmask);
                /*une fois activ, s'auto-dsarme*/
                target->effectors.armed &= ~LWLEFFECTOR_TRIGGER_FLAG;
                }
        }
if(target->zignals.mask & (1 << ZIGNAL_COLLISION_S))
        {
        if(target->effectors.armed & LWLEFFECTOR_TRIGGER_FLAG)
                {
                if(target->trigger_flagmask > 0)
                        target->parms |= target->trigger_flagmask;
                else 
                        target->parms &= ~(-target->trigger_flagmask);
                /*une fois activ, s'auto-dsarme*/
                target->effectors.armed &= ~LWLEFFECTOR_TRIGGER_FLAG;
                }
        }
if(target->zignals.mask & (1 << ZIGNAL_COLLISION_E))
        {
        }
if(target->zignals.mask & (1 << ZIGNAL_COLLISION_W))
        {
        }
if(target->zignals.mask & (1 << ZIGNAL_LWLMOVE_BOUND))
        {
                if(target->template == ZL_TEMPLATE_ELEVATOR)
                        {
                        target->parms |= LWL_NOMOVE; /*on stoppe le mvt*/
                        target->trigger_flagmask = - LWL_NOMOVE;
                        add_scheduler_fnct(alarm_zignal, LWLEFFECTOR_TRIGGER_FLAG, &target->zignals, 200, "elevator pause");
                        }
        }

if(target->zignals.mask & (1 << ZIGNAL_ALARM))
        {
                if(target->zignals.parm[ZIGNAL_ALARM][0] == LWLEFFECTOR_TRIGGER_FLAG)
                        {
                        if(target->trigger_flagmask > 0)
                                target->parms |= target->trigger_flagmask;
                        else 
                                target->parms &= ~(-target->trigger_flagmask);
                        }
                if(target->zignals.parm[ZIGNAL_ALARM][0] == LWLEFFECTOR_SZVAR_REAPPEAR)
                        {
                        target->parms |=  LWL_SIZE_VAR;
                        }
                                        
        }
target->zignals.mask=0;
return 0;
}

/************************************/
/*int zalarm(zignals_t *, int, int, int) : 
raises an alarm

The alarm works as follows : 
time is the delay before ZIGALARM is raised (cool name heh !)
parm1 is the effector to be called 
parm2 is a parameter for the effector
*/
/**************************************/

/** ZIGALARM sender. Called by the scheduler.
*/
void alarm_zignal(int time, int parm, void * target_b)
{
zignals_t * target = (zignals_t *)(target_b);

/*printf("Alarm_zignal timing ... %i\n", time);*/
if(time == 1)
        {
        raise_zignal(target, ZIGNAL_ALARM , parm, 0);
        }
}
        
        
